/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.entity.MovingThrownProjectile;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IKeyBindInterface;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.ColorHelper;

public class AbilityFireBreathing
extends Ability
implements IKeyBindInterface {
    protected double breathStage = 0.0;

    public AbilityFireBreathing() {
        super("fire_breathing");
    }

    protected boolean DragonBreath(Entity entity) {
        if (this.isSpectator(entity)) {
            return false;
        }
        if (this.breathStage > 3.0) {
            this.breathStage = 0.0;
        }
        if (this.breathStage == 0.0) {
            MagicStats magic = Capabilities.getMagicStats(entity);
            if (magic != null && !magic.spendMana(TrinketsConfig.SERVER.races.dragon.breath_cost)) {
                return false;
            }
            int bcolor = Capabilities.getEntityProperties(entity, 0xFF0000, (prop, color) -> ColorHelper.convertHexadecimalToDecimal(prop.getRaceHandler().getAltTraitColor()));
            World world = entity.func_130014_f_();
            float headPosX = (float)(entity.field_70165_t + (double)0.54f * Math.cos((double)(entity.field_70177_z + 90.0f) * Math.PI / 180.0));
            float headPosZ = (float)(entity.field_70161_v + (double)0.54f * Math.sin((double)(entity.field_70177_z + 90.0f) * Math.PI / 180.0));
            float headPosY = (float)(entity.field_70163_u + (double)entity.func_70047_e() * 0.8);
            double d2 = entity.func_70040_Z().field_72450_a;
            double d3 = entity.func_70040_Z().field_72448_b;
            double d4 = entity.func_70040_Z().field_72449_c;
            world.func_184148_a((EntityPlayer)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187527_aQ, SoundCategory.PLAYERS, 0.5f, 0.4f / (Reference.random.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                MovingThrownProjectile breath = new MovingThrownProjectile(entity.func_130014_f_(), (EntityLivingBase)entity, d2, d3, d4, bcolor);
                breath.func_70107_b(headPosX, headPosY, headPosZ);
                breath.func_184547_a(entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 1.5f, 0.0f);
                world.func_72838_d((Entity)breath.setColor(bcolor));
            }
        }
        this.breathStage += 1.0;
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        return ModKeyBindings.RACE_ABILITY.getDisplayName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getAuxKey() {
        return ModKeyBindings.AUX_KEY.getDisplayName();
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        MagicStats magic = Capabilities.getMagicStats(entity);
        if (magic != null) {
            return magic.getMana() >= TrinketsConfig.SERVER.races.dragon.breath_cost;
        }
        return true;
    }

    @Override
    public boolean onKeyDown(Entity entity, boolean Aux) {
        return this.DragonBreath(entity);
    }

    @Override
    public boolean onKeyRelease(Entity entity, boolean Aux) {
        if (this.breathStage != 0.0) {
            this.breathStage = 0.0;
        }
        return true;
    }
}

