/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.faelis;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.client.model.FaelisEars;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.faelis.config.FaelisConfig;
import xzeroair.trinkets.traits.abilities.AbilityClimbing;
import xzeroair.trinkets.traits.statuseffects.StatusEffectsEnum;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.AttributeHelper;
import xzeroair.trinkets.util.helpers.ColorHelper;
import xzeroair.trinkets.util.helpers.DrawingHelper;

public class RaceFaelis
extends EntityRacePropertiesHandler {
    public static FaelisConfig serverConfig = TrinketsConfig.SERVER.races.faelis;
    protected UpdatingAttribute movement;
    protected UpdatingAttribute jump;
    private FaelisEars ears = new FaelisEars();
    public static final ResourceLocation TEXTURE = new ResourceLocation("xat:textures/ears.png");
    public static final ResourceLocation TEXTURE_INNER = new ResourceLocation("xat:textures/inner_ears.png");
    public static final ResourceLocation TEXTURE_OUTER = new ResourceLocation("xat:textures/outer_ears.png");

    public RaceFaelis(@Nonnull EntityLivingBase e) {
        super(e, EntityRaces.faelis);
        this.movement = new UpdatingAttribute(UUID.fromString("1c9ba72a-a558-4ccc-a997-777bf3a9859a"), SharedMonsterAttributes.field_111263_d).setSavedInNBT(false);
        this.jump = new UpdatingAttribute(UUID.fromString("1c9ba72a-a558-4ccc-a997-777bf3a9859a"), JumpAttribute.Jump).setSavedInNBT(false);
    }

    @Override
    public void startTransformation() {
        this.addAbility(new AbilityClimbing());
    }

    @Override
    public void whileTransformed() {
        if (this.entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean hasMilkBuff = false;
        if (TrinketsConfig.SERVER.races.faelis.penalties) {
            double amount = 0.0;
            StatusHandler status = Capabilities.getStatusHandler((Entity)this.entity);
            if (status != null) {
                hasMilkBuff = status.getActiveEffects().containsKey(StatusEffectsEnum.Invigorated.getName());
            }
            if (TrinketsConfig.SERVER.races.faelis.penalties) {
                try {
                    for (ItemStack stack : this.entity.func_184209_aF()) {
                        Item item = stack.func_77973_b();
                        String regName = item.getRegistryName().toString();
                        String itemType = ConfigHelper.ArmorEntry.getItemType(stack);
                        if (itemType.isEmpty()) continue;
                        String ItemMaterial = ConfigHelper.ArmorEntry.getItemMaterial(stack).toLowerCase();
                        if (item instanceof ItemArmor) {
                            ItemArmor armor = (ItemArmor)item;
                            String armorType = armor.field_77881_a.func_188450_d();
                            ConfigHelper.ArmorEntry entry = ConfigHelper.TrinketConfigStorage.getEquipmentEntry(regName + ":" + armorType, regName, "ObjectMaterial:" + ItemMaterial + ":" + armorType, "ObjectMaterial:" + ItemMaterial);
                            if (entry == null) continue;
                            amount -= entry.getEquipmentWeight();
                            continue;
                        }
                        String hand = stack.func_77969_a(this.entity.func_184614_ca()) ? "mainhand" : (stack.func_77969_a(this.entity.func_184592_cb()) ? "offhand" : "hand");
                        String[] mS = new String[]{regName + ":" + hand, regName, "ObjectMaterial:" + ItemMaterial + ":" + hand + ":" + itemType, "ObjectMaterial:" + ItemMaterial + ":" + hand + ":tool", "ObjectMaterial:" + ItemMaterial + ":hand:" + itemType, "ObjectMaterial:" + ItemMaterial + ":hand:tool", "ObjectMaterial:" + ItemMaterial + ":" + itemType, "ObjectMaterial:" + ItemMaterial + ":tool", "ObjectMaterial:" + ItemMaterial + ":" + hand, "ObjectMaterial:" + ItemMaterial + ":hand", "ObjectMaterial:" + ItemMaterial};
                        ConfigHelper.ArmorEntry main = ConfigHelper.TrinketConfigStorage.getEquipmentEntry((k, v) -> v.doesItemMatchEntry(stack), mS);
                        double mW = main == null ? 0.0 : main.getEquipmentWeight();
                        amount -= mW;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (amount != 0.0 && !hasMilkBuff) {
                this.movement.addModifier(this.entity, amount, 2);
                this.jump.addModifier(this.entity, amount, 2);
            } else {
                this.movement.removeModifier(this.entity);
                this.jump.removeModifier(this.entity);
            }
        } else {
            this.movement.removeModifier(this.entity);
            this.jump.removeModifier(this.entity);
        }
    }

    @Override
    public void endTransformation() {
        AttributeHelper.removeAttributes(this.entity, UUID.fromString("1c9ba72a-a558-4ccc-a997-777bf3a9859a"));
    }

    @Override
    public float hurtEntity(EntityLivingBase target, DamageSource source, float dmg) {
        if (!(source instanceof EntityDamageSourceIndirect || source.func_94541_c() || source.func_82725_o() || source.func_76352_a() || !(dmg > 0.0f))) {
            ItemStack stack1 = this.entity.func_184614_ca();
            ItemStack stack2 = this.entity.func_184592_cb();
            if (stack1.func_190926_b() && stack2.func_190926_b()) {
                dmg = (float)((double)dmg + RaceFaelis.serverConfig.bonus);
            }
        }
        return dmg;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderLayer(RenderLivingBase renderer, boolean isFake, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!TrinketsConfig.CLIENT.rendering || !this.showTraits()) {
            return;
        }
        GlStateManager.func_179094_E();
        if (this.entity.func_70093_af()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.2, (double)0.0);
        }
        if (renderer instanceof RenderPlayer) {
            RenderPlayer rend = (RenderPlayer)renderer;
            rend.func_177087_b().field_78116_c.func_78794_c(scale);
        }
        if (this.entity.func_190630_a(EntityEquipmentSlot.HEAD)) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.02f, (float)-0.045f);
            GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
        }
        float[] rgb = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getAltTraitColor() : this.getTraitColor());
        float[] rgb2 = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getTraitColor() : this.getAltTraitColor());
        float fscale = 0.3f;
        GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        double x = 0.0;
        double y = -2.5;
        double z = -0.72;
        double height = 1.0;
        double width = 1.0;
        float u = 32.0f;
        float v = 0.0f;
        int uWidth = 16;
        int vHeight = 16;
        float tileWidth = 64.0f;
        float tileHeight = 32.0f;
        double xR = -0.3;
        double xL = 0.3;
        float rot = 26.0f;
        int solidVariant = 2;
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179114_b((float)(-rot), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, -0.3, -2.5, -0.72, 32.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE, -0.3, -2.5, -0.7199, 32.0f, 16.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_INNER, -0.3, -2.5, -0.72, 32.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_OUTER, -0.3, -2.5, -0.72, 32.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_OUTER, -0.3, -2.5, -0.7199, 32.0f, 16.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179114_b((float)(rot * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, 0.3, -2.5, -0.72, 32.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE, 0.3, -2.5, -0.7199, 32.0f, 16.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_INNER, 0.3, -2.5, -0.72, 32.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_OUTER, 0.3, -2.5, -0.72, 32.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_OUTER, 0.3, -2.5, -0.7199, 32.0f, 16.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

