/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xzeroair.trinkets.Registries;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EmptyHandler;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.RaceAttributesWrapper;
import xzeroair.trinkets.races.dragon.RaceDragon;
import xzeroair.trinkets.races.dragon.RaceDragonAttributes;
import xzeroair.trinkets.races.dwarf.RaceDwarf;
import xzeroair.trinkets.races.dwarf.RaceDwarfAttributes;
import xzeroair.trinkets.races.elf.RaceElf;
import xzeroair.trinkets.races.elf.RaceElfAttributes;
import xzeroair.trinkets.races.faelis.RaceFaelis;
import xzeroair.trinkets.races.faelis.RaceFaelisAttributes;
import xzeroair.trinkets.races.fairy.RaceFairy;
import xzeroair.trinkets.races.fairy.RaceFairyAttributes;
import xzeroair.trinkets.races.goblin.RaceGoblin;
import xzeroair.trinkets.races.goblin.RaceGoblinAttributes;
import xzeroair.trinkets.races.human.RaceHuman;
import xzeroair.trinkets.races.titan.RaceTitan;
import xzeroair.trinkets.races.titan.RaceTitanAttributes;
import xzeroair.trinkets.traits.elements.IElementProvider;
import xzeroair.trinkets.util.TrinketsConfig;

public class EntityRace
extends IForgeRegistryEntry.Impl<EntityRace>
implements IElementProvider {
    public static final ForgeRegistry<EntityRace> Registry = Registries.getRaceRegistry();
    protected final UUID uuid;
    protected final String name;
    protected int primaryColor = 0x323232;
    protected int secondaryColor = 0xFFFFFF;
    protected int magicAffinityValue = 100;
    protected int raceHeight = 100;
    protected int raceWidth = 100;
    protected boolean canFly = false;

    private EntityRace(String name, String uuid, int color1, int color2, boolean internal) {
        this(name, uuid, color1, color2);
        this.setRegistryName(name);
    }

    public EntityRace(String name, String uuid, int color1, int color2) {
        this.name = name;
        this.uuid = UUID.fromString(uuid);
        this.primaryColor = color1;
        this.secondaryColor = color2;
    }

    public static int getIdFromRace(EntityRace race) {
        return race == null ? 0 : Registry.getID((IForgeRegistryEntry)race);
    }

    public static EntityRace getRaceById(int id) {
        return (EntityRace)Registry.getValue(id);
    }

    public static EntityRace getByUUID(UUID uuid) {
        for (EntityRace race : Registry.getValuesCollection()) {
            if (race.getUUID().compareTo(uuid) != 0) continue;
            return race;
        }
        return EntityRaces.none;
    }

    @Nullable
    public static EntityRace getByNameOrId(String id) {
        EntityRace race = (EntityRace)Registry.getValue(new ResourceLocation(id.toLowerCase()));
        if (race == null) {
            try {
                return EntityRace.getRaceById(Integer.parseInt(id));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return race;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getRaceHeight() {
        return this.raceHeight;
    }

    public EntityRace setRaceHeight(int raceHeight) {
        this.raceHeight = raceHeight;
        return this;
    }

    public int getRaceWidth() {
        return this.raceWidth;
    }

    public EntityRace setRaceWidth(int raceWidth) {
        this.raceWidth = raceWidth;
        return this;
    }

    public EntityRace setRaceSize(int sizeV) {
        return this.setRaceHeight(sizeV).setRaceWidth(sizeV);
    }

    public int getMagicAffinity() {
        return this.magicAffinityValue;
    }

    public EntityRace setMagicAffinity(int magicAffinity) {
        this.magicAffinityValue = magicAffinity;
        return this;
    }

    public boolean canFly() {
        return this.canFly;
    }

    public EntityRace setCanFly(boolean canFly) {
        this.canFly = canFly;
        return this;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public EntityRacePropertiesHandler getRaceHandler(EntityLivingBase e) {
        switch (this.name) {
            case "Fairy": {
                return new RaceFairy(e);
            }
            case "Dwarf": {
                return new RaceDwarf(e);
            }
            case "Titan": {
                return new RaceTitan(e);
            }
            case "Goblin": {
                return new RaceGoblin(e);
            }
            case "Elf": {
                return new RaceElf(e);
            }
            case "Faelis": {
                return new RaceFaelis(e);
            }
            case "Dragon": {
                return new RaceDragon(e);
            }
            case "Human": {
                return new RaceHuman(e);
            }
        }
        return new EmptyHandler(e);
    }

    public RaceAttributesWrapper getRaceAttributes() {
        switch (this.name) {
            case "Fairy": {
                return new RaceFairyAttributes();
            }
            case "Dwarf": {
                return new RaceDwarfAttributes();
            }
            case "Titan": {
                return new RaceTitanAttributes();
            }
            case "Goblin": {
                return new RaceGoblinAttributes();
            }
            case "Elf": {
                return new RaceElfAttributes();
            }
            case "Faelis": {
                return new RaceFaelisAttributes();
            }
            case "Dragon": {
                return new RaceDragonAttributes();
            }
            case "Human": {
                return new RaceAttributesWrapper();
            }
        }
        return new RaceAttributesWrapper();
    }

    public boolean isNone() {
        return this.name.contentEquals("None");
    }

    public static void registerRaces() {
        EntityRace.registerRace(new EntityRace("None", "00000000-0000-0000-0000-000000000000", 11107684, 16374701, true).setRaceSize(100).setMagicAffinity(100));
        EntityRace.registerRace(new EntityRace("Human", "c82ec7c3-2a9d-4a08-b0dd-7ce086c6771b", 11107684, 16374701, true).setRaceSize(100).setMagicAffinity(100));
        EntityRace.registerRace(new EntityRace("Fairy", "e5869fac-0949-41f2-889b-4e6b8ca6d2e7", 12514535, 962222, true).setRaceSize(25).setRaceHeight(TrinketsConfig.SERVER.races.fairy.size.height).setRaceWidth(TrinketsConfig.SERVER.races.fairy.size.height).setCanFly(true).setMagicAffinity(500));
        EntityRace.registerRace(new EntityRace("Dwarf", "917b555b-944a-4e44-afb6-ca638c6d91e5", 10832170, 0x6B6B6B, true).setRaceSize(75).setRaceHeight(TrinketsConfig.SERVER.races.dwarf.size.height).setRaceWidth(TrinketsConfig.SERVER.races.dwarf.size.height).setMagicAffinity(100));
        EntityRace.registerRace(new EntityRace("Titan", "a3bc433b-7bb7-4bd9-a88c-5fd120d04d59", 0x999999, 3223595, true).setRaceSize(300).setRaceHeight(TrinketsConfig.SERVER.races.titan.size.height).setRaceWidth(TrinketsConfig.SERVER.races.titan.size.height).setMagicAffinity(50));
        EntityRace.registerRace(new EntityRace("Elf", "25f92404-35f3-453b-ad48-9b788b2e12fc", 16374701, 11107684, true).setRaceSize(100).setRaceHeight(TrinketsConfig.SERVER.races.elf.size.height).setRaceWidth(TrinketsConfig.SERVER.races.elf.size.height).setMagicAffinity(200));
        EntityRace.registerRace(new EntityRace("Goblin", "d917999a-0399-4c39-bfc5-79784dfff6ed", 0x648664, 0x2F3F2F, true).setRaceSize(50).setRaceHeight(TrinketsConfig.SERVER.races.goblin.size.height).setRaceWidth(TrinketsConfig.SERVER.races.goblin.size.height).setMagicAffinity(75));
        EntityRace.registerRace(new EntityRace("Faelis", "cdccefa8-6a67-4394-b70d-c737953887a2", 16571252, 4465933, true).setRaceSize(85).setRaceHeight(TrinketsConfig.SERVER.races.faelis.size.height).setRaceWidth(TrinketsConfig.SERVER.races.faelis.size.height).setMagicAffinity(125));
        EntityRace.registerRace(new EntityRace("Dragon", "3b75821e-6ec6-4dfe-9612-b7a988a7b30b", 0x323232, 9509561, true).setRaceSize(120).setRaceHeight(TrinketsConfig.SERVER.races.dragon.size.height).setRaceWidth(TrinketsConfig.SERVER.races.dragon.size.height).setCanFly(true).setMagicAffinity(400));
    }

    protected static void registerRace(EntityRace race) {
        Registry.register((IForgeRegistryEntry)race);
    }
}

