/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.init.Elements;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.traits.abilities.AbilityBlockFinder;
import xzeroair.trinkets.traits.abilities.AbilityFireImmunity;
import xzeroair.trinkets.traits.abilities.AbilityFrostWalker;
import xzeroair.trinkets.traits.abilities.AbilityIceImmunity;
import xzeroair.trinkets.traits.abilities.AbilityLightningImmunity;
import xzeroair.trinkets.traits.abilities.AbilityNightVision;
import xzeroair.trinkets.traits.abilities.compat.survival.AbilityColdImmunity;
import xzeroair.trinkets.traits.abilities.compat.survival.AbilityHeatImmunity;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.elements.Element;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ClientConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigDragonsEye;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class TrinketDragonsEye
extends AccessoryBase {
    public static final ConfigDragonsEye serverConfig = TrinketsConfig.SERVER.Items.DRAGON_EYE;
    public static final ClientConfig.ClientConfigItems.ClientConfigDragonsEye clientConfig = TrinketsConfig.CLIENT.items.DRAGON_EYE;

    public TrinketDragonsEye(String name) {
        super(name);
        this.setUUID("6a345136-49b7-4b71-88dc-87301e329ac1");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w()) {
            ItemStack normal = new ItemStack((Item)this, 1, 0);
            items.add((Object)normal);
            if (TrinketDragonsEye.serverConfig.compat.iaf.FIRE_VARIANT) {
                ItemStack fire = new ItemStack((Item)this, 1, 0);
                Capabilities.getTrinketProperties(fire, prop -> {
                    prop.setVariant(1);
                    prop.getElementAttributes().setPrimaryElement(Elements.FIRE);
                });
                items.add((Object)fire);
            }
            if (TrinketDragonsEye.serverConfig.compat.iaf.ICE_VARIANT) {
                ItemStack ice = new ItemStack((Item)this, 1, 0);
                Capabilities.getTrinketProperties(ice, prop -> {
                    prop.setVariant(2);
                    prop.getElementAttributes().setPrimaryElement(Elements.ICE);
                });
                items.add((Object)ice);
            }
            if (TrinketDragonsEye.serverConfig.compat.iaf.LIGHTNING_VARIANT) {
                ItemStack lightning = new ItemStack((Item)this, 1, 0);
                Capabilities.getTrinketProperties(lightning, prop -> {
                    prop.setVariant(3);
                    prop.getElementAttributes().setPrimaryElement(Elements.LIGHTNING);
                });
                items.add((Object)lightning);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String customItemInformation(ItemStack stack, World world, ITooltipFlag flagIn, int index, String translation) {
        boolean isLightningVariant;
        TranslationHelper helper = TranslationHelper.INSTANCE;
        TranslationHelper.LangEntry key = new TranslationHelper.LangEntry(this.func_77667_c(stack), "treasurefinder", TrinketDragonsEye.serverConfig.oreFinder);
        String oreTarget = "NONE";
        try {
            AbilityBlockFinder finder;
            String target;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            IAbilityInterface ability = Capabilities.getEntityProperties((Entity)player, null, (prop, a) -> prop.getAbilityHandler().getAbility("xat:block_detection"));
            if (ability instanceof AbilityBlockFinder && !(target = (finder = (AbilityBlockFinder)ability).parseTargetName(finder.getTreasure())).isEmpty()) {
                oreTarget = target;
            }
        }
        catch (Exception e) {
            oreTarget = "ERROR";
        }
        TranslationHelper.OptionEntry key1 = new TranslationHelper.OptionEntry("target", TrinketDragonsEye.serverConfig.oreFinder, oreTarget.trim());
        TranslationHelper.KeyBindEntry keybind1 = new TranslationHelper.KeyBindEntry("denvkb", ModKeyBindings.DRAGONS_EYE_ABILITY.getDisplayName());
        TranslationHelper.KeyBindEntry keybind2 = new TranslationHelper.KeyBindEntry("deofkb", ModKeyBindings.DRAGONS_EYE_TARGET.getDisplayName());
        boolean tan = Trinkets.ToughAsNails && TrinketsConfig.compat.toughasnails || Trinkets.SimpleDifficulty && TrinketsConfig.compat.simpledifficulty;
        Element element = this.getPrimaryElement(stack);
        boolean isIceVariant = element == Elements.ICE;
        boolean bl = isLightningVariant = element == Elements.LIGHTNING;
        TranslationHelper.OptionEntry key2 = new TranslationHelper.OptionEntry("variantresist", new TextComponentTranslation(element == Elements.FIRE || element == Elements.NEUTRAL && TrinketDragonsEye.serverConfig.compat.iaf.DE_FIRE_RESIST ? "effect.fireResistance" : (element != Elements.NEUTRAL ? "xat.effect." + element.getName().toLowerCase() + "_resistance" : "ability.block_detection.name"), new Object[0]).func_150254_d());
        TranslationHelper.LangEntry TANHot = new TranslationHelper.LangEntry(this.func_77667_c(stack), "heatimmune", tan && TrinketDragonsEye.serverConfig.compat.tan.immuneToHeat);
        TranslationHelper.LangEntry TANCold = new TranslationHelper.LangEntry(this.func_77667_c(stack), "coldimmune", tan && TrinketDragonsEye.serverConfig.compat.tan.immuneToHeat);
        TranslationHelper.LangEntry IAFParalysis = new TranslationHelper.LangEntry(this.func_77667_c(stack), "paralysisimmune", isLightningVariant && TrinketDragonsEye.serverConfig.compat.iaf.LIGHTNING_VARIANT && TrinketDragonsEye.serverConfig.compat.iaf.PARALYSIS_IMMUNITY);
        TranslationHelper.OptionEntry key3 = new TranslationHelper.OptionEntry("typeimmune", new TextComponentTranslation(isIceVariant ? TANCold.option() : (isLightningVariant ? IAFParalysis.option() : TANHot.option()), new Object[0]).func_150254_d());
        TranslationHelper.LangEntry IAFFrostWalker = new TranslationHelper.LangEntry(this.func_77667_c(stack) + ".compat.iaf.ice", "frostwalker", isIceVariant && TrinketDragonsEye.serverConfig.compat.iaf.ICE_VARIANT && TrinketDragonsEye.serverConfig.compat.iaf.FROST_WALKER);
        return helper.formatAddVariables(translation, key, key1, keybind1, keybind2, key2, TANHot, TANCold, key3, IAFFrostWalker, IAFParalysis).replace("#underline:", "");
    }

    @Override
    public String[] getAttributeConfig() {
        return TrinketDragonsEye.serverConfig.attributes;
    }

    @Override
    public void initAbilities(ItemStack stack, EntityLivingBase entity, List<IAbilityInterface> abilities) {
        boolean tan;
        abilities.add(new AbilityNightVision().toggleAbility(true));
        Element element = this.getPrimaryElement(stack);
        boolean bl = tan = Trinkets.ToughAsNails && TrinketsConfig.compat.toughasnails || Trinkets.SimpleDifficulty && TrinketsConfig.compat.simpledifficulty;
        if (TrinketDragonsEye.serverConfig.compat.iaf.FIRE_VARIANT && element == Elements.FIRE) {
            abilities.add(new AbilityFireImmunity());
            if (tan && TrinketDragonsEye.serverConfig.compat.tan.immuneToHeat) {
                abilities.add(new AbilityHeatImmunity());
            }
        } else if (TrinketDragonsEye.serverConfig.compat.iaf.ICE_VARIANT && element == Elements.ICE) {
            abilities.add(new AbilityIceImmunity());
            if (TrinketDragonsEye.serverConfig.compat.iaf.FROST_WALKER) {
                abilities.add(new AbilityFrostWalker());
            }
            if (tan && TrinketDragonsEye.serverConfig.compat.tan.immuneToCold) {
                abilities.add(new AbilityColdImmunity());
            }
        } else if (TrinketDragonsEye.serverConfig.compat.iaf.LIGHTNING_VARIANT && element == Elements.LIGHTNING) {
            abilities.add(new AbilityLightningImmunity());
        } else if (TrinketDragonsEye.serverConfig.compat.iaf.DE_FIRE_RESIST) {
            abilities.add(new AbilityFireImmunity());
            if (tan && TrinketDragonsEye.serverConfig.compat.tan.immuneToHeat) {
                abilities.add(new AbilityHeatImmunity());
            }
        }
        if (TrinketDragonsEye.serverConfig.oreFinder) {
            abilities.add(new AbilityBlockFinder());
        }
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        Element element = this.getPrimaryElement(stack);
        String displayName = element != Elements.NEUTRAL ? new TextComponentTranslation(this.func_77667_c(stack) + "." + element.getName().toLowerCase() + ".name", new Object[0]).func_150254_d() : super.func_77653_i(stack);
        return displayName.trim();
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketDragonsEye.serverConfig.enabled;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation normal = new ModelResourceLocation(this.getRegistryName().toString(), "inventory");
        ModelResourceLocation iceVariant = new ModelResourceLocation(this.getRegistryName().toString() + "_ice", "inventory");
        ModelResourceLocation lightningVariant = new ModelResourceLocation(this.getRegistryName().toString() + "_lightning", "inventory");
        ModelResourceLocation fireVariant = new ModelResourceLocation(this.getRegistryName().toString() + "_fire", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{normal, fireVariant, iceVariant, lightningVariant});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            Element element = this.getPrimaryElement(stack);
            if (element == Elements.LIGHTNING) {
                return lightningVariant;
            }
            if (element == Elements.ICE) {
                return iceVariant;
            }
            if (element == Elements.FIRE) {
                return fireVariant;
            }
            return normal;
        });
    }
}

