/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.base;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.init.Elements;
import xzeroair.trinkets.items.base.TrinketRaceBase;
import xzeroair.trinkets.traits.abilities.base.ItemAbilityProvider;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.elements.Element;
import xzeroair.trinkets.traits.elements.IElementProvider;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.AttributeHelper;
import xzeroair.trinkets.util.helpers.TranslationHelper;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;
import xzeroair.trinkets.util.interfaces.IsModelLoaded;

public abstract class AccessoryBase
extends Item
implements IsModelLoaded,
IAccessoryInterface,
ItemAbilityProvider,
IElementProvider {
    protected UUID uuid;
    @Deprecated
    protected String[] attributes;

    public AccessoryBase(String name) {
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77625_d(1);
        this.func_77637_a(Trinkets.trinketstab);
    }

    @Deprecated
    public AccessoryBase setAttributeConfig(String[] attributeConfig) {
        this.attributes = attributeConfig;
        return this;
    }

    public String[] getAttributeConfig() {
        if (this.attributes != null) {
            return this.attributes;
        }
        return new String[0];
    }

    @Override
    public void initAbilities(ItemStack stack, EntityLivingBase entity, List<IAbilityInterface> abilities) {
    }

    protected void initAttributes(String[] attributeConfig, EntityLivingBase entity) {
        if (attributeConfig != null && attributeConfig.length > 0) {
            for (String entry : attributeConfig) {
                ConfigHelper.AttributeEntry attributeShell = ConfigHelper.getAttributeEntry(entry);
                if (attributeShell == null || this.getUUID() == null) continue;
                String name = attributeShell.getAttribute();
                double amount = attributeShell.getAmount();
                int operation = attributeShell.getOperation();
                boolean isSaved = attributeShell.isSaved();
                if (this instanceof TrinketRaceBase) continue;
                UpdatingAttribute attribute = new UpdatingAttribute(this.func_77658_a() + "." + name, this.uuid, name).setAmount(amount).setOperation(operation).setSavedInNBT(isSaved);
                if (name.equalsIgnoreCase("forge.swimSpeed")) {
                    boolean skip = false;
                    if (!TrinketsConfig.SERVER.misc.depthStacks && EnchantmentHelper.func_185294_d((EntityLivingBase)entity) > 0) {
                        skip = true;
                    }
                    try {
                        if (Trinkets.SoManyEnchantments && !TrinketsConfig.SERVER.misc.underwaterStriderStacks) {
                            boolean hasUnderwaterStrider;
                            Enchantment e = Enchantment.func_180305_b((String)"somanyenchantments:underwaterstrider");
                            boolean bl = hasUnderwaterStrider = e != null && EnchantmentHelper.func_185284_a((Enchantment)e, (EntityLivingBase)entity) > 0;
                            if (hasUnderwaterStrider) {
                                skip = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
                        skip = true;
                    }
                    if (skip) {
                        attribute.removeModifier(entity);
                        continue;
                    }
                }
                attribute.addModifier(entity, amount, operation);
            }
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return super.hasCustomEntity(stack);
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return super.createEntity(world, location, itemstack);
    }

    public boolean isShield(ItemStack stack, EntityLivingBase entity) {
        return super.isShield(stack, entity);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return super.isValidArmor(stack, armorType, entity);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return super.onDroppedByPlayer(item, player);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return super.onEntityItemUpdate(entityItem);
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    public boolean func_77645_m() {
        return false;
    }

    @Override
    public int getSlot(ItemStack stack) {
        return Capabilities.getTrinketProperties(stack, -1, (prop, slot) -> prop.getSlot());
    }

    @Override
    public String getItemHandler(ItemStack stack) {
        return Capabilities.getTrinketProperties(stack, TrinketHelper.SlotInformation.ItemHandlerType.NONE.getName(), (prop, slot) -> prop.getSlotInfo().getHandler());
    }

    @Override
    public String getAccessoryType() {
        return "trinket";
    }

    public UUID getUUID() {
        return this.uuid;
    }

    protected void setUUID(String uuid) {
        this.uuid = UUID.fromString(uuid);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        Capabilities.getTrinketProperties(stack, cap -> cap.onUpdate(stack, world, entity, itemSlot, isSelected));
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        Capabilities.getTrinketProperties(stack, cap -> cap.onCrafted(stack, world, player));
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.onEntityArmorTick(world, (EntityLivingBase)player, itemStack);
    }

    @Override
    public void onEntityArmorTick(World world, EntityLivingBase entity, ItemStack stack) {
    }

    @Override
    public void onAccessoryEquipped(ItemStack stack, EntityLivingBase entity) {
        boolean isClient = entity.field_70170_p.field_72995_K;
        Capabilities.getTrinketProperties(stack, cap -> {
            if (!isClient) {
                cap.itemEquipped(stack, entity);
            } else {
                entity.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
            }
        });
    }

    @Override
    public void eventLivingUpdateTick(ItemStack stack, EntityLivingBase entity) {
        Capabilities.getTrinketProperties(stack, cap -> cap.onEntityTick(stack, entity));
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        this.initAttributes(this.getAttributeConfig(), (EntityLivingBase)player);
        Capabilities.getTrinketProperties(stack, cap -> cap.onEntityTick(stack, (EntityLivingBase)player));
    }

    @Override
    public void onAccessoryUnequipped(ItemStack stack, EntityLivingBase entity) {
        boolean isClient = entity.field_70170_p.field_72995_K;
        Capabilities.getTrinketProperties(stack, cap -> {
            if (!isClient) {
                cap.itemUnequipped(stack, entity);
            } else {
                entity.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
            }
        });
        AttributeHelper.removeAttributesByUUID(entity, this.getUUID());
    }

    @Override
    public void eventPlayerLogout(ItemStack stack, EntityPlayer player) {
        AttributeHelper.removeAttributesByUUID((EntityLivingBase)player, this.getUUID());
    }

    @Override
    public boolean canUnequipAccessory(ItemStack stack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && ((EntityPlayer)player).field_71075_bZ.field_75098_d) {
            return true;
        }
        return !EnchantmentHelper.func_190938_b((ItemStack)stack) || player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Item.func_150899_d((int)399);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return Capabilities.getTrinketProperties(stack, super.getNBTShareTag(stack), (prop, tag) -> {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            return prop.saveToNBT((NBTTagCompound)tag);
        });
    }

    public void readNBTShareTag(ItemStack stack, NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        Capabilities.getTrinketProperties(stack, prop -> prop.loadFromNBT(nbt));
    }

    public NBTTagCompound getTagCompoundSafe(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    @Override
    public boolean canEquipAccessory(ItemStack stack, EntityLivingBase player) {
        return !TrinketHelper.AccessoryCheck(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    protected String customItemInformation(ItemStack stack, World world, ITooltipFlag flagIn, int index, String translation) {
        TranslationHelper helper = TranslationHelper.INSTANCE;
        return helper.formatAddVariables(translation, new TranslationHelper.KeyEntry[0]);
    }

    @Override
    public Element getPrimaryElement(ItemStack stack) {
        return Capabilities.getTrinketProperties(stack, this.getPrimaryElement(), (prop, element) -> {
            Element primary = prop.getElementAttributes().getPrimaryElement();
            if (primary != Elements.NEUTRAL) {
                return primary;
            }
            return element;
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        String EV;
        TrinketProperties prop;
        super.func_77624_a(stack, world, tooltip, flagIn);
        if (world == null) {
            return;
        }
        EntityPlayerSP player = null;
        try {
            player = Minecraft.func_71410_x().field_71439_g;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (player == null) {
            return;
        }
        if (TrinketsConfig.CLIENT.debug.showID && (prop = Capabilities.getTrinketProperties(stack)) != null) {
            TrinketHelper.SlotInformation info = prop.getSlotInfo();
            tooltip.add("\u00c2\u00a76" + info.getHandler() + "\u00c2\u00a7r:\u00c2\u00a7f" + info.getSlot() + "\u00c2\u00a7r");
        }
        TranslationHelper helper = TranslationHelper.INSTANCE;
        for (int i = 1; i < 10; ++i) {
            int index = i;
            String string = helper.getLangTranslation(stack.func_77977_a() + ".tooltip" + i, lang -> this.customItemInformation(stack, world, flagIn, index, (String)lang));
            if (helper.isStringEmpty(string)) continue;
            tooltip.add(string);
        }
        TextComponentTranslation ctrl = new TextComponentTranslation("xat.holdctrl", new Object[0]);
        boolean tanEnabled = Trinkets.ToughAsNails && TrinketsConfig.compat.toughasnails;
        boolean sdEnabled = Trinkets.SimpleDifficulty && TrinketsConfig.compat.simpledifficulty;
        boolean faEnabled = Trinkets.FirstAid;
        boolean evEnabled = Trinkets.EnhancedVisuals && TrinketsConfig.compat.enhancedvisuals;
        String TAN = !tanEnabled && !sdEnabled ? "" : helper.getLangTranslation(stack.func_77977_a() + ".compat.tan", lang -> this.customItemInformation(stack, world, flagIn, 11, (String)lang));
        String FA = !faEnabled ? "" : helper.getLangTranslation(stack.func_77977_a() + ".compat.firstaid", lang -> this.customItemInformation(stack, world, flagIn, 12, (String)lang));
        String string = EV = !evEnabled ? "" : helper.getLangTranslation(stack.func_77977_a() + ".compat.enhancedvisuals", lang -> this.customItemInformation(stack, world, flagIn, 13, (String)lang));
        if (GuiScreen.func_146271_m()) {
            if (!helper.isStringEmpty(TAN)) {
                String modifier = sdEnabled ? " (Simple Difficulty)" : (tanEnabled ? " (Tough as Nails)" : "");
                tooltip.add(TAN + helper.gold + modifier);
            }
            if (!helper.isStringEmpty(FA)) {
                tooltip.add(FA + helper.gold + " (First Aid)");
            }
            if (!helper.isStringEmpty(EV)) {
                tooltip.add(EV + helper.gold + " (Enhanced Visuals)");
            }
        } else if (!(helper.isStringEmpty(TAN) && helper.isStringEmpty(EV) && helper.isStringEmpty(FA))) {
            tooltip.add(helper.reset + "" + helper.dGray + ctrl.func_150254_d());
        }
        try {
            TextComponentTranslation shift = new TextComponentTranslation("xat.holdshift", new Object[0]);
            String[] attributeConfig = this.getAttributeConfig();
            if (attributeConfig != null && attributeConfig.length > 0) {
                ArrayList<ConfigHelper.AttributeEntry> attributes = new ArrayList<ConfigHelper.AttributeEntry>();
                for (String entry : attributeConfig) {
                    double amount;
                    ConfigHelper.AttributeEntry attributeShell = ConfigHelper.getAttributeEntry(entry);
                    if (attributeShell == null || (amount = attributeShell.getAmount()) == 0.0) continue;
                    attributes.add(attributeShell);
                }
                if (!attributes.isEmpty()) {
                    tooltip.add(helper.reset + "" + helper.dGray + shift.func_150254_d());
                    if (GuiScreen.func_146272_n()) {
                        for (ConfigHelper.AttributeEntry entry : attributes) {
                            String s;
                            String name = entry.getAttribute();
                            double amount = entry.getAmount();
                            int operation = entry.getOperation();
                            if (player.func_110140_aT().func_111152_a(name) == null) continue;
                            double d0 = amount;
                            boolean flag = false;
                            double d1 = operation != 1 && operation != 2 ? d0 : d0 * 100.0;
                            TextComponentTranslation AttrName = new TextComponentTranslation("attribute.name." + name, new Object[0]);
                            if (flag) {
                                TextComponentTranslation never = new TextComponentTranslation("attribute.modifier.equals." + operation, new Object[]{Reference.DECIMALFORMAT.format(d1), AttrName.func_150254_d()});
                                tooltip.add(" " + never.func_150254_d());
                                continue;
                            }
                            if (d0 > 0.0) {
                                TextComponentTranslation addition = new TextComponentTranslation("attribute.modifier.plus." + operation, new Object[]{Reference.DECIMALFORMAT.format(d1), AttrName.func_150254_d()});
                                addition.func_150256_b().func_150238_a(TextFormatting.BLUE);
                                s = addition.func_150254_d();
                                tooltip.add(" " + s);
                                continue;
                            }
                            if (!(d0 < 0.0)) continue;
                            TextComponentTranslation subtraction = new TextComponentTranslation("attribute.modifier.take." + operation, new Object[]{Reference.DECIMALFORMAT.format(d1 *= -1.0), AttrName.func_150254_d()});
                            subtraction.func_150256_b().func_150238_a(TextFormatting.RED);
                            s = subtraction.func_150254_d();
                            tooltip.add(" " + s);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77952_i();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

