/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.TrinketContainerProvider;
import xzeroair.trinkets.container.TrinketContainerHandler;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.SyncItemDataPacket;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class TrinketEventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !player.func_70089_S() || player.field_70170_p == null) {
                return;
            }
            TrinketHelper.getTrinketHandler((EntityLivingBase)player, arg_0 -> TrinketEventHandler.lambda$clientTickEvent$0((EntityPlayer)player, arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (world != null) {
            boolean client = world.field_72995_K;
            TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (!client && world instanceof WorldServer) {
                        if (!empty) {
                            Capabilities.getTrinketProperties(stack, properties -> properties.itemEquipped(stack, (EntityLivingBase)player));
                        }
                        SyncItemDataPacket packet = new SyncItemDataPacket((EntityLivingBase)player, stack, stack.func_77978_p(), i, TrinketHelper.SlotInformation.ItemHandlerType.TRINKETS, true, !empty);
                        NetworkHandler.sendToClients((WorldServer)world, player.func_180425_c(), packet);
                    }
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventPlayerLogin(stack, player);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void EntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            World world = event.getWorld();
            if (world != null) {
                boolean client = world.field_72995_K;
                TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        boolean empty = stack.func_190926_b();
                        if (client || !(world instanceof WorldServer)) continue;
                        SyncItemDataPacket packet = new SyncItemDataPacket((EntityLivingBase)player, stack, stack.func_77978_p(), i, TrinketHelper.SlotInformation.ItemHandlerType.TRINKETS, true, !empty);
                        NetworkHandler.sendTo(packet, player);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventPlayerLogout(stack, player);
            }
        });
    }

    @SubscribeEvent
    public void playerStartTracking(PlayerEvent.StartTracking event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        World world = player.func_130014_f_();
        if (!world.field_72995_K && world instanceof WorldServer && target instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)target;
            TrinketHelper.getTrinketHandler((EntityLivingBase)targetPlayer, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    SyncItemDataPacket packet = new SyncItemDataPacket((EntityLivingBase)targetPlayer, stack, stack.func_77978_p(), i, TrinketHelper.SlotInformation.ItemHandlerType.TRINKETS, true, !empty);
                    NetworkHandler.sendTo(packet, (EntityPlayerMP)player);
                }
            });
        }
    }

    @SubscribeEvent
    public void PlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventPlayerChangedDimension(stack, player, event.fromDim, event.toDim);
            }
        });
    }

    @SubscribeEvent
    public void playerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!player.func_70089_S()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventPlayerTick(stack, player);
                }
            });
        }
    }

    @SubscribeEvent
    public void LivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof EntityPlayer)) {
            TrinketHelper.getTrinketHandler(entity, trinkets2 -> {
                for (int i = 0; i < trinkets2.getSlots(); ++i) {
                    ItemStack stack = trinkets2.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventLivingUpdateTick(stack, entity);
                }
            });
        }
    }

    @SubscribeEvent
    public void potionApplicable(PotionEvent.PotionApplicableEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        TrinketHelper.getTrinketHandler(entity, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventPotionApplicable(stack, entity, event);
            }
        });
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        TrinketHelper.getTrinketHandler(entity, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingJump(stack, entity);
            }
        });
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        TrinketHelper.getTrinketHandler(entity, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingFall(stack, entity, event);
            }
        });
    }

    @SubscribeEvent
    public void TargetEvent(LivingSetAttackTargetEvent event) {
        EntityLivingBase entity = event.getTarget();
        TrinketHelper.getTrinketHandler(entity, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventSetAttackTarget(stack, entity, event.getEntityLiving());
            }
        });
    }

    @SubscribeEvent
    public void HurtEvent(LivingHurtEvent event) {
        EntityLivingBase attacked = event.getEntityLiving();
        TrinketHelper.getTrinketHandler(attacked, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingHurtAttacked(stack, attacked, event);
            }
        });
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            TrinketHelper.getTrinketHandler(attacker, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventLivingHurtAttacker(stack, attacker, event);
                }
            });
        }
    }

    @SubscribeEvent
    public void deathEvent(LivingDamageEvent event) {
        EntityLivingBase attacked = event.getEntityLiving();
        TrinketHelper.getTrinketHandler(attacked, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingDamageAttacked(stack, attacked, event);
            }
        });
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            TrinketHelper.getTrinketHandler(attacker, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventLivingDamageAttacker(stack, attacker, event);
                }
            });
        }
    }

    @SubscribeEvent
    public void experienceDropEvent(LivingExperienceDropEvent event) {
        EntityPlayer player = event.getAttackingPlayer();
        TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingExperienceDrops(stack, player, event);
            }
        });
    }

    @SubscribeEvent
    public void ItemDropEvent(LivingDropsEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getSource().func_76346_g();
            TrinketHelper.getTrinketHandler(entity, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventLivingDrops(stack, entity, event);
                }
            });
        }
    }

    @SubscribeEvent
    public void onAttemptToBreakBlock(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventBreakSpeed(stack, player, event);
            }
        });
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventBlockBreak(stack, player, event);
            }
        });
    }

    @SubscribeEvent
    public void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        TrinketHelper.getTrinketHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventBlockDrops(stack, (EntityLivingBase)player, event);
            }
        });
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K && !event.getEntity().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.dropItemsAt(event.getEntityPlayer(), event.getDrops(), (Entity)event.getEntityPlayer());
        }
    }

    public void dropItemsAt(EntityPlayer player, List<EntityItem> drops, Entity e) {
        TrinketHelper.getTrinketHandler((EntityLivingBase)player, Trinket -> {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                if (Trinket.getStackInSlot(i).func_190926_b()) continue;
                EntityItem ei = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, Trinket.getStackInSlot(i).func_77946_l());
                ei.func_174867_a(40);
                float f1 = e.field_70170_p.field_73012_v.nextFloat() * 0.5f;
                float f2 = e.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                ei.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
                ei.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
                ei.field_70181_x = 0.2f;
                drops.add(ei);
                Trinket.setStackInSlot(i, ItemStack.field_190927_a);
            }
        });
    }

    @SubscribeEvent
    public void PlayerCloneEvent(PlayerEvent.Clone event) {
        try {
            TrinketContainerHandler bco = (TrinketContainerHandler)event.getOriginal().getCapability(TrinketContainerProvider.containerCap, null);
            NBTTagCompound nbt = bco.serializeNBT();
            TrinketContainerHandler bcn = (TrinketContainerHandler)event.getEntityPlayer().getCapability(TrinketContainerProvider.containerCap, null);
            bcn.deserializeNBT(nbt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$clientTickEvent$0(EntityPlayer player, ITrinketContainerHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            boolean empty = stack.func_190926_b();
            if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
            IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
            item.eventClientTick(stack, player);
        }
    }
}

