/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Serializable;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.particles.EffectsRenderPacket;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;

public class MovingThrownProjectile
extends EntityArrow {
    private int xTile;
    private int yTile;
    private int zTile;
    private Block inTile;
    private int inData;
    private int ticksInGround;
    private int ticksInAir;
    private int knockbackStrength;
    public Entity ignoreEntity;
    private int ignoreTime;
    int color;
    public EntityLivingBase field_70250_c;
    private int ticksAlive;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;
    private boolean ignoreBlocks = false;

    public MovingThrownProjectile(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.color = 0xC00000;
        this.func_70239_b(TrinketsConfig.SERVER.races.dragon.breath_damage);
    }

    public MovingThrownProjectile(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        this(worldIn);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.accelerationX = accelX / d0 * 0.1;
        this.accelerationY = accelY / d0 * 0.1;
        this.accelerationZ = accelZ / d0 * 0.1;
    }

    public MovingThrownProjectile(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ, int color) {
        this(worldIn);
        this.field_70250_c = shooter;
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        float f = -MathHelper.func_76126_a((float)(shooter.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(shooter.field_70125_A * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((shooter.field_70125_A + 0.0f) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(shooter.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(shooter.field_70125_A * ((float)Math.PI / 180)));
        double d0 = MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
        this.accelerationX = accelX / d0 * (0.1 * (double)(this.isFlying(shooter) ? 4 : 1));
        this.accelerationY = accelY / d0 * (0.1 * (double)(this.isFlying(shooter) ? 4 : 1));
        this.accelerationZ = accelZ / d0 * (0.1 * (double)(this.isFlying(shooter) ? 4 : 1));
        this.color = color;
    }

    private boolean isFlying(EntityLivingBase entity) {
        return entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b;
    }

    public MovingThrownProjectile setIgnoreBlocks(boolean ignoreBlocks) {
        this.ignoreBlocks = ignoreBlocks;
        return this;
    }

    public MovingThrownProjectile setColor(int color) {
        this.color = color;
        return this;
    }

    public void setSizes(float width, float height) {
        this.func_70105_a(width, height);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.field_70250_c == null || !this.field_70250_c.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70052_a(6, this.func_184202_aL());
            }
            this.func_70030_z();
            if (this.field_70249_b > 0) {
                --this.field_70249_b;
            }
            if (this.field_70254_i) {
                if (this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c() == this.inTile) {
                    ++this.ticksInGround;
                    if (this.ticksInGround == 1200) {
                        this.func_70106_y();
                    }
                    return;
                }
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
            vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
            double d0 = 0.0;
            boolean flag = false;
            for (Entity entity1 : list) {
                double d1;
                if (!entity1.func_70067_L()) continue;
                if (entity1 == this.ignoreEntity) {
                    flag = true;
                    continue;
                }
                if (this.field_70250_c != null && this.field_70173_aa < 2 && this.ignoreEntity == null) {
                    this.ignoreEntity = entity1;
                    flag = true;
                    continue;
                }
                flag = false;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
                RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec3d, vec3d1);
                if (raytraceresult1 == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (this.ignoreEntity != null) {
                if (flag) {
                    this.ignoreTime = 2;
                } else if (this.ignoreTime-- <= 0) {
                    this.ignoreEntity = null;
                }
            }
            if (entity != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null) {
                if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(raytraceresult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                    this.func_181015_d(raytraceresult.func_178782_a());
                } else if (!ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                    this.func_184549_a(raytraceresult);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            float f2 = 0.03f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f1 = 0.8f;
            }
            this.field_70159_w *= (double)f1;
            this.field_70181_x *= (double)f1;
            this.field_70179_y *= (double)f1;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.03f;
            }
            int life = 30;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.spawnParticle();
            if (this.field_70173_aa >= 30) {
                this.func_70106_y();
            }
            if (this.func_70090_H()) {
                this.func_70106_y();
            }
        }
    }

    public void spawnParticle() {
        try {
            Random random = Reference.random;
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            if (d0 * d0 + d1 * d1 + d2 * d2 <= 1.0) {
                double d3 = this.field_70165_t + d0 * 1.0 / 4.0;
                double d4 = this.field_70163_u + 0.5 + d1 * 1.0 / 4.0;
                double d5 = this.field_70161_v + d2 * 1.0 / 4.0;
                if (this.field_70170_p instanceof WorldServer) {
                    NetworkHandler.sendToClients((WorldServer)this.field_70170_p, this.func_180425_c(), new EffectsRenderPacket((Entity)this, d3, d4, d5, d0, d1 + 0.2, d2, this.color, 4, 1.0f, 1.0f));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_184549_a(RayTraceResult movingObject) {
        RayTraceResult.Type hitType;
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        Entity hitEntity = movingObject.field_72308_g;
        if (this.field_70170_p == null || this.field_70170_p.field_72995_K || hitEntity instanceof MovingThrownProjectile) {
            return;
        }
        boolean pvpEnabled = false;
        MinecraftServer server = this.field_70170_p.func_73046_m();
        if (server == null && this.field_70250_c instanceof EntityPlayerMP) {
            server = this.field_70250_c.func_184102_h();
        }
        if (server != null) {
            pvpEnabled = server.func_71219_W();
        }
        if ((hitType = movingObject.field_72313_a) == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos;
            BlockPos hitBlock = movingObject.func_178782_a();
            if (flag && this.field_70170_p.func_175623_d(blockpos = hitBlock.func_177972_a(movingObject.field_178784_b))) {
                this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
            }
        } else if (hitType == RayTraceResult.Type.ENTITY && hitEntity != null) {
            AxisAlignedBB bb1 = this.func_174813_aQ().func_186662_g(1.0);
            Predicate Targets = Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L() && ent != this.field_70250_c && !(ent instanceof MovingThrownProjectile) && !ent.func_70045_F());
            List splash = this.field_70170_p.func_175674_a((Entity)this, bb1, Targets);
            for (Entity e : splash) {
                if (e instanceof EntityPlayer && !pvpEnabled) continue;
                this.func_174815_a(this.field_70250_c, e);
                e.func_70097_a(new EntityDamageSourceIndirect(DamageSource.field_188407_q.field_76373_n, (Entity)this, (Entity)this.field_70250_c).func_76348_h().func_76361_j().func_82726_p(), (float)this.func_70242_d());
                e.func_70015_d(5);
            }
        }
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.func_180431_b(source);
    }

    public float func_70111_Y() {
        return super.func_70111_Y();
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        if (compound.func_74764_b("BreathColor")) {
            this.color = compound.func_74762_e("BreathColor");
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74768_a("BreathColor", this.color);
        return super.func_189511_e(compound);
    }

    protected ItemStack func_184550_j() {
        return null;
    }

    public static interface HitResult
    extends Serializable {
        public void onHit(MovingThrownProjectile var1, RayTraceResult var2, boolean var3);

        public static class EmptyResult
        implements HitResult,
        Serializable {
            @Override
            public void onHit(MovingThrownProjectile entity, RayTraceResult result, boolean isServer) {
            }
        }
    }
}

