/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.entity;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.RayTraceHelper;

public class AlphaWolf
extends EntityWolf {
    private NBTTagCompound storedWolf;

    public AlphaWolf(World world) {
        super(world);
        this.func_98054_a(false);
        this.func_70105_a(0.6f, 1.2f);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.field_75782_a.clear();
    }

    public void func_70071_h_() {
        boolean r;
        Entity rider;
        super.func_70071_h_();
        boolean canRide = TrinketsConfig.SERVER.races.goblin.rider;
        if (!canRide) {
            this.func_70106_y();
        }
        if (!this.func_70089_S() || this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.func_184188_bt().isEmpty() && (rider = this.func_184179_bs()) instanceof EntityLivingBase) {
            EntityLivingBase driver = (EntityLivingBase)rider;
            if (!driver.func_70644_a(MobEffects.field_76420_g)) {
                driver.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 100, 0, false, false));
            }
            if (!driver.func_70644_a(MobEffects.field_76428_l)) {
                driver.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 0, false, false));
            }
            if (!this.func_70644_a(MobEffects.field_76428_l)) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 1, false, false));
            }
            if (driver.func_70644_a(MobEffects.field_76427_o)) {
                this.func_70690_d(driver.func_70660_b(MobEffects.field_76427_o));
            }
            if (driver.func_70644_a(MobEffects.field_76426_n)) {
                this.func_70690_d(driver.func_70660_b(MobEffects.field_76426_n));
            }
            if (driver.func_70644_a(MobEffects.field_76441_p)) {
                this.func_70690_d(driver.func_70660_b(MobEffects.field_76441_p));
            }
            if (this.func_70090_H() && this.func_70086_ai() < driver.func_70086_ai()) {
                this.func_70050_g(driver.func_70086_ai());
            }
        }
        if (!(r = this.func_184188_bt().contains(this.func_70902_q())) && this.field_70173_aa > 1) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            try {
                Entity oldWolf;
                NBTTagCompound old = this.getPreviousWolf();
                if (old != null && (oldWolf = EntityList.func_75615_a((NBTTagCompound)old, (World)this.field_70170_p)) != null) {
                    oldWolf.func_70012_b(this.field_70165_t, this.field_70163_u + (double)1.1f, this.field_70161_v, this.field_70177_z, 0.0f);
                    if (this.field_70170_p.func_72838_d(oldWolf)) {
                        this.storeOldWolf(new NBTTagCompound());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.func_70106_y();
    }

    public boolean func_184220_m(Entity entityIn) {
        return super.func_184220_m(entityIn);
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return super.func_184205_a(entityIn, force);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn);
    }

    public void func_110145_l(Entity entityIn) {
        super.func_110145_l(entityIn);
    }

    public void func_184210_p() {
        super.func_184210_p();
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
    }

    public void func_184226_ay() {
        super.func_184226_ay();
    }

    public void setTamedBy(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            super.func_193101_c((EntityPlayer)entity);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(JumpAttribute.Jump).func_111128_a(0.7);
        UpdatingAttribute atkDamage = new UpdatingAttribute(UUID.fromString("76c436ad-d830-48ff-8b3c-fa3bcc1891c2"), SharedMonsterAttributes.field_111264_e).setSavedInNBT(true);
        atkDamage.addModifier((EntityLivingBase)this, 4.0, 2);
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityWolf entitywolf;
            if (target instanceof EntityWolf && (entitywolf = (EntityWolf)target).func_70909_n() && entitywolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.func_70031_b(entitylivingbase.func_70051_ag());
            if (this.isJumping() && this.field_70122_E) {
                this.func_70664_aZ();
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, vertical, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E) {
                this.func_70637_d(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public void MountedAttack(EntityPlayer player, double maxDist) {
        Vec3d pos1 = this.func_174824_e(1.0f);
        Vec3d lookVec = player.func_70040_Z();
        Vec3d targetLoc = pos1.func_72441_c(lookVec.field_72450_a * maxDist, lookVec.field_72448_b * maxDist, lookVec.field_72449_c * maxDist);
        double d0 = targetLoc.field_72450_a - this.field_70165_t;
        double d1 = targetLoc.field_72449_c - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        double m1 = 0.4;
        double m2 = 0.6;
        double multiplier = 4.0;
        if ((double)f >= 1.0E-4) {
            double f1 = d0 / (double)f * 4.0 * 0.4 + this.field_70159_w * 0.6;
            double f2 = d1 / (double)f * 4.0 * 0.4 + this.field_70179_y * 0.6;
            this.field_70159_w += f1;
            this.field_70179_y += f2;
        }
        this.field_70181_x = 0.42;
        this.func_184609_a(EnumHand.MAIN_HAND);
        RayTraceHelper.Beam beam = new RayTraceHelper.Beam(player.field_70170_p, (EntityLivingBase)player, maxDist, 1.0, true);
        RayTraceHelper.rayTraceEntity(beam, target -> {
            if (target instanceof EntityLivingBase && target != this) {
                this.func_70652_k((Entity)target);
                return true;
            }
            return false;
        });
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        return this.func_184207_aI() && entity != null && this.func_184215_y(entity) ? false : super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    public boolean isJumping() {
        return this.field_70703_bu;
    }

    protected float func_175134_bD() {
        float jumpmotion = (float)this.func_110148_a(JumpAttribute.Jump).func_111126_e();
        return jumpmotion;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    public boolean func_70631_g_() {
        return false;
    }

    public void storeOldWolf(EntityWolf wolf) {
        NBTTagCompound tag = new NBTTagCompound();
        wolf.func_189511_e(tag);
        this.storedWolf = tag;
    }

    public void storeOldWolf(NBTTagCompound tag) {
        this.storedWolf = tag;
    }

    public NBTTagCompound getPreviousWolf() {
        if (this.storedWolf == null) {
            this.storedWolf = new NBTTagCompound();
        }
        return this.storedWolf;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("xat.wolf.stored", (NBTBase)this.storedWolf);
        compound.func_74757_a("xat:summoned", true);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("xat.wolf.stored")) {
            this.storedWolf = (NBTTagCompound)compound.func_74781_a("xat.wolf.stored");
        }
    }
}

