/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.client.events;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.capabilities.race.KeybindHandler;
import xzeroair.trinkets.client.keybinds.KeyHandler;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.entity.AlphaWolf;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.init.ModPotionTypes;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.keybinds.KeybindPacket;
import xzeroair.trinkets.network.keybinds.MovementKeyPacket;
import xzeroair.trinkets.network.trinketcontainer.OpenTrinketGui;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IKeyBindInterface;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.TranslationHelper;

@SideOnly(value=Side.CLIENT)
public class EventHandlerClient {
    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START && (player = Minecraft.func_71410_x().field_71439_g) != null && TrinketsConfig.SERVER.GUI.guiEnabled && ModKeyBindings.TRINKET_GUI.func_151468_f()) {
            NetworkHandler.sendToServer(new OpenTrinketGui(0));
        }
        if (event.phase == TickEvent.Phase.END) {
            if (!FMLClientHandler.instance().getClient().field_71415_G) {
                return;
            }
            player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.field_70170_p != null) {
                try {
                    Entity mount;
                    if (player.func_184218_aH() && (mount = player.func_184187_bx()) instanceof AlphaWolf) {
                        AlphaWolf wolf = (AlphaWolf)mount;
                        if (player.field_71158_b.field_78901_c) {
                            wolf.func_70637_d(true);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                EntityProperties entityProperties = Capabilities.getEntityProperties((Entity)player, prop -> {
                    KeybindHandler.keyEnum[] defaultKeys;
                    Map<String, AbilityHandler.AbilityHolder> abilities = prop.getAbilityHandler().getActiveAbilities();
                    for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                        String key = entry.getKey();
                        AbilityHandler.AbilityHolder holder = entry.getValue();
                        try {
                            boolean auxDown;
                            IAbilityInterface ability = holder.getAbility();
                            if (!(ability instanceof IKeyBindInterface)) continue;
                            IKeyBindInterface keybind = (IKeyBindInterface)ability;
                            String keybind1 = keybind.getKey().replace(" ", "");
                            String keybind2 = keybind.getAuxKey().replace(" ", "");
                            boolean keyDown = !keybind1.isEmpty() ? ModKeyBindings.isKeyDownFromName(keybind1) : false;
                            boolean bl = auxDown = !keybind2.isEmpty() ? ModKeyBindings.isKeyDownFromName(keybind2) : false;
                            KeyHandler keyHand = prop.getKeybindHandler().getKeyHandler(key + "." + keybind1);
                            if (keyHand == null) continue;
                            keyHand.handler(keyDown, press -> {
                                if (keybind.onKeyPress((Entity)player, auxDown)) {
                                    NetworkHandler.sendToServer(new KeybindPacket((EntityLivingBase)player, key, keyDown, auxDown, 0));
                                    return true;
                                }
                                return false;
                            }, down -> {
                                if (keybind.onKeyDown((Entity)player, auxDown)) {
                                    NetworkHandler.sendToServer(new KeybindPacket((EntityLivingBase)player, key, keyDown, auxDown, 1));
                                    return true;
                                }
                                return false;
                            }, release -> {
                                if (keybind.onKeyRelease((Entity)player, auxDown)) {
                                    NetworkHandler.sendToServer(new KeybindPacket((EntityLivingBase)player, key, false, auxDown, 2));
                                    return true;
                                }
                                return false;
                            });
                        }
                        catch (Exception e) {
                            Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                            e.printStackTrace();
                        }
                    }
                    GameSettings s = Minecraft.func_71410_x().field_71474_y;
                    for (KeybindHandler.keyEnum key : defaultKeys = KeybindHandler.keyEnum.values()) {
                        KeyHandler handler;
                        KeyBinding kb = null;
                        switch (key) {
                            case LEFT: {
                                kb = s.field_74370_x;
                                break;
                            }
                            case RIGHT: {
                                kb = s.field_74366_z;
                                break;
                            }
                            case FORWARD: {
                                kb = s.field_74351_w;
                                break;
                            }
                            case BACK: {
                                kb = s.field_74368_y;
                                break;
                            }
                            case JUMP: {
                                kb = s.field_74314_A;
                                break;
                            }
                            case SNEAK: {
                                kb = s.field_74311_E;
                                break;
                            }
                        }
                        if (kb == null || (handler = prop.getKeybindHandler().getKeyHandler(key.getName())) == null) continue;
                        handler.handler(kb.func_151470_d(), press -> {
                            if (prop.getKeybindHandler().pressKey((Entity)player, key.getName(), 0)) {
                                MovementKeyPacket message = new MovementKeyPacket((EntityLivingBase)player, key.getName(), 0);
                                NetworkHandler.sendToServer(message);
                                return true;
                            }
                            return false;
                        }, down -> {
                            if (prop.getKeybindHandler().pressKey((Entity)player, key.getName(), 1)) {
                                MovementKeyPacket message = new MovementKeyPacket((EntityLivingBase)player, key.getName(), 1);
                                NetworkHandler.sendToServer(message);
                                return true;
                            }
                            return false;
                        }, release -> {
                            if (prop.getKeybindHandler().pressKey((Entity)player, key.getName(), 2)) {
                                MovementKeyPacket message = new MovementKeyPacket((EntityLivingBase)player, key.getName(), 2);
                                NetworkHandler.sendToServer(message);
                                return true;
                            }
                            return false;
                        });
                    }
                    if (TrinketsConfig.SERVER.misc.movement && prop.getRaceHandler().isTransforming()) {
                        if (player.field_70165_t != player.field_70169_q || player.field_70161_v != player.field_70166_s) {
                            player.func_70634_a(player.field_70169_q, player.field_70163_u, player.field_70166_s);
                        }
                        if (player == Minecraft.func_71410_x().field_71439_g) {
                            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151463_i(), (boolean)false);
                            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151463_i(), (boolean)false);
                            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151463_i(), (boolean)false);
                            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151463_i(), (boolean)false);
                            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i(), (boolean)false);
                            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i(), (boolean)false);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void ItemToolTipEvent(ItemTooltipEvent event) {
        PotionType pot;
        String itemType;
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.func_130014_f_() == null) {
            return;
        }
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen == null || screen.func_73868_f()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        String regName = item.getRegistryName().toString();
        String ModID = item.getRegistryName().func_110624_b();
        String ItemID = item.getRegistryName().func_110623_a();
        if (TrinketsConfig.CLIENT.debug.showOreDictEntries) {
            for (int or : OreDictionary.getOreIDs((ItemStack)stack)) {
                event.getToolTip().add(OreDictionary.getOreName((int)or));
            }
        }
        if ((TrinketsConfig.CLIENT.debug.debugArmorMaterials || TrinketsConfig.SERVER.races.faelis.penalties) && !(itemType = ConfigHelper.ArmorEntry.getItemType(stack)).isEmpty()) {
            boolean isFaelis;
            String ItemMaterial = ConfigHelper.ArmorEntry.getItemMaterial(stack).toLowerCase();
            if (TrinketsConfig.CLIENT.debug.debugArmorMaterials && !ItemMaterial.isEmpty()) {
                event.getToolTip().add(ItemMaterial);
            }
            if (TrinketsConfig.SERVER.races.faelis.penalties && (isFaelis = Capabilities.getEntityProperties((Entity)player, false, (prop, rtn) -> prop.getCurrentRace().equals(EntityRaces.faelis)).booleanValue())) {
                ConfigHelper.ArmorEntry entry = null;
                if (item instanceof ItemArmor) {
                    ItemArmor armor = (ItemArmor)item;
                    String armorType = armor.field_77881_a.func_188450_d();
                    entry = ConfigHelper.TrinketConfigStorage.getEquipmentEntry(regName + ":" + armorType, regName, "ObjectMaterial:" + ItemMaterial + ":" + armorType, "ObjectMaterial:" + ItemMaterial);
                    if (entry != null) {
                        String color = entry.getEquipmentWeight() > 0.0 ? "" + TextFormatting.RED : "" + TextFormatting.BLUE;
                        event.getToolTip().add(new TextComponentTranslation("xat.tooltip.weight", new Object[0]).func_150254_d() + " " + color + entry.getEquipmentWeight());
                    }
                } else {
                    String color2;
                    String[] mS = new String[]{regName + ":mainhand", regName, "ObjectMaterial:" + ItemMaterial + ":mainhand:" + itemType, "ObjectMaterial:" + ItemMaterial + ":mainhand:tool", "ObjectMaterial:" + ItemMaterial + ":hand:" + itemType, "ObjectMaterial:" + ItemMaterial + ":hand:tool", "ObjectMaterial:" + ItemMaterial + ":" + itemType, "ObjectMaterial:" + ItemMaterial + ":tool", "ObjectMaterial:" + ItemMaterial + ":mainhand", "ObjectMaterial:" + ItemMaterial + ":hand", "ObjectMaterial:" + ItemMaterial};
                    ConfigHelper.ArmorEntry main = ConfigHelper.TrinketConfigStorage.getEquipmentEntry((k, v) -> v.doesItemMatchEntry(stack), mS);
                    String[] oS = new String[]{regName + ":offhand", regName, "ObjectMaterial:" + ItemMaterial + ":offhand:" + itemType, "ObjectMaterial:" + ItemMaterial + ":offhand:tool", "ObjectMaterial:" + ItemMaterial + ":hand:" + itemType, "ObjectMaterial:" + ItemMaterial + ":hand:tool", "ObjectMaterial:" + ItemMaterial + ":" + itemType, "ObjectMaterial:" + ItemMaterial + ":tool", "ObjectMaterial:" + ItemMaterial + ":offhand", "ObjectMaterial:" + ItemMaterial + ":hand", "ObjectMaterial:" + ItemMaterial};
                    ConfigHelper.ArmorEntry off = ConfigHelper.TrinketConfigStorage.getEquipmentEntry((k, v) -> v.doesItemMatchEntry(stack), oS);
                    double mW = main == null ? 0.0 : main.getEquipmentWeight();
                    String color1 = mW > 0.0 ? "" + TextFormatting.RED : "" + TextFormatting.BLUE;
                    double oW = off == null ? 0.0 : off.getEquipmentWeight();
                    String string = color2 = oW > 0.0 ? "" + TextFormatting.RED : "" + TextFormatting.BLUE;
                    if (mW != 0.0 || oW != 0.0) {
                        if (mW != oW) {
                            if (mW != 0.0) {
                                event.getToolTip().add("Weight: " + color1 + mW + " - Mainhand");
                                if (oW != 0.0) {
                                    event.getToolTip().add("Weight: " + color2 + oW + " - Offhand");
                                }
                            } else {
                                event.getToolTip().add("Weight: " + color2 + oW + " - Offhand");
                            }
                        } else {
                            event.getToolTip().add("Weight: " + color1 + mW);
                        }
                    }
                }
            }
        }
        if (TrinketsConfig.SERVER.mana.mana_enabled) {
            try {
                TreeMap<String, ConfigHelper.MPRecoveryItem> MagicRecoveryItems = ConfigHelper.TrinketConfigStorage.MagicRecoveryItems;
                float amount = 0.0f;
                boolean multiplied = false;
                for (ConfigHelper.MPRecoveryItem entry : MagicRecoveryItems.values()) {
                    if (!entry.doesItemMatchEntry(stack)) continue;
                    amount = entry.getAmount();
                    multiplied = entry.isMultiplied();
                    break;
                }
                if (amount != 0.0f) {
                    String additive;
                    String string = additive = amount > 0.0f ? TextFormatting.DARK_AQUA + "+" : TextFormatting.DARK_RED + "-";
                    if (multiplied) {
                        event.getToolTip().add(additive + amount + "% MP");
                    } else {
                        event.getToolTip().add(additive + amount + " MP");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stack.func_77973_b().equals(Items.field_151068_bn) && ModPotionTypes.TrinketPotionTypes.containsValue(pot = PotionUtils.func_185191_c((ItemStack)stack))) {
            TranslationHelper helper = TranslationHelper.INSTANCE;
            TranslationHelper.OptionEntry human = new TranslationHelper.OptionEntry("humanticks", Float.valueOf((float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.human.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f));
            TranslationHelper.OptionEntry fairy = new TranslationHelper.OptionEntry("fairyticks", Float.valueOf((float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.fairy.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f));
            TranslationHelper.OptionEntry dwarf = new TranslationHelper.OptionEntry("dwarfticks", Float.valueOf((float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.dwarf.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f));
            TranslationHelper.OptionEntry titan = new TranslationHelper.OptionEntry("titanticks", Float.valueOf((float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.titan.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f));
            TranslationHelper.OptionEntry goblin = new TranslationHelper.OptionEntry("goblinticks", Float.valueOf((float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.goblin.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f));
            TranslationHelper.OptionEntry elf = new TranslationHelper.OptionEntry("elfticks", Float.valueOf((float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.elf.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f));
            TranslationHelper.OptionEntry faelis = new TranslationHelper.OptionEntry("faelisticks", Float.valueOf((float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.faelis.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f));
            TranslationHelper.OptionEntry dragon = new TranslationHelper.OptionEntry("dragonticks", Float.valueOf((float)MathHelper.func_76125_a((int)TrinketsConfig.SERVER.Potion.dragon.Duration, (int)0, (int)Integer.MAX_VALUE) / 20.0f));
            for (int i = 1; i < 10; ++i) {
                String key = "xat." + stack.func_77977_a() + "." + pot.getRegistryName().func_110623_a() + ".tooltip" + i;
                String string = helper.getLangTranslation(key, lang -> helper.formatAddVariables((String)lang, human, fairy, dwarf, titan, goblin, elf, faelis, dragon));
                if (helper.isStringEmpty(string)) continue;
                event.getToolTip().add(string);
            }
        }
    }
}

