/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.race;

import com.google.common.base.Objects;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.api.events.TransformationEvent;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.attributes.RaceAttribute.RaceAttribute;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.capabilities.race.KeybindHandler;
import xzeroair.trinkets.entity.AlphaWolf;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.SyncRaceDataPacket;
import xzeroair.trinkets.network.trinketcontainer.OpenTrinketGui;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.IRaceProvider;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.AttributeHelper;
import xzeroair.trinkets.util.helpers.StringUtils;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class EntityProperties
extends CapabilityBase<EntityProperties, EntityLivingBase> {
    protected boolean first_login = true;
    protected boolean login = true;
    protected boolean changed = false;
    protected boolean sync = false;
    protected EntityRace previous = EntityRaces.none;
    protected EntityRace original = EntityRaces.none;
    protected EntityRace imbued = EntityRaces.none;
    protected EntityRace current = EntityRaces.none;
    protected int widthValue = 100;
    protected int heightValue = 100;
    protected float defaultWidth = 1.8f;
    protected float defaultHeight = 0.6f;
    protected boolean traitShown = true;
    protected String traitColor = "16777215";
    protected boolean isFake = false;
    protected ItemStack raceProvider = ItemStack.field_190927_a;
    protected KeybindHandler keybindHandler;
    protected EntityRacePropertiesHandler properties;
    protected AbilityHandler abilities;
    protected float stepHeightPrev = 0.6f;
    protected boolean onGround;
    protected boolean isChild;
    protected BlockPos prevBlockpos;
    protected double prev_posx;
    protected double prev_posy;
    protected double prev_posz;

    public EntityProperties(EntityLivingBase e) {
        super(e);
        this.defaultHeight = e.field_70131_O;
        this.defaultWidth = e.field_70130_N;
        this.original = EntityRaces.none;
        this.previous = EntityRaces.none;
        this.imbued = EntityRaces.none;
        this.current = EntityRaces.none;
        this.abilities = new AbilityHandler((EntityLivingBase)this.object);
        this.properties = this.current.getRaceHandler((EntityLivingBase)this.object).setEntityProperties(this);
    }

    @Override
    public NBTTagCompound getTag() {
        NBTTagCompound tag = ((EntityLivingBase)this.object).getEntityData();
        if (tag != null) {
            NBTTagCompound persistentData;
            if (this.object instanceof EntityPlayer) {
                if (!tag.func_74764_b("PlayerPersisted")) {
                    tag.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
                }
                persistentData = tag.func_74775_l("PlayerPersisted");
            } else {
                persistentData = tag;
            }
            String capTag = "xat.race";
            if (!persistentData.func_74764_b("xat.race")) {
                persistentData.func_74782_a("xat.race", (NBTBase)new NBTTagCompound());
            }
            return persistentData.func_74775_l("xat.race");
        }
        return super.getTag();
    }

    public AbilityHandler getAbilityHandler() {
        return this.abilities;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderLivingBase renderer, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.getRaceHandler().doRenderLayer(renderer, this.isFake(), isSlim, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
    }

    public void onUpdatePre() {
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        boolean isClient = world.field_72995_K;
        if (!(this.object instanceof FakePlayer) && this.object instanceof EntityPlayer) {
            this.onGround = ((EntityLivingBase)this.object).field_70122_E;
        }
    }

    @Override
    public void onUpdate() {
        BlockPos blockpos;
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        boolean isClient = world.field_72995_K;
        if (isClient && TrinketsConfig.CLIENT.debug.showMovementSpeed) {
            StringUtils.sendMessageToPlayer((Entity)this.object, "Bp/t:" + this.entitySpeed((EntityLivingBase)this.object), true);
        }
        this.stepHeightHandler();
        if (!(this.object instanceof FakePlayer) && this.object instanceof EntityPlayer) {
            this.onPlayerUpdate(world, (EntityPlayer)this.object);
        } else {
            this.onEntityUpdate(world, (EntityLivingBase)this.object);
        }
        if (this.sync) {
            this.sendInformationToTracking();
            this.sync = false;
        }
        this.setLogin(false);
        this.setFirstLogin(false);
        if (!isClient && !Objects.equal((Object)this.prevBlockpos, (Object)(blockpos = new BlockPos((Entity)this.object)))) {
            this.prevBlockpos = blockpos;
        }
    }

    public void onPlayerUpdate(World world, EntityPlayer player) {
        boolean isClient = world.field_72995_K;
        if (!isClient && !this.getCurrentRace().isNone()) {
            player.field_70122_E = this.onGround;
        }
        if (this.isLogin()) {
            this.getRaceHandler().setFirstUpdate(true);
        }
        this.updateRace();
        this.abilities.updateAbilityHandler();
        this.getRaceHandler().onTick();
        if (this.sync && !isClient) {
            this.sendInformationToPlayer((EntityLivingBase)player);
        }
    }

    public void onEntityUpdate(World world, EntityLivingBase entity) {
        List<TrinketHelper.SlotInformation> equipment;
        if (((EntityLivingBase)this.object).func_70631_g_()) {
            return;
        }
        boolean isClient = world.field_72995_K;
        ResourceLocation regName = EntityRegistry.getEntry(entity.getClass()).getRegistryName();
        String modID = regName.func_110624_b();
        String name = regName.func_110623_a();
        if (modID.equalsIgnoreCase("iceandfire")) {
            return;
        }
        if (this.isFirstLogin()) {
            IAttributeInstance stepheight = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(JumpAttribute.stepHeight);
            if (stepheight != null) {
                stepheight.func_111128_a((double)((EntityLivingBase)this.object).field_70138_W);
            }
            this.stepHeightPrev = ((EntityLivingBase)this.object).field_70138_W;
            this.setDefaultHeight(((EntityLivingBase)this.object).field_70131_O);
            this.setDefaultWidth(((EntityLivingBase)this.object).field_70130_N);
            this.saveToNBT(this.getTag());
        }
        if (this.isLogin()) {
            this.scheduleResync();
        }
        this.updateRace();
        this.getRaceHandler().onTick();
        if (!(this.object instanceof EntityPlayer) && !(equipment = TrinketHelper.getSlotInfoForArmor((EntityLivingBase)this.object, s -> !s.func_190926_b() && s.func_77973_b() instanceof IAccessoryInterface)).isEmpty()) {
            for (TrinketHelper.SlotInformation info : equipment) {
                ItemStack equipStack = info.getStackFromHandler((EntityLivingBase)this.object);
                if (equipStack.func_190926_b() || !(equipStack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)equipStack.func_77973_b();
                item.onEntityArmorTick(world, (EntityLivingBase)this.object, equipStack);
            }
        }
    }

    public void onChildUpdate(World world, EntityLivingBase entity) {
        boolean isClient = world.field_72995_K;
        if (this.isFirstLogin()) {
            IAttributeInstance stepheight = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(JumpAttribute.stepHeight);
            if (stepheight != null) {
                stepheight.func_111128_a((double)((EntityLivingBase)this.object).field_70138_W);
            }
            this.stepHeightPrev = ((EntityLivingBase)this.object).field_70138_W;
            this.setDefaultHeight(((EntityLivingBase)this.object).field_70131_O);
            this.setDefaultWidth(((EntityLivingBase)this.object).field_70130_N);
            this.saveToNBT(this.getTag());
        }
        if (this.isLogin()) {
            this.scheduleResync();
        }
        this.updateRace();
        this.getRaceHandler().onTick();
    }

    public void updateRace() {
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        boolean isClient = world.field_72995_K;
        if (isClient) {
            return;
        }
        EntityRace race = this.getEntityRace();
        TransformationEvent.RaceUpdateEvent UpdateEvent = new TransformationEvent.RaceUpdateEvent((EntityLivingBase)this.object, this, this.getRaceHandler().getRace(), race);
        if (!MinecraftForge.EVENT_BUS.post((Event)UpdateEvent) && UpdateEvent.raceChanged()) {
            IAttributeInstance attribute;
            EntityRacePropertiesHandler oldProperties;
            TransformationEvent.EndTransformation end;
            EntityRace newRace = UpdateEvent.getNewRace();
            if (newRace == null) {
                newRace = EntityRaces.none;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)(end = new TransformationEvent.EndTransformation((EntityLivingBase)this.object, this, (oldProperties = this.getRaceHandler()).getRace())))) {
                return;
            }
            oldProperties.onTransformEnd();
            AttributeHelper.removeAttributesByUUID((EntityLivingBase)this.object, this.getPreviousRace().getUUID(), oldProperties.getRace().getUUID());
            this.setPreviousRace(oldProperties.getRace());
            Entity mount = ((EntityLivingBase)this.object).func_184187_bx();
            if (mount instanceof AlphaWolf) {
                ((EntityLivingBase)this.object).func_184210_p();
            }
            if ((attribute = ((EntityLivingBase)this.object).func_110140_aT().func_111151_a(JumpAttribute.stepHeight)) != null && (double)((EntityLivingBase)this.object).field_70138_W != attribute.func_111125_b()) {
                ((EntityLivingBase)this.object).field_70138_W = (float)attribute.func_111125_b();
            }
            this.properties = newRace.getRaceHandler((EntityLivingBase)this.object).setEntityProperties(this);
            this.properties.onTransform();
            this.setCurrent(newRace);
            TransformationEvent.StartTransformation start = new TransformationEvent.StartTransformation((EntityLivingBase)this.object, this, this.properties.getRace());
            MinecraftForge.EVENT_BUS.post((Event)start);
            this.scheduleResync();
        }
    }

    public BlockPos getPrevBlockpos() {
        if (this.prevBlockpos == null) {
            this.prevBlockpos = ((EntityLivingBase)this.object).func_180425_c();
        }
        return this.prevBlockpos;
    }

    public KeybindHandler getKeybindHandler() {
        if (this.keybindHandler == null) {
            this.keybindHandler = new KeybindHandler();
        }
        return this.keybindHandler;
    }

    private EntityRace getEntityRace() {
        EntityRace potionRace = this.getPotionRace();
        if (potionRace != null && !potionRace.isNone()) {
            this.setFake(true);
            return potionRace;
        }
        ItemStack provider = this.getRaceProvider();
        if (!provider.func_190926_b()) {
            this.setFake(true);
            return ((IRaceProvider)provider.func_77973_b()).getRace();
        }
        EntityRace imbued = this.getImbuedRace();
        if (imbued != null && !imbued.equals(EntityRaces.none)) {
            this.setFake(false);
            return imbued;
        }
        this.setFake(false);
        return this.getOriginalRace();
    }

    protected EntityRace getPotionRace() {
        Iterator iterator;
        IAttributeInstance race = ((EntityLivingBase)this.object).func_110148_a(RaceAttribute.ENTITY_RACE);
        if (race != null && !race.func_111122_c().isEmpty() && (iterator = race.func_111122_c().iterator()).hasNext()) {
            AttributeModifier modifier = (AttributeModifier)iterator.next();
            return EntityRace.getByUUID(modifier.func_111167_a());
        }
        return null;
    }

    protected ItemStack getRaceProvider() {
        int count = TrinketHelper.countAccessories((EntityLivingBase)this.object, stack -> stack.func_77973_b() instanceof IRaceProvider);
        if (count > 1 || count < 1) {
            return ItemStack.field_190927_a;
        }
        return TrinketHelper.getAccessory((EntityLivingBase)this.object, stack -> stack.func_77973_b() instanceof IRaceProvider);
    }

    private void stepHeightHandler() {
        IAttributeInstance attribute = ((EntityLivingBase)this.object).func_110148_a(JumpAttribute.stepHeight);
        if (attribute != null && !attribute.func_111122_c().isEmpty()) {
            float defaultStepHeight = (float)attribute.func_111125_b();
            float attributeStepHeight = (float)attribute.func_111126_e();
            float currentStepHeight = ((EntityLivingBase)this.object).field_70138_W;
            ((EntityLivingBase)this.object).field_70138_W = defaultStepHeight;
            if (currentStepHeight - ((EntityLivingBase)this.object).field_70138_W == 0.0f) {
                ((EntityLivingBase)this.object).field_70138_W = attributeStepHeight;
                this.stepHeightPrev = defaultStepHeight;
            } else if (currentStepHeight - ((EntityLivingBase)this.object).field_70138_W - attributeStepHeight == -defaultStepHeight) {
                ((EntityLivingBase)this.object).field_70138_W = attributeStepHeight;
                this.stepHeightPrev = defaultStepHeight;
            } else {
                float stepP = this.stepHeightPrev;
                this.stepHeightPrev = currentStepHeight;
                if (attributeStepHeight - defaultStepHeight + currentStepHeight == attributeStepHeight - defaultStepHeight + stepP) {
                    ((EntityLivingBase)this.object).field_70138_W = attributeStepHeight - defaultStepHeight + this.stepHeightPrev;
                }
            }
        }
    }

    public void startVec(EntityLivingBase entity) {
        this.prev_posx = entity.field_70165_t;
        this.prev_posy = entity.field_70163_u;
        this.prev_posz = entity.field_70161_v;
    }

    public Vec3d lastVec() {
        Vec3d lastPosVec = new Vec3d(this.prev_posx, this.prev_posy, this.prev_posz);
        return lastPosVec;
    }

    public double entitySpeed(EntityLivingBase entity) {
        Vec3d currentPosVec = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double distanceTraveled = this.lastVec().func_72438_d(currentPosVec);
        this.startVec(entity);
        return distanceTraveled;
    }

    public void onLogin() {
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        if (!world.field_72995_K && this.object instanceof EntityPlayerMP) {
            if (this.isFirstLogin()) {
                if (TrinketsConfig.SERVER.races.selectionMenu) {
                    NetworkHandler.sendTo(new OpenTrinketGui(4), (EntityPlayerMP)this.object);
                }
            } else {
                this.sendInformationToPlayer((EntityLivingBase)this.object, this.getTag());
            }
        }
    }

    public void onLogoff() {
        if (this.getCurrentRace().equals(EntityRaces.goblin) && ((EntityLivingBase)this.object).func_184187_bx() instanceof AlphaWolf) {
            ((EntityLivingBase)this.object).func_184210_p();
        }
    }

    public void sendInformationToPlayer(EntityLivingBase receiver) {
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        if (!world.field_72995_K) {
            this.sendInformationToPlayer(receiver, this.saveToNBT(this.getTag()));
        }
    }

    public void sendInformationToPlayer(EntityLivingBase receiver, NBTTagCompound tag) {
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        if (!world.field_72995_K && receiver instanceof EntityPlayerMP) {
            NetworkHandler.sendTo(new SyncRaceDataPacket((EntityLivingBase)this.object, tag), (EntityPlayerMP)receiver);
        }
    }

    public void sendInformationToTracking() {
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        if (!world.field_72995_K && world instanceof WorldServer) {
            WorldServer w = (WorldServer)world;
            NetworkHandler.sendToClients(w, ((EntityLivingBase)this.object).func_180425_c(), new SyncRaceDataPacket((EntityLivingBase)this.object, this.saveToNBT(this.getTag())));
        }
    }

    public void sendInformationToServer() {
        World world = ((EntityLivingBase)this.object).func_130014_f_();
        if (world.field_72995_K) {
            NetworkHandler.sendToServer(new SyncRaceDataPacket((EntityLivingBase)this.object, this.saveToNBT(this.getTag())));
        }
    }

    @Deprecated
    public int getSize() {
        return this.getHeightValue();
    }

    public boolean isNormalSize() {
        return ((EntityLivingBase)this.object).field_70131_O == this.getDefaultHeight() && ((EntityLivingBase)this.object).field_70130_N == this.getDefaultWidth();
    }

    public boolean hasRace() {
        return !this.current.equals(EntityRaces.none);
    }

    public EntityRacePropertiesHandler getRaceHandler() {
        return this.properties.setEntityProperties(this);
    }

    public EntityRace getPreviousRace() {
        return this.previous;
    }

    public void setPreviousRace(EntityRace race) {
        if (this.previous != race) {
            this.previous = race != null ? race : EntityRaces.none;
        }
    }

    public EntityRace getCurrentRace() {
        return this.current;
    }

    public void setCurrent(EntityRace race) {
        if (this.current != race) {
            this.current = race != null ? race : EntityRaces.none;
        }
    }

    public EntityRace getImbuedRace() {
        return this.imbued;
    }

    public void setImbuedRace(EntityRace race) {
        if (this.imbued != race) {
            this.imbued = race != null ? race : EntityRaces.none;
        }
    }

    public EntityRace getOriginalRace() {
        return this.original;
    }

    public void setOriginalRace(EntityRace race) {
        if (this.original != race) {
            this.original = race != null ? race : EntityRaces.none;
        }
    }

    public float getDefaultWidth() {
        return this.defaultWidth;
    }

    private void setDefaultWidth(float defaultWidth) {
        if (this.defaultWidth != defaultWidth) {
            this.defaultWidth = defaultWidth;
        }
    }

    public float getDefaultHeight() {
        return this.defaultHeight;
    }

    private void setDefaultHeight(float defaultHeight) {
        if (this.defaultHeight != defaultHeight) {
            this.defaultHeight = defaultHeight;
        }
    }

    public int getHeightValue() {
        return this.heightValue;
    }

    public void setHeightValue(int height) {
        if (this.heightValue != height) {
            this.heightValue = height;
        }
    }

    public int getWidthValue() {
        return this.widthValue;
    }

    public void setWidthValue(int width) {
        if (this.widthValue != width) {
            this.widthValue = width;
        }
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        if (this.login != login) {
            this.login = login;
        }
    }

    public boolean isFirstLogin() {
        return this.first_login;
    }

    public void setFirstLogin(boolean firstLogin) {
        if (this.first_login != firstLogin) {
            this.first_login = firstLogin;
        }
    }

    public boolean isFake() {
        return this.isFake;
    }

    public void setFake(boolean isFake) {
        if (this.isFake != isFake) {
            this.isFake = isFake;
            this.scheduleResync();
        }
    }

    public boolean isChild() {
        return this.isChild;
    }

    public void setChild(boolean isChild) {
        if (this.isChild != isChild) {
            this.isChild = isChild;
        }
    }

    public void scheduleResync() {
        this.sync = true;
    }

    @Override
    public void copyFrom(EntityProperties source, boolean wasDeath, boolean keepInv) {
        this.first_login = source.first_login;
        this.login = source.login;
        this.defaultWidth = source.defaultWidth;
        this.defaultHeight = source.defaultHeight;
        this.original = source.original;
        this.imbued = source.imbued;
        this.isChild = source.isChild;
        if (wasDeath && !keepInv) {
            this.previous = source.current;
            this.current = this.imbued.isNone() ? this.original : this.imbued;
            this.heightValue = this.current.getRaceHeight();
            this.widthValue = this.current.getRaceWidth();
        } else {
            this.current = source.current;
            this.previous = source.previous;
            this.heightValue = source.heightValue;
            this.widthValue = source.widthValue;
        }
        this.properties = this.current.getRaceHandler((EntityLivingBase)this.object).setEntityProperties(this);
        this.properties.onTransform();
        try {
            this.getRaceHandler().copyFrom(source.getRaceHandler(), wasDeath, keepInv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.getAbilityHandler().copyFrom(source.getAbilityHandler(), wasDeath, keepInv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.scheduleResync();
    }

    @Override
    public NBTTagCompound saveToNBT(NBTTagCompound compound) {
        compound.func_74778_a("original_race", this.getOriginalRace().getRegistryName().toString());
        compound.func_74778_a("imbued_race", this.getImbuedRace().getRegistryName().toString());
        compound.func_74778_a("prev_race", this.getPreviousRace().getRegistryName().toString());
        compound.func_74778_a("current_race", this.getCurrentRace().getRegistryName().toString());
        compound.func_74768_a("heightValue", this.getHeightValue());
        compound.func_74768_a("widthValue", this.getWidthValue());
        compound.func_74776_a("default_height", this.getDefaultHeight());
        compound.func_74776_a("default_width", this.getDefaultWidth());
        compound.func_74757_a("login", this.isLogin());
        compound.func_74757_a("first_login", this.isFirstLogin());
        compound.func_74757_a("fake", this.isFake());
        compound.func_74757_a("child", this.isChild());
        this.getRaceHandler().savedNBTData(compound);
        this.getAbilityHandler().saveAbilitiesToNBT(compound);
        return compound;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("first_login")) {
            this.first_login = compound.func_74767_n("first_login");
        }
        if (compound.func_74764_b("login")) {
            this.login = compound.func_74767_n("login");
        }
        if (compound.func_74764_b("original_race")) {
            EntityRace originalRace = EntityRace.getByNameOrId(compound.func_74779_i("original_race"));
            this.original = originalRace == null ? EntityRaces.none : originalRace;
        }
        if (compound.func_74764_b("imbued_race")) {
            EntityRace imbuedRace = EntityRace.getByNameOrId(compound.func_74779_i("imbued_race"));
            this.imbued = imbuedRace == null ? EntityRaces.none : imbuedRace;
        }
        if (compound.func_74764_b("prev_race")) {
            EntityRace previousRace = EntityRace.getByNameOrId(compound.func_74779_i("prev_race"));
            this.previous = previousRace == null ? EntityRaces.none : previousRace;
        }
        if (compound.func_74764_b("current_race")) {
            EntityRace currentRace = EntityRace.getByNameOrId(compound.func_74779_i("current_race"));
            this.current = currentRace == null ? EntityRaces.none : currentRace;
            if (this.properties.getRace() != this.current) {
                this.properties = this.current.getRaceHandler((EntityLivingBase)this.object).setEntityProperties(this);
                this.properties.onTransform();
            }
        }
        if (compound.func_74764_b("heightValue")) {
            this.heightValue = compound.func_74762_e("heightValue");
        }
        if (compound.func_74764_b("widthValue")) {
            this.widthValue = compound.func_74762_e("widthValue");
        }
        if (compound.func_74764_b("default_height")) {
            this.defaultHeight = compound.func_74760_g("default_height");
        }
        if (compound.func_74764_b("default_width")) {
            this.defaultWidth = compound.func_74760_g("default_width");
        }
        if (compound.func_74764_b("fake")) {
            this.isFake = compound.func_74767_n("fake");
        }
        if (compound.func_74764_b("child")) {
            this.isChild = compound.func_74767_n("child");
        }
        this.getRaceHandler().loadNBTData(compound);
        this.getAbilityHandler().loadAbilitiesFromNBT(compound);
    }

    private static class TempCache<A, B> {
        private final A first;
        private final B second;

        public TempCache(A first, B second) {
            this.first = first;
            this.second = second;
        }

        public A getFirst() {
            return this.first;
        }

        public B getSecond() {
            return this.second;
        }
    }
}

