/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.TileEntityCap;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.handlers.Counter;
import xzeroair.trinkets.util.helpers.BlockHelperUtil;

public class TileEntityProperties
extends CapabilityBase<TileEntityProperties, TileEntity> {
    protected boolean hasEssence = false;
    protected int essence = -1;

    public TileEntityProperties(TileEntity te) {
        super(te);
    }

    @Override
    public NBTTagCompound getTag() {
        NBTTagCompound teTag = ((TileEntity)this.object).getTileData();
        if (teTag != null) {
            String capTag = "xat.TrinketTE";
            if (!teTag.func_74764_b("xat.TrinketTE")) {
                teTag.func_74782_a("xat.TrinketTE", (NBTBase)new NBTTagCompound());
            }
            this.tag = teTag.func_74775_l("xat.TrinketTE");
        }
        return super.getTag();
    }

    public TileEntityProperties setHasEssence(boolean has) {
        return this.setHasEssence(has, TrinketsConfig.SERVER.mana.essence_amount);
    }

    public TileEntityProperties setHasEssence(boolean has, int essence) {
        this.hasEssence = has;
        this.essence = essence;
        return this;
    }

    @Override
    public void onUpdate() {
        if (this.hasEssence()) {
            this.updateEssence();
        } else {
            ((TileEntity)this.object).func_145831_w().func_175698_g(((TileEntity)this.object).func_174877_v());
        }
    }

    private void updateEssence() {
        BlockPos pos2;
        World world = ((TileEntity)this.object).func_145831_w();
        BlockPos tePos = ((TileEntity)this.object).func_174877_v();
        if (world == null || world.field_72995_K) {
            return;
        }
        int teEssence = this.getEssence();
        double range = 5.0;
        double rangeY = 2.0;
        BlockPos pos1 = ((TileEntity)this.object).func_174877_v().func_177963_a(-5.0, -2.0, -5.0);
        boolean skip = BlockHelperUtil.isBlockNearby(world, new AxisAlignedBB(pos1, pos2 = ((TileEntity)this.object).func_174877_v().func_177963_a(5.0, 2.0, 5.0)), (state, pos) -> {
            Block block = state.func_177230_c();
            TileEntity te = world.func_175625_s(pos);
            boolean isSelf = tePos.equals(pos);
            if (te == null || isSelf || te == this.object) {
                return false;
            }
            return Capabilities.getTEProperties(te, false, (prop, matches) -> prop.hasEssence());
        });
        if (skip) {
            return;
        }
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(((TileEntity)this.object).func_174877_v()).func_186662_g(4.0));
        if (!entities.isEmpty()) {
            for (EntityLivingBase e : entities) {
                Capabilities.getMagicStats((Entity)e, prop -> {
                    Counter counter;
                    if (e.func_70093_af() && (counter = this.getTickHandler().getCounter("absorb.cooldown", TrinketsConfig.SERVER.mana.essence_cooldown, false, true, true, false)).Tick()) {
                        double currentBonus = prop.getBonusMana();
                        double addedAmount = 1.0;
                        prop.setBonusMana(currentBonus + addedAmount);
                        this.setEssence(teEssence - 1);
                        Random rand = Reference.random;
                        world.func_184133_a((EntityPlayer)null, tePos, SoundEvents.field_193784_dd, SoundCategory.BLOCKS, 0.4f, rand.nextFloat() * 0.6f + 0.4f);
                    }
                });
            }
        }
        if (teEssence != this.getEssence()) {
            this.saveToNBT(this.getTag());
            ((TileEntity)this.object).func_70296_d();
        }
    }

    public boolean hasEssence() {
        return this.hasEssence && this.getEssence() > 0;
    }

    public int getEssence() {
        return this.essence;
    }

    public void setEssence(int essence) {
        if (this.essence != essence) {
            this.essence = essence;
        }
    }

    @Override
    public NBTTagCompound saveToNBT(NBTTagCompound compound) {
        compound.func_74757_a("provides", this.hasEssence);
        compound.func_74768_a("essence", this.essence);
        return compound;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("provides")) {
            this.hasEssence = compound.func_74767_n("provides");
        }
        if (compound.func_74764_b("essence")) {
            this.essence = compound.func_74762_e("essence");
        }
    }
}

