/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.blocks.materials.TrinketBlockMaterial;
import xzeroair.trinkets.blocks.tileentities.TileEntityTeddyBear;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.util.interfaces.IsModelLoaded;

public class BlockTeddyBear
extends BlockHorizontal
implements IsModelLoaded {
    protected static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.8, 0.8);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.2, 0.0, 0.15, 0.8, 0.8, 0.85);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.2, 0.0, 0.15, 0.8, 0.8, 0.85);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.15, 0.0, 0.2, 0.85, 0.8, 0.8);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.15, 0.0, 0.2, 0.85, 0.8, 0.8);
    private static final AxisAlignedBB HITBOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockTeddyBear() {
        super(TrinketBlockMaterial.ClothTeddyBear);
        this.func_149672_a(SoundType.field_185854_g);
        this.setRegistryName("xat", "teddy_bear");
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149715_a(0.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    public BlockTeddyBear(String name) {
        super(TrinketBlockMaterial.ClothTeddyBear);
        this.func_149672_a(SoundType.field_185854_g);
        this.setRegistryName("xat", "teddy_bear_" + name);
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149715_a(0.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTeddyBear();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, world, tooltip, flagIn);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState blockBelow = world.func_180495_p(pos.func_177977_b());
        if (blockBelow.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) {
            return super.func_176196_c(world, pos);
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(world, pos, state);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(world, pos, state);
    }

    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        IBlockState down;
        return state.func_177230_c() != this || (down = world.func_180495_p(pos.func_177977_b())).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity TileEntity2 = worldIn.func_175625_s(pos);
        if (TileEntity2 instanceof TileEntityTeddyBear) {
            ((TileEntityTeddyBear)TileEntity2).setTeddyBear(stack);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity TileEntity2 = world.func_175625_s(pos);
        if (TileEntity2 instanceof TileEntityTeddyBear) {
            ItemStack stack = ((TileEntityTeddyBear)TileEntity2).getTeddyBear();
            if (stack != null && !stack.func_190926_b()) {
                drops.add((Object)stack);
            }
        } else {
            System.out.println("Something went wrong, Please Report this with the circumstances prior to it happening");
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.trinkets.TrinketTeddyBear;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            default: {
                return DEFAULT_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return Block.field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178441_a());
    }
}

