/*
 * Decompiled with CFR 0.152.
 */
package azmalent.potiondescriptions.client;

import azmalent.potiondescriptions.ModConfig;
import com.mojang.realmsclient.gui.ChatFormatting;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rustic.common.items.ModItems;
import rustic.common.util.ElixirUtils;
import vazkii.botania.api.brew.IBrewItem;
import xreliquary.items.ItemPotionEssence;
import xreliquary.items.ItemXRPotion;
import xreliquary.items.ItemXRTippedArrow;
import xreliquary.util.potions.XRPotionHelper;

@SideOnly(value=Side.CLIENT)
public class TooltipHandler {
    private static final boolean BOTANIA_LOADED = Loader.isModLoaded((String)"botania");
    private static final boolean ACTUALLY_ADDITIONS_LOADED = Loader.isModLoaded((String)"actuallyadditions");
    private static final boolean RUSTIC_LOADED = Loader.isModLoaded((String)"rustic");
    private static final boolean RELIQUARY_LOADED = Loader.isModLoaded((String)"xreliquary");

    @SubscribeEvent
    public void onPotionTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_190926_b()) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Potion")) {
            List effects = PotionUtils.func_185189_a((ItemStack)itemStack);
            this.addTooltip(effects, event.getToolTip());
            if (!ModConfig.isModIgnored("extraalchemy").booleanValue()) {
                this.removeExtraAlchemyCredits(event.getToolTip());
            }
        } else if (BOTANIA_LOADED && item instanceof IBrewItem) {
            List effects = ((IBrewItem)item).getBrew(itemStack).getPotionEffects(itemStack);
            this.addTooltip(effects, event.getToolTip());
        } else if (ACTUALLY_ADDITIONS_LOADED && item == InitItems.itemCoffee) {
            PotionEffect[] effects = ActuallyAdditionsAPI.methodHandler.getEffectsFromStack(itemStack);
            if (effects != null && effects.length > 0) {
                this.addTooltip(Arrays.asList(effects), event.getToolTip());
            }
        } else if (RUSTIC_LOADED && item == ModItems.ELIXIR) {
            List effects = ElixirUtils.getEffects((ItemStack)itemStack);
            this.addTooltip(effects, event.getToolTip());
        } else if (RELIQUARY_LOADED && (item instanceof ItemPotionEssence || item instanceof ItemXRPotion || item instanceof ItemXRTippedArrow)) {
            List effects = XRPotionHelper.getPotionEffectsFromStack((ItemStack)itemStack);
            this.addTooltip(effects, event.getToolTip());
        }
    }

    private void addTooltip(List<PotionEffect> effectList, List<String> tooltip) {
        Set effects = effectList.stream().filter(effect -> TooltipHandler.isIgnored(effect) == false).collect(Collectors.toSet());
        if (effects.isEmpty()) {
            return;
        }
        KeyBinding sneakButton = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        boolean sneaking = GameSettings.func_100015_a((KeyBinding)sneakButton);
        if (!sneaking && ModConfig.sneakRequired && ModConfig.sneakMessageEnabled) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.potiondescriptions.sneakToView", (Object[])new Object[]{sneakButton.getDisplayName()}));
            return;
        }
        if (sneaking || !ModConfig.sneakRequired) {
            for (PotionEffect effect2 : effects) {
                Potion potion = effect2.func_188419_a();
                String description = TooltipHandler.getEffectDescription(potion);
                ChatFormatting effectFormat = potion.func_188408_i() ? ChatFormatting.BLUE : ChatFormatting.RED;
                String potionName = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                tooltip.add(I18n.func_135052_a((String)"tooltip.potiondescriptions.effect", (Object[])new Object[]{effectFormat, potionName}));
                tooltip.add(description != null ? description : I18n.func_135052_a((String)"tooltip.potiondescriptions.missingDescription", (Object[])new Object[]{"description." + potion.func_76393_a()}));
                tooltip.add(I18n.func_135052_a((String)"tooltip.potiondescriptions.sourceMod", (Object[])new Object[]{TooltipHandler.getModName((IForgeRegistryEntry)potion)}));
            }
        }
    }

    private void removeExtraAlchemyCredits(List<String> tooltip) {
        String credit = ChatFormatting.GOLD + I18n.func_135052_a((String)"tooltip.credit", (Object[])new Object[]{""});
        String uncertainCredit = ChatFormatting.GOLD + I18n.func_135052_a((String)"tooltip.credit.uncertain", (Object[])new Object[]{""});
        Iterator<String> iterator = tooltip.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (!line.startsWith(credit) && !line.startsWith(uncertainCredit)) continue;
            iterator.remove();
            break;
        }
    }

    private static String getModName(IForgeRegistryEntry entry) {
        String modid = entry.getRegistryName().func_110624_b();
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (mod != null) {
            return mod.getName();
        }
        return modid;
    }

    private static String getEffectDescription(Potion potion) {
        String translationKey = "description." + potion.func_76393_a();
        if (I18n.func_188566_a((String)translationKey)) {
            return I18n.func_135052_a((String)translationKey, (Object[])new Object[0]);
        }
        return null;
    }

    private static Boolean isIgnored(PotionEffect effect) {
        String modid = effect.func_188419_a().getRegistryName().func_110624_b();
        return ModConfig.isModIgnored(modid);
    }
}

