/*
 * Decompiled with CFR 0.152.
 */
package meldexun.memoryutil;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import meldexun.memoryutil.LongLongFunction;
import meldexun.memoryutil.NIOBufferUtil;
import meldexun.memoryutil.PrimitiveInfo;
import meldexun.memoryutil.UnsafeBuffer;
import meldexun.memoryutil.UnsafeByteBuffer;
import meldexun.memoryutil.UnsafeCharBuffer;
import meldexun.memoryutil.UnsafeDoubleBuffer;
import meldexun.memoryutil.UnsafeFloatBuffer;
import meldexun.memoryutil.UnsafeIntBuffer;
import meldexun.memoryutil.UnsafeLongBuffer;
import meldexun.memoryutil.UnsafeShortBuffer;

public interface BufferFactory<T> {
    public static final BufferFactory<UnsafeBuffer> UNSAFE_BUFFER = BufferFactory.of(UnsafeBuffer::new, PrimitiveInfo.BYTE);
    public static final BufferFactory<UnsafeByteBuffer> UNSAFE_BYTE_BUFFER = BufferFactory.of(UnsafeByteBuffer::new, PrimitiveInfo.BYTE);
    public static final BufferFactory<UnsafeShortBuffer> UNSAFE_SHORT_BUFFER = BufferFactory.of(UnsafeShortBuffer::new, PrimitiveInfo.SHORT);
    public static final BufferFactory<UnsafeIntBuffer> UNSAFE_INT_BUFFER = BufferFactory.of(UnsafeIntBuffer::new, PrimitiveInfo.INT);
    public static final BufferFactory<UnsafeLongBuffer> UNSAFE_LONG_BUFFER = BufferFactory.of(UnsafeLongBuffer::new, PrimitiveInfo.LONG);
    public static final BufferFactory<UnsafeFloatBuffer> UNSAFE_FLOAT_BUFFER = BufferFactory.of(UnsafeFloatBuffer::new, PrimitiveInfo.FLOAT);
    public static final BufferFactory<UnsafeDoubleBuffer> UNSAFE_DOUBLE_BUFFER = BufferFactory.of(UnsafeDoubleBuffer::new, PrimitiveInfo.DOUBLE);
    public static final BufferFactory<UnsafeCharBuffer> UNSAFE_CHAR_BUFFER = BufferFactory.of(UnsafeCharBuffer::new, PrimitiveInfo.CHAR);
    public static final BufferFactory<ByteBuffer> NIO_BYTE_BUFFER = BufferFactory.of(NIOBufferUtil::asByteBuffer, PrimitiveInfo.BYTE);
    public static final BufferFactory<ShortBuffer> NIO_SHORT_BUFFER = BufferFactory.of(NIOBufferUtil::asShortBuffer, PrimitiveInfo.SHORT);
    public static final BufferFactory<IntBuffer> NIO_INT_BUFFER = BufferFactory.of(NIOBufferUtil::asIntBuffer, PrimitiveInfo.INT);
    public static final BufferFactory<LongBuffer> NIO_LONG_BUFFER = BufferFactory.of(NIOBufferUtil::asLongBuffer, PrimitiveInfo.LONG);
    public static final BufferFactory<FloatBuffer> NIO_FLOAT_BUFFER = BufferFactory.of(NIOBufferUtil::asFloatBuffer, PrimitiveInfo.FLOAT);
    public static final BufferFactory<DoubleBuffer> NIO_DOUBLE_BUFFER = BufferFactory.of(NIOBufferUtil::asDoubleBuffer, PrimitiveInfo.DOUBLE);
    public static final BufferFactory<CharBuffer> NIO_CHAR_BUFFER = BufferFactory.of(NIOBufferUtil::asCharBuffer, PrimitiveInfo.CHAR);

    public static <T> BufferFactory<T> of(final LongLongFunction<T> f, final PrimitiveInfo type) {
        return new BufferFactory<T>(){

            @Override
            public T create(long address, long capacity) {
                return f.apply(address, capacity);
            }

            @Override
            public PrimitiveInfo type() {
                return type;
            }
        };
    }

    default public T create(long address, long capacity, PrimitiveInfo srcType) {
        return this.create(address, srcType.convertTo(this.type(), capacity));
    }

    public T create(long var1, long var3);

    public PrimitiveInfo type();
}

