/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WorldRadiusUtil {
    public static List<Entity> getEntitiesWithinAABBExcludingEntity(World world, @Nullable Entity entityIn, AxisAlignedBB bb, double size) {
        return WorldRadiusUtil.getEntitiesInAABBexcluding(world, entityIn, bb, (Predicate<? super Entity>)EntitySelectors.field_180132_d, size);
    }

    public static List<Entity> getEntitiesInAABBexcluding(World world, @Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate, double size) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        int x0 = MathHelper.func_76128_c((double)(boundingBox.field_72340_a - size)) >> 4;
        int x1 = MathHelper.func_76128_c((double)(boundingBox.field_72336_d + size)) >> 4;
        int z0 = MathHelper.func_76128_c((double)(boundingBox.field_72339_c - size)) >> 4;
        int z1 = MathHelper.func_76128_c((double)(boundingBox.field_72334_f + size)) >> 4;
        for (int x = x0; x <= x1; ++x) {
            for (int z = z0; z <= z1; ++z) {
                Chunk chunk = world.func_72863_F().func_186026_b(x, z);
                if (chunk == null) continue;
                WorldRadiusUtil.getEntitiesWithinAABBForEntity(chunk, entityIn, boundingBox, list, predicate, size);
            }
        }
        return list;
    }

    public static <T extends Entity> List<T> getEntitiesWithinAABB(World world, Class<? extends T> classEntity, AxisAlignedBB bb, double size) {
        return WorldRadiusUtil.getEntitiesWithinAABB(world, classEntity, bb, EntitySelectors.field_180132_d, size);
    }

    public static <T extends Entity> List<T> getEntitiesWithinAABB(World world, Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter, double size) {
        ArrayList list = new ArrayList();
        int x0 = MathHelper.func_76128_c((double)(aabb.field_72340_a - size)) >> 4;
        int x1 = MathHelper.func_76128_c((double)(aabb.field_72336_d + size)) >> 4;
        int z0 = MathHelper.func_76128_c((double)(aabb.field_72339_c - size)) >> 4;
        int z1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + size)) >> 4;
        for (int x = x0; x <= x1; ++x) {
            for (int z = z0; z <= z1; ++z) {
                Chunk chunk = world.func_72863_F().func_186026_b(x, z);
                if (chunk == null) continue;
                WorldRadiusUtil.getEntitiesOfTypeWithinAABB(chunk, clazz, aabb, list, filter, size);
            }
        }
        return list;
    }

    public static <T extends Entity> T findNearestEntityWithinAABB(World world, Class<? extends T> entityType, AxisAlignedBB aabb, T closestTo, double size) {
        List<Entity> entities = WorldRadiusUtil.getEntitiesWithinAABB(world, entityType, aabb, size);
        Entity nearestEntity = null;
        double minDist = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double dist;
            if (entity == closestTo || !((dist = closestTo.func_70068_e(entity)) <= minDist)) continue;
            nearestEntity = entity;
            minDist = dist;
        }
        return (T)nearestEntity;
    }

    private static <T extends Entity> void getEntitiesOfTypeWithinAABB(Chunk chunk, Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, Predicate<? super T> filter, double size) {
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        if (aabb.field_72337_e < 0.0 || aabb.field_72338_b >= (double)(entityLists.length << 4)) {
            return;
        }
        int y0 = Math.max(MathHelper.func_76128_c((double)(aabb.field_72338_b - size)) >> 4, 0);
        int y1 = Math.min(MathHelper.func_76128_c((double)(aabb.field_72337_e + size)) >> 4, entityLists.length - 1);
        for (int y = y0; y <= y1; ++y) {
            for (Entity entity : entityLists[y].func_180215_b(entityClass)) {
                if (!entity.func_174813_aQ().func_72326_a(aabb) || filter != null && !filter.apply((Object)entity)) continue;
                listToFill.add(entity);
            }
        }
    }

    private static void getEntitiesWithinAABBForEntity(Chunk chunk, @Nullable Entity entityIn, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> filter, double size) {
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        if (aabb.field_72337_e < 0.0 || aabb.field_72338_b >= (double)(entityLists.length << 4)) {
            return;
        }
        int y0 = Math.max(MathHelper.func_76128_c((double)(aabb.field_72338_b - size)) >> 4, 0);
        int y1 = Math.min(MathHelper.func_76128_c((double)(aabb.field_72337_e + size)) >> 4, entityLists.length - 1);
        for (int y = y0; y <= y1; ++y) {
            ClassInheritanceMultiMap entityList = entityLists[y];
            if (entityList.isEmpty()) continue;
            for (Entity entity : entityList) {
                Entity[] partEntities;
                if (!entity.func_174813_aQ().func_72326_a(aabb) || entity == entityIn) continue;
                if (filter == null || filter.apply((Object)entity)) {
                    listToFill.add(entity);
                }
                if ((partEntities = entity.func_70021_al()) == null) continue;
                for (Entity partEntity : partEntities) {
                    if (!partEntity.func_174813_aQ().func_72326_a(aabb) || partEntity == entityIn || filter != null && !filter.apply((Object)partEntity)) continue;
                    listToFill.add(partEntity);
                }
            }
        }
    }
}

