/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Watchdog {
    public static Logger logger = LogManager.getLogger((String)"RLTweakerWatchdog");
    protected static ScheduledExecutorService executorService;
    protected static Map<String, Routine> routines;

    public static void init() {
        if (executorService == null) {
            executorService = Executors.newScheduledThreadPool(1);
            executorService.scheduleAtFixedRate(new RoutineManager(), 5L, 1L, TimeUnit.SECONDS);
        }
    }

    public static Routine addRoutine(String name, Routine routine) {
        logger.info("Adding Watchdog Routine: " + name);
        return routines.put(name, routine);
    }

    public static Routine removeRoutine(String name) {
        return routines.remove(name);
    }

    static {
        routines = new ConcurrentHashMap<String, Routine>();
    }

    public static abstract class Routine {
        public abstract void run() throws Exception;
    }

    static class RoutineManager
    implements Runnable {
        private Set<String> failedSet = new HashSet<String>();

        RoutineManager() {
        }

        @Override
        public void run() {
            for (Map.Entry<String, Routine> entry : routines.entrySet()) {
                try {
                    entry.getValue().run();
                }
                catch (Exception e) {
                    this.failedSet.add(entry.getKey());
                    logger.error("Failed to run watchdog routine: " + entry.getKey(), (Throwable)e);
                }
            }
            if (!this.failedSet.isEmpty()) {
                for (String removal : this.failedSet) {
                    Watchdog.removeRoutine(removal);
                    logger.warn("Routine was removed: " + removal);
                }
                this.failedSet.clear();
            }
        }
    }
}

