/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtil {
    private static final ReflectionField<Map<String, NBTBase>> NBTTagCompound_tagMap = new ReflectionField(NBTTagCompound.class, "field_74784_a", "tagMap");

    public static boolean remove(NBTTagCompound compound, String key) {
        return NBTTagCompound_tagMap.get(compound).remove(key) != null;
    }

    public static boolean clear(NBTTagCompound compound) {
        if (compound.func_82582_d()) {
            return false;
        }
        NBTTagCompound_tagMap.get(compound).clear();
        return true;
    }

    public static <T extends NBTBase> Stream<T> stream(NBTTagCompound compound) {
        return compound.func_150296_c().stream().map(arg_0 -> ((NBTTagCompound)compound).func_74781_a(arg_0)).map(tag -> tag);
    }

    public static <T extends NBTBase> boolean removeIf(NBTTagCompound compound, Predicate<T> predicate) {
        Map<String, NBTBase> tagMap = NBTTagCompound_tagMap.get(compound);
        if (tagMap instanceof HashMap) {
            return tagMap.values().removeIf(predicate);
        }
        ArrayList toRemove = new ArrayList();
        tagMap.forEach((k, v) -> {
            if (predicate.test(v)) {
                toRemove.add(k);
            }
        });
        toRemove.forEach(tagMap::remove);
        return !toRemove.isEmpty();
    }

    public static <T extends NBTBase> boolean removeIf(NBTTagCompound compound, String key, Predicate<T> predicate) {
        NBTBase tag = compound.func_74781_a(key);
        if (tag != null && predicate.test(tag)) {
            compound.func_82580_o(key);
            return true;
        }
        return false;
    }

    public static boolean clear(NBTTagList list) {
        if (list.func_82582_d()) {
            return false;
        }
        for (int i = list.func_74745_c() - 1; i >= 0; --i) {
            list.func_74744_a(i);
        }
        return true;
    }

    public static <T extends NBTBase> Stream<T> stream(NBTTagList list) {
        return IntStream.range(0, list.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)list).func_179238_g(arg_0)).map(tag -> tag);
    }

    public static <T extends NBTBase> boolean removeIf(NBTTagList list, Predicate<T> predicate) {
        boolean anythingRemoved = false;
        for (int i = list.func_74745_c() - 1; i >= 0; --i) {
            if (!predicate.test(list.func_179238_g(i))) continue;
            list.func_74744_a(i);
            anythingRemoved = true;
        }
        return anythingRemoved;
    }
}

