/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook.minecraft.structurecleanup;

import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.hook.minecraft.structurecleanup.LazyLong2ObjectOpenHashMap;
import com.charles445.rltweaker.hook.minecraft.structurecleanup.SavedChunkProvider;
import com.charles445.rltweaker.util.NBTUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import meldexun.memoryutil.MemoryAccess;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenStructureData;

public enum StructureCleanupMode {
    ALWAYS{

        @Override
        public boolean clean(WorldServer world, MapGenStructureData structureData) {
            return NBTUtil.clear(structureData.func_143041_a());
        }
    }
    ,
    ALWAYS_COMPONENTS_ONLY{

        @Override
        public boolean clean(WorldServer world, MapGenStructureData structureData) {
            return NBTUtil.stream(structureData.func_143041_a()).filter(structureStartTag -> NBTUtil.remove(structureStartTag, StructureCleanupMode.KEY_CHILDREN)).count() > 0L;
        }
    }
    ,
    GENERATED{

        @Override
        public boolean clean(WorldServer world, MapGenStructureData structureData) {
            return NBTUtil.removeIf(structureData.func_143041_a(), structureStartTag -> StructureCleanupMode.allChunksGenerated(world, structureStartTag.func_74759_k(StructureCleanupMode.KEY_BB)));
        }
    }
    ,
    GENERATED_COMPONENTS{

        @Override
        public boolean clean(WorldServer world, MapGenStructureData structureData) {
            return GENERATED_COMPONENTS_ONLY.clean(world, structureData) | NBTUtil.removeIf(structureData.func_143041_a(), structureStartTag -> !structureStartTag.func_150297_b(StructureCleanupMode.KEY_CHILDREN, 9));
        }
    }
    ,
    GENERATED_COMPONENTS_ONLY{

        @Override
        public boolean clean(WorldServer world, MapGenStructureData structureData) {
            return NBTUtil.stream(structureData.func_143041_a()).filter(structureStartTag -> NBTUtil.removeIf(structureStartTag.func_150295_c(StructureCleanupMode.KEY_CHILDREN, 10), child -> StructureCleanupMode.allChunksGenerated(world, child.func_74759_k(StructureCleanupMode.KEY_BB))) | NBTUtil.removeIf(structureStartTag, StructureCleanupMode.KEY_CHILDREN, NBTTagList::func_82582_d)).count() > 0L;
        }
    }
    ,
    DISABLED{

        @Override
        public boolean clean(WorldServer world, MapGenStructureData structureData) {
            return false;
        }
    };

    private static final String KEY_CHILDREN = "Children";
    private static final String KEY_BB = "BB";
    private static final LazyLong2ObjectOpenHashMap<SavedChunkProvider> SAVED_CHUNK_PROVIDER_CACHE;

    public abstract boolean clean(WorldServer var1, MapGenStructureData var2);

    private static boolean allChunksGenerated(WorldServer world, int[] bb) {
        int minX = bb[0];
        int minZ = bb[2];
        int maxX = bb[3];
        int maxZ = bb[5];
        if (minX > maxX || minZ > maxZ) {
            return true;
        }
        if ((long)maxX - (long)minX > (long)ModConfig.server.minecraft.cleanupStructureWorldgenFilesSizeLimit || (long)maxZ - (long)minZ > (long)ModConfig.server.minecraft.cleanupStructureWorldgenFilesSizeLimit) {
            return true;
        }
        for (int x = minX >> 4; x <= maxX >> 4; ++x) {
            for (int z = minZ >> 4; z <= maxZ >> 4; ++z) {
                if (StructureCleanupMode.isChunkGeneratedAt(world.func_72863_F(), x, z)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isChunkGeneratedAt(ChunkProviderServer chunkProvider, int x, int z) {
        if (chunkProvider.field_73244_f.containsKey(ChunkPos.func_77272_a((int)x, (int)z))) {
            return true;
        }
        if (((AnvilChunkLoader)chunkProvider.field_73247_e).field_75828_a.containsKey(new ChunkPos(x, z))) {
            return true;
        }
        return SAVED_CHUNK_PROVIDER_CACHE.computeIfAbsent((long)(x >> 5) & 0xFFFFFFFFL | ((long)(z >> 5) & 0xFFFFFFFFL) << 32, k -> {
            File file = new File(((AnvilChunkLoader)chunkProvider.field_73247_e).field_75825_d, "region/r." + (int)k + "." + (int)(k >> 32) + ".mca");
            Class<RegionFileCache> clazz = RegionFileCache.class;
            synchronized (RegionFileCache.class) {
                RegionFile regionFile = (RegionFile)RegionFileCache.field_76553_a.get(file);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                if (regionFile != null) {
                    return (arg_0, arg_1) -> ((RegionFile)regionFile).func_76709_c(arg_0, arg_1);
                }
                if (!file.exists()) {
                    return (x3, z3) -> false;
                }
                byte[] offsets = new byte[4096];
                try (FileInputStream in = new FileInputStream(file);){
                    int now;
                    for (int total = 0; total < offsets.length; total += now) {
                        now = ((InputStream)in).read(offsets, total, offsets.length - total);
                        if (now >= 0) continue;
                        throw new EOFException();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                MemoryAccess offsetsAccess = MemoryAccess.of(offsets);
                return (x1, z1) -> offsetsAccess.getInt((x1 + z1 * 32) * 4) != 0;
            }
        }).isChunkSaved(x & 0x1F, z & 0x1F);
    }

    public static void clearCache() {
        SAVED_CHUNK_PROVIDER_CACHE.clear();
    }

    static {
        SAVED_CHUNK_PROVIDER_CACHE = new LazyLong2ObjectOpenHashMap();
    }
}

