/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.debug.DebugUtil;
import com.charles445.rltweaker.reflect.RecurrentReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.ReflectUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RecurrentHandler {
    private RecurrentReflect reflector;
    private boolean reflector_enabled;

    public RecurrentHandler() {
        block4: {
            this.reflector_enabled = true;
            try {
                Object handler;
                if (ModConfig.server.recurrentcomplex.manageRCForgeEventHandler && !ModConfig.server.recurrentcomplex.generatePartially && (handler = CompatUtil.findAndRemoveHandlerFromEventBus("ivorius.reccomplex.events.handlers.RCForgeEventHandler", "onPreChunkDecoration")) != null) {
                    RLTweaker.logger.info("Registering RCHandler to the event bus");
                    new RCHandler(handler);
                }
                if (ModConfig.server.recurrentcomplex.cleanStructureData) {
                    RLTweaker.logger.info("Registering RCCleanup to the event bus");
                    new RCCleanup();
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup RecurrentHandler!", (Throwable)e);
                ErrorUtil.logSilent("Recurrent Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    private boolean checkReflector() {
        if (this.reflector == null) {
            if (this.reflector_enabled) {
                try {
                    this.reflector = new RecurrentReflect();
                    return true;
                }
                catch (Exception e) {
                    this.reflector = null;
                    this.reflector_enabled = false;
                    RLTweaker.logger.error("Failed to setup RecurrentReflect!", (Throwable)e);
                    ErrorUtil.logSilent("RecurrentReflect Critical Setup Failure");
                    throw new RuntimeException(e);
                }
            }
            return false;
        }
        return true;
    }

    public class RCHandler {
        private Object handler;

        public RCHandler(Object handler) {
            this.handler = handler;
            if (!RecurrentHandler.this.checkReflector()) {
                return;
            }
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onPreChunkDecoration(PopulateChunkEvent.Pre event) {
            try {
                this.decorate((WorldServer)event.getWorld(), event.getRand(), new ChunkPos(event.getChunkX(), event.getChunkZ()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                RLTweaker.logger.error("RecurrentReflect invocation failure!", (Throwable)e);
                ErrorUtil.logSilent("RecurrentReflect Critical Invocation Failure");
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decorate(WorldServer world, Random random, ChunkPos chunkPos) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Object wsgData;
            boolean mapFeatures = world.func_72912_H().func_76089_r();
            Object object = wsgData = RecurrentHandler.this.reflector.getWorldStructureGenerationData((World)world);
            synchronized (object) {
                List structuresComplementList = RecurrentHandler.this.reflector.getStructuresComplementList(wsgData, chunkPos);
                RecurrentHandler.this.reflector.checkChunk(wsgData, chunkPos);
                RecurrentHandler.this.reflector.complementStructuresInChunk(chunkPos, world, structuresComplementList);
                if (mapFeatures || !RecurrentHandler.this.reflector.honorStructureGenerationOption()) {
                    boolean generate;
                    Biome biome = world.func_180494_b(chunkPos.func_180331_a(8, 0, 8));
                    BlockPos spawnPos = world.func_175694_M();
                    RecurrentHandler.this.reflector.planStaticStructuresInChunk(random, chunkPos, world, spawnPos, null);
                    boolean bl = generate = RecurrentHandler.this.reflector.isGenerationEnabled(biome) && RecurrentHandler.this.reflector.isGenerationEnabled(world.field_73011_w);
                    if (world.field_73011_w.getDimension() == 0) {
                        double[] chunkArr = new double[]{chunkPos.field_77276_a * 16 + 8, chunkPos.field_77275_b * 16 + 8};
                        double[] spawnArr = new double[]{spawnPos.func_177958_n(), spawnPos.func_177952_p()};
                        double spawnDistSq = RecurrentHandler.this.reflector.distanceSq(chunkArr, spawnArr);
                        float minDistSq = RecurrentHandler.this.reflector.minDistToSpawnForGeneration();
                        generate &= spawnDistSq >= (double)(minDistSq *= minDistSq);
                    }
                    if (generate) {
                        this.planStructuresInChunk(random, chunkPos, world, biome);
                    }
                }
            }
        }

        private void planStructuresInChunk(Random random, ChunkPos chunkPos, WorldServer world, Biome biome) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            float spawnDistance = RecurrentHandler.this.reflector.distance(new ChunkPos(world.func_175694_M()), chunkPos);
            Object structureRegistryInstance = RecurrentHandler.this.reflector.getStructureRegistryInstance();
            Object cachedSelectors = RecurrentHandler.this.reflector.getNaturalGenerationSelectors(structureRegistryInstance);
            Object selector = RecurrentHandler.this.reflector.getSelectorFromCachedSelectors(cachedSelectors, biome, world.field_73011_w);
            List<Pair<Object, Object>> generatedStructures = RecurrentHandler.this.reflector.getStructurePairsWithSelector(selector, random, world.func_180494_b(chunkPos.func_180331_a(0, 0, 0)), world.field_73011_w, Float.valueOf(spawnDistance));
            generatedStructures.stream().forEach(pair -> {
                try {
                    this.planStructureInChunk(chunkPos, world, pair.getLeft(), pair.getRight(), random.nextLong());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    RLTweaker.logger.error("planStructuresInChunk failed on stream!", (Throwable)e);
                    ErrorUtil.logSilent("RecurrentReflect Critical Stream Failure");
                    throw new RuntimeException(e);
                }
            });
        }

        private void planStructureInChunk(ChunkPos chunkPos, WorldServer world, Object structure, Object naturalGeneration, long seed) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
            String structureName = RecurrentHandler.this.reflector.getStructureName(structure);
            Object blockSurfacePos = RecurrentHandler.this.reflector.getRandomSurfacePos(chunkPos, seed);
            Object limitations = RecurrentHandler.this.reflector.getNaturalGenerationLimitations(naturalGeneration);
            if (limitations == null || RecurrentHandler.this.reflector.isSpawnLimitationResolved(limitations, (World)world, structureName)) {
                Enum maturityEnum = RecurrentHandler.this.reflector.generateMaturityFromString("SUGGEST");
                Object placer = RecurrentHandler.this.reflector.getNaturalGenerationPlacer(naturalGeneration);
                Object generator = RecurrentHandler.this.reflector.newStructureGenerator();
                generator = RecurrentHandler.this.reflector.setStructure(generator, structure);
                generator = RecurrentHandler.this.reflector.setWorld(generator, world);
                generator = RecurrentHandler.this.reflector.setGenerationInfo(generator, naturalGeneration);
                generator = RecurrentHandler.this.reflector.setSeed(generator, seed);
                generator = RecurrentHandler.this.reflector.setMaturity(generator, maturityEnum);
                generator = RecurrentHandler.this.reflector.setRandomPosition(generator, blockSurfacePos, placer);
                generator = RecurrentHandler.this.reflector.setFromCenter(generator, true);
                generator = RecurrentHandler.this.reflector.partially(generator, false, chunkPos);
                Object environment = RecurrentHandler.this.reflector.getEnvironment(generator);
                Biome enviroBiome = RecurrentHandler.this.reflector.environmentToBiome(environment);
                if (RecurrentHandler.this.reflector.getNaturalGenerationWeight(naturalGeneration, world.field_73011_w, enviroBiome) <= 0.0) {
                    RLTweaker.logger.trace("" + structure + " failed to spawn at " + blockSurfacePos + " (incompatible biome edge)");
                    return;
                }
                Object generationResult = RecurrentHandler.this.reflector.generate(generator);
                RLTweaker.logger.trace("Structure Generated: " + structure);
            }
        }
    }

    public class RCCleanup {
        private Map<Integer, Integer> dimensionSensitivity;

        public RCCleanup() {
            block3: {
                this.dimensionSensitivity = new ConcurrentHashMap<Integer, Integer>();
                if (!RecurrentHandler.this.checkReflector()) {
                    return;
                }
                Class<?> selfClazz = this.getClass();
                try {
                    CompatUtil.subscribeEventManually(WorldEvent.Load.class, this, ReflectUtil.findMethod(selfClazz, "onWorldLoad"));
                    CompatUtil.subscribeEventManually(((RecurrentHandler)RecurrentHandler.this).reflector.c_StructureGenerationEventLite$Post, this, ReflectUtil.findMethod(selfClazz, "onStructureGenerationLitePost"));
                }
                catch (Exception e) {
                    RLTweaker.logger.error("Failed to setup RCCleanup!", (Throwable)e);
                    ErrorUtil.logSilent("RCCleanup Critical Failure");
                    if (!(e instanceof CriticalException)) break block3;
                    throw new RuntimeException(e);
                }
            }
        }

        private void resetSensitivity(int dimension) {
            this.dimensionSensitivity.put(dimension, ModConfig.server.recurrentcomplex.cleanStructureThreshold);
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onStructureGenerationLitePost(Object event) {
            WorldEvent worldEvent = (WorldEvent)event;
            World world = worldEvent.getWorld();
            if (world.field_72995_K) {
                return;
            }
            int dimension = world.field_73011_w.getDimension();
            if (!this.dimensionSensitivity.containsKey(dimension)) {
                this.resetSensitivity(dimension);
            }
            int sensitivity = this.dimensionSensitivity.get(dimension);
            if (--sensitivity > 0) {
                this.dimensionSensitivity.put(dimension, sensitivity);
                return;
            }
            this.resetSensitivity(dimension);
            int amt = -1;
            try {
                amt = this.cleanAllStructures(world);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                RLTweaker.logger.error("onStructureGenerationLitePost critical failure in RCCLeaner!", (Throwable)e);
                ErrorUtil.logSilent("RCCleanup Critical Failure");
                throw new RuntimeException(e);
            }
            if (ModConfig.server.minecraft.debug) {
                DebugUtil.messageAll("Cleaned up structures: " + amt);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onWorldLoad(WorldEvent.Load event) {
            World world = event.getWorld();
            if (world.field_72995_K) {
                return;
            }
            try {
                this.wipeRecurrentData(world);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                RLTweaker.logger.error("onWorldLoad critical failure in RCCleaner!", (Throwable)e);
                ErrorUtil.logSilent("RCCleanup Critical Failure");
                throw new RuntimeException(e);
            }
            int dimension = world.field_73011_w.getDimension();
            this.dimensionSensitivity.put(dimension, ModConfig.server.recurrentcomplex.cleanStructureThreshold);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int cleanAllStructures(World world) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object wsgData;
            Object object = wsgData = RecurrentHandler.this.reflector.getWorldStructureGenerationData(world);
            synchronized (object) {
                Map entryMap = (Map)RecurrentHandler.this.reflector.getEntryMap(wsgData);
                Set entrySet = entryMap.keySet();
                HashSet entrySetClone = new HashSet();
                entrySetClone.addAll(entrySet);
                for (UUID uuid : entrySetClone) {
                    RecurrentHandler.this.reflector.removeEntry(wsgData, uuid);
                }
                return entrySetClone.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wipeRecurrentData(World world) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Object wsgData;
            Object object = wsgData = RecurrentHandler.this.reflector.getWorldStructureGenerationData(world);
            synchronized (object) {
                WorldSavedData data = (WorldSavedData)wsgData;
                NBTTagCompound compound = data.serializeNBT();
                compound.func_82580_o("entries");
                compound.func_82580_o("checkedChunks");
                compound.func_82580_o("checkedChunksFinal");
                data.func_76184_a(compound);
                world.getPerWorldStorage().func_75745_a(data.field_76190_i, data);
            }
        }
    }
}

