/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.PotionCoreClientReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PotionCoreHandlerClient {
    boolean isOverpoweredArmorBarLoaded;
    boolean isToughnessBarLoaded;
    PotionCoreClientReflect reflector;
    Minecraft mc;
    @Nullable
    public OverloadedCompatibilityHandler overloadedHandler;

    public PotionCoreHandlerClient() {
        block3: {
            this.isOverpoweredArmorBarLoaded = Loader.isModLoaded((String)"overpoweredarmorbar");
            this.isToughnessBarLoaded = Loader.isModLoaded((String)"toughnessbar");
            this.mc = Minecraft.func_71410_x();
            try {
                this.reflector = new PotionCoreClientReflect();
                CompatUtil.wrapSpecificHandler("PCRenderOverlaysPre", x$0 -> new PCRenderOverlaysPre((IEventListener)x$0), "com.tmtravlr.potioncore.PotionCoreEventHandlerClient", "renderOverlaysPre");
                CompatUtil.wrapSpecificHandler("PCRenderOverlaysPost", x$0 -> new PCRenderOverlaysPost((IEventListener)x$0), "com.tmtravlr.potioncore.PotionCoreEventHandlerClient", "renderOverlaysPost");
                if (this.isOverpoweredArmorBarLoaded) {
                    this.overloadedHandler = new OverloadedCompatibilityHandler();
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup PotionCoreHandlerClient!", (Throwable)e);
                ErrorUtil.logSilent("PotionCore Client Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class PCRenderOverlaysPost {
        private IEventListener handler;

        public PCRenderOverlaysPost(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void renderOverlaysPost(RenderGameOverlayEvent.Post event) {
            if (event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
                this.handler.invoke((Event)event);
                return;
            }
            if (ModConfig.client.potioncore.renderArmorIcons) {
                this.handler.invoke((Event)event);
                if (ModConfig.client.potioncore.magicShieldingHUDFix) {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class PCRenderOverlaysPre {
        private IEventListener handler;

        public PCRenderOverlaysPre(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void renderOverlaysPre(RenderGameOverlayEvent.Pre event) {
            if (event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
                this.handler.invoke((Event)event);
                return;
            }
            if (ModConfig.client.potioncore.renderArmorResistance) {
                this.handler.invoke((Event)event);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class OverloadedCompatibilityHandler {
        @Nullable
        public Field f_offset = null;

        public OverloadedCompatibilityHandler() {
            try {
                Class<?> c_ModConfig = Class.forName("locusway.overpoweredarmorbar.ModConfig");
                this.f_offset = ReflectUtil.findField(c_ModConfig, "offset");
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup OverloadedCompatibilityHandler ModConfig", (Throwable)e);
                ErrorUtil.logSilent("PotionCore Overloaded ModConfig");
            }
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        private boolean getOverloadedOffset() throws IllegalArgumentException, IllegalAccessException {
            if (this.f_offset != null) {
                return this.f_offset.getBoolean(null);
            }
            return false;
        }

        @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOW)
        public void renderOverlaysAny(RenderGameOverlayEvent event) {
            double magicShielding;
            if (event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
                return;
            }
            if (ModConfig.client.potioncore.overloadedArmorBarCompatibility && (magicShielding = PotionCoreHandlerClient.this.mc.field_71439_g.func_110148_a(PotionCoreHandlerClient.this.reflector.MAGIC_SHIELDING).func_111126_e()) > 0.0) {
                int width = Math.min(82, MathHelper.func_76128_c((double)(magicShielding * 4.0 + 2.0)));
                if (width == 82) {
                    width = 83;
                }
                if (width > 2) {
                    try {
                        ScaledResolution scale = event.getResolution();
                        int left = scale.func_78326_a() / 2 - 92;
                        int top = scale.func_78328_b() - 40;
                        boolean offset = this.getOverloadedOffset();
                        float health = (float)PotionCoreHandlerClient.this.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
                        if (!offset && health > 20.0f) {
                            health = 20.0f;
                        }
                        float absorption = MathHelper.func_76123_f((float)PotionCoreHandlerClient.this.mc.field_71439_g.func_110139_bj());
                        if (!offset && absorption > 20.0f) {
                            absorption = 20.0f;
                        }
                        int healthbars = (int)Math.ceil(health / 20.0f) + (int)Math.ceil(absorption / 20.0f);
                        int bump = Math.max(12 - healthbars, 3);
                        top = top - (healthbars - 1) * bump - 10;
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179094_E();
                        PotionCoreHandlerClient.this.mc.func_110434_K().func_110577_a(PotionCoreHandlerClient.this.reflector.ARMOR_MAGIC_SHIELD);
                        PotionCoreHandlerClient.this.reflector.drawEnchantmentGlint(left, top, -120.0, width, 11.0);
                        GlStateManager.func_179121_F();
                        GlStateManager.func_179084_k();
                        PotionCoreHandlerClient.this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        ErrorUtil.logSilent("PotionCore Overloaded Glint Invocation");
                    }
                }
            }
        }
    }
}

