/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.entity.ai;

import com.charles445.rltweaker.entity.ai.InvestigateAIConfig;
import com.charles445.rltweaker.handler.InvestigateAIHandler;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import meldexun.reflectionutil.ReflectionField;
import meldexun.reflectionutil.ReflectionMethod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class InvestigateAI
extends EntityAIBase {
    private static final Class<?> c_EntityDragonBase;
    private static final ReflectionMethod<Boolean> IS_FLYING;
    private static final ReflectionField<BlockPos> AIR_TARGET;
    private static final ReflectionMethod<Boolean> CAN_NAVIGATE;
    private static final ReflectionField<Path> CURRENT_PATH;
    private final EntityLiving entity;
    private final InvestigateAIConfig config;
    private BlockPos target;
    private InvestigateAIConfig.Entry configEntry;
    private int ticksAtLastPos;
    private Vec3d lastPosCheck;
    private int lastTimeWithPath;

    public InvestigateAI(EntityLiving entity, InvestigateAIConfig config) {
        this.entity = entity;
        this.config = config;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.target == null) {
            return false;
        }
        Path path = this.getPathToTarget();
        if (path == null) {
            return false;
        }
        this.entity.func_70661_as().func_75484_a(path, (double)this.configEntry.movementSpeed);
        return true;
    }

    public boolean func_75253_b() {
        if (this.entity.func_70638_az() != null) {
            return false;
        }
        if (this.entity instanceof EntityTameable && ((EntityTameable)this.entity).func_70909_n()) {
            return false;
        }
        if (this.entity.field_70173_aa - this.ticksAtLastPos >= 60) {
            if (this.entity.func_70092_e(this.lastPosCheck.field_72450_a, this.lastPosCheck.field_72448_b, this.lastPosCheck.field_72449_c) < 1.0) {
                return false;
            }
            this.ticksAtLastPos = this.entity.field_70173_aa;
            this.lastPosCheck = this.entity.func_174791_d();
        }
        if (CAN_NAVIGATE.invoke(this.entity.func_70661_as(), new Object[0]).booleanValue() && (this.entity.func_70661_as().func_75500_f() || this.entity.func_70681_au().nextInt(10) == 0)) {
            Path path = this.getPathToTarget();
            if (path == null) {
                return false;
            }
            this.entity.func_70661_as().func_75484_a(path, (double)this.configEntry.movementSpeed);
        }
        if (!this.entity.func_70661_as().func_75500_f()) {
            this.lastTimeWithPath = this.entity.field_70173_aa;
        }
        return this.entity.field_70173_aa - this.lastTimeWithPath < 20;
    }

    public void func_75249_e() {
        this.ticksAtLastPos = this.entity.field_70173_aa;
        this.lastPosCheck = this.entity.func_174791_d();
        this.lastTimeWithPath = this.entity.field_70173_aa;
    }

    public void func_75251_c() {
        this.target = null;
        this.entity.func_70661_as().func_75499_g();
    }

    public void setTarget(Entity targetEntity) {
        this.setTarget(targetEntity.func_174791_d());
    }

    public void setTarget(Vec3d target) {
        this.setTarget(target, null, Stream.of(this.entity).collect(Collectors.toSet()));
    }

    private void setTarget(Vec3d target, @Nullable Entity parent, Set<Entity> checked) {
        this.config.entries.stream().filter(entry -> {
            if (parent != null ? !entry.executeOnCalled : !entry.executeOnAttacked) {
                return false;
            }
            return this.entity.func_110143_aJ() / this.entity.func_110138_aP() <= entry.healthThreshold;
        }).findFirst().ifPresent(entry -> {
            boolean chanceTestFailed;
            boolean inCombat = this.entity.func_70638_az() != null;
            boolean bl = chanceTestFailed = this.entity.func_70681_au().nextFloat() >= entry.executionChance;
            if (!inCombat && !chanceTestFailed) {
                this.setTarget(this.calculateTarget(target, (InvestigateAIConfig.Entry)entry), (InvestigateAIConfig.Entry)entry);
            }
            this.callForHelp(target, parent, inCombat, chanceTestFailed, checked, (InvestigateAIConfig.Entry)entry);
        });
    }

    private void callForHelp(Vec3d target, @Nullable Entity parent, boolean parentInCombat, boolean parentChanceTestFailed, Set<Entity> checked, InvestigateAIConfig.Entry entry) {
        entry.callForHelpEntries.stream().filter(callForHelpEntry -> {
            if (!callForHelpEntry.ignoreParentInCombat && parentInCombat) {
                return false;
            }
            return callForHelpEntry.ignoreParentChanceTestFailed || !parentChanceTestFailed;
        }).forEach(callForHelpEntry -> {
            AxisAlignedBB aabb = new AxisAlignedBB(this.entity.field_70165_t - (double)callForHelpEntry.horizontalRange, this.entity.field_70163_u - (double)callForHelpEntry.verticalRange, this.entity.field_70161_v - (double)callForHelpEntry.horizontalRange, this.entity.field_70165_t + (double)callForHelpEntry.horizontalRange, this.entity.field_70163_u + (double)callForHelpEntry.verticalRange, this.entity.field_70161_v + (double)callForHelpEntry.horizontalRange);
            List entities = this.entity.field_70170_p.func_175647_a(EntityLiving.class, aabb, entity1 -> {
                if (!callForHelpEntry.entityNames.contains(EntityList.func_191301_a((Entity)entity1))) {
                    return false;
                }
                if (callForHelpEntry.requiresVision && !this.entity.func_70685_l((Entity)entity1)) {
                    return false;
                }
                return checked.add((Entity)entity1);
            });
            entities.stream().map(InvestigateAIHandler::getInvestigateAI).filter(Optional::isPresent).map(Optional::get).forEach(investigateAI -> investigateAI.setTarget(target, (Entity)this.entity, checked));
        });
    }

    private BlockPos calculateTarget(Vec3d target, InvestigateAIConfig.Entry entry) {
        Random rand = this.entity.func_70681_au();
        double dist = this.entity.func_70011_f(target.field_72450_a, target.field_72448_b, target.field_72449_c);
        double horizontalOffset = Math.min((double)entry.horizontalOffsetBase + dist * (double)entry.horizontalOffsetScale, (double)entry.horizontalOffsetMax);
        double verticalOffset = Math.min((double)entry.verticalOffsetBase + dist * (double)entry.verticalOffsetScale, (double)entry.verticalOffsetMax);
        double x = target.field_72450_a + (rand.nextDouble() - 0.5) * 2.0 * horizontalOffset;
        double y = target.field_72448_b + (rand.nextDouble() - 0.5) * 2.0 * verticalOffset;
        double z = target.field_72449_c + (rand.nextDouble() - 0.5) * 2.0 * horizontalOffset;
        return new BlockPos(x, y, z);
    }

    private void setTarget(BlockPos pos, InvestigateAIConfig.Entry entry) {
        if (c_EntityDragonBase != null && c_EntityDragonBase.isInstance(this.entity) && IS_FLYING.isPresent() && IS_FLYING.invoke(this.entity, new Object[0]).booleanValue() && AIR_TARGET.isPresent()) {
            AIR_TARGET.set(this.entity, pos);
        } else {
            this.target = pos;
        }
        this.configEntry = entry;
    }

    private Path getPathToTarget() {
        IAttributeInstance followRangeAttribute = this.entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
        double amount = (Math.sqrt(this.entity.func_174831_c(this.target)) + 8.0) / followRangeAttribute.func_111126_e();
        AttributeModifier mod = new AttributeModifier("RLTweaker Investigate AI Bonus", amount, 2).func_111168_a(false);
        Path currentPath = CURRENT_PATH.get(this.entity.func_70661_as());
        this.entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(mod);
        CURRENT_PATH.set(this.entity.func_70661_as(), null);
        Path path = this.entity.func_70661_as().func_179680_a(this.target);
        CURRENT_PATH.set(this.entity.func_70661_as(), currentPath);
        this.entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111124_b(mod);
        return path;
    }

    static {
        Class<?> c;
        try {
            c = Class.forName("com.github.alexthe666.iceandfire.entity.EntityDragonBase");
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        c_EntityDragonBase = c;
        IS_FLYING = new ReflectionMethod("com.github.alexthe666.iceandfire.entity.EntityDragonBase", "isFlying", "isFlying", new Class[0]);
        AIR_TARGET = new ReflectionField("com.github.alexthe666.iceandfire.entity.EntityDragonBase", "airTarget", "airTarget");
        CAN_NAVIGATE = new ReflectionMethod(PathNavigate.class, "func_75485_k", "canNavigate", new Class[0]);
        CURRENT_PATH = new ReflectionField(PathNavigate.class, "field_75514_c", "currentPath");
    }
}

