/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.config.json;

import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

class MinecraftTypeAdapters {
    static final TypeAdapter<ResourceLocation> RESOURCE_LOCATION = MinecraftTypeAdapters.mapTypeAdapter(TypeAdapters.STRING, ResourceLocation::toString, ResourceLocation::new);
    static final TypeAdapter<Block> BLOCK = MinecraftTypeAdapters.mapTypeAdapter(RESOURCE_LOCATION, IForgeRegistryEntry.Impl::getRegistryName, arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0));

    MinecraftTypeAdapters() {
    }

    private static <T, R> TypeAdapter<T> mapTypeAdapter(final TypeAdapter<R> mappedTypeAdapater, final Function<T, R> mapFunction, final Function<R, T> remapFunction) {
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                mappedTypeAdapater.write(out, mapFunction.apply(value));
            }

            public T read(JsonReader in) throws IOException {
                return remapFunction.apply(mappedTypeAdapater.read(in));
            }
        };
    }
}

