/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.config.json;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.json.BlockStateSerializer;
import com.charles445.rltweaker.config.json.HashMultimapAdapterFactory;
import com.charles445.rltweaker.config.json.MinecraftTypeAdapters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class JsonLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new HashMultimapAdapterFactory()).registerTypeAdapter(ResourceLocation.class, MinecraftTypeAdapters.RESOURCE_LOCATION).registerTypeAdapter(Block.class, MinecraftTypeAdapters.BLOCK).registerTypeAdapter(IBlockState.class, (Object)new BlockStateSerializer()).setPrettyPrinting().create();

    public static <T> T readJson(Path path, Type type, T defaultValue) throws JsonIOException, JsonSyntaxException, IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            JsonLoader.writeJsonToFile(path, type, defaultValue);
        }
        return JsonLoader.readJsonFromFile(path, type);
    }

    public static <T> T readJson(Path path, Class<? extends T> type, T defaultValue) throws JsonIOException, JsonSyntaxException, IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            JsonLoader.writeJsonToFile(path, type, defaultValue);
        }
        return JsonLoader.readJsonFromFile(path, type);
    }

    public static <T> T readJsonFromFile(Path path, Type type) throws JsonIOException, JsonSyntaxException, IOException {
        try (BufferedReader in = Files.newBufferedReader(path);){
            Object object = GSON.fromJson((Reader)in, type);
            return (T)object;
        }
    }

    public static <T> T readJsonFromFile(Path path, Class<T> type) throws JsonIOException, JsonSyntaxException, IOException {
        try (BufferedReader in = Files.newBufferedReader(path);){
            Object object = GSON.fromJson((Reader)in, type);
            return (T)object;
        }
    }

    public static void writeJsonToFile(Path path, Type type, Object src) throws JsonIOException, IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(src, type, (Appendable)out);
        }
    }

    public static <V> Map<ResourceLocation, V> readJsons(Path dir, Class<V> type) throws JsonIOException, JsonSyntaxException, IOException {
        HashMap<ResourceLocation, V> map = new HashMap<ResourceLocation, V>();
        if (!Files.exists(dir, new LinkOption[0])) {
            return map;
        }
        for (Path subDir : (Path[])Files.list(dir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toArray(Path[]::new)) {
            String modid = subDir.getFileName().toString();
            for (Path file : (Path[])Files.list(subDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).toArray(Path[]::new)) {
                V value;
                String fileName = file.getFileName().toString();
                ResourceLocation key = new ResourceLocation(modid, fileName.substring(0, fileName.lastIndexOf(46)));
                try {
                    value = JsonLoader.readJsonFromFile(file, type);
                }
                catch (JsonIOException e) {
                    throw new JsonIOException("Failed reading json from file " + RLTweaker.jsonDirectory.relativize(file), (Throwable)e);
                }
                catch (JsonSyntaxException e) {
                    throw new JsonSyntaxException("Failed reading json from file " + RLTweaker.jsonDirectory.relativize(file), (Throwable)e);
                }
                catch (IOException e) {
                    throw new IOException("Failed reading json from file " + RLTweaker.jsonDirectory.relativize(file), e);
                }
                map.put(key, value);
            }
        }
        return map;
    }
}

