/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.patch.contentcreator;

import com.charles445.rltweaker.asm.patch.Patch;
import com.charles445.rltweaker.asm.patch.PatchManager;
import com.charles445.rltweaker.asm.util.TransformUtil;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class RenderUtilMemoryLeakPatch
extends PatchManager {
    public RenderUtilMemoryLeakPatch() {
        this.add(new Patch(this, "surreal.contentcreator.util.RenderUtil", 2){

            @Override
            public void patch(ClassNode clazzNode) {
                for (MethodNode m : clazzNode.methods) {
                    if (m.name.equals("<clinit>")) continue;
                    for (AbstractInsnNode i = m.instructions.getFirst(); i != null; i = i.getNext()) {
                        if (!(i instanceof FieldInsnNode)) continue;
                        FieldInsnNode f = (FieldInsnNode)i;
                        if (!f.owner.equals(clazzNode.name)) continue;
                        if (f.name.equals("WORLD")) {
                            f.name = "MC";
                            f.desc = "Lnet/minecraft/client/Minecraft;";
                            m.instructions.insert((AbstractInsnNode)f, (AbstractInsnNode)TransformUtil.createObfFieldInsn(180, "net/minecraft/client/Minecraft", "field_71441_e", "Lnet/minecraft/client/multiplayer/WorldClient;"));
                            continue;
                        }
                        if (!f.name.equals("PLAYER")) continue;
                        f.name = "MC";
                        f.desc = "Lnet/minecraft/client/Minecraft;";
                        m.instructions.insert((AbstractInsnNode)f, (AbstractInsnNode)TransformUtil.createObfFieldInsn(180, "net/minecraft/client/Minecraft", "field_71439_g", "Lnet/minecraft/client/entity/EntityPlayerSP;"));
                    }
                }
            }
        });
    }
}

