/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.patch;

import com.charles445.rltweaker.asm.helper.ASMHelper;
import com.charles445.rltweaker.asm.patch.Patch;
import com.charles445.rltweaker.asm.patch.PatchManager;
import com.charles445.rltweaker.asm.util.TransformUtil;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchEnchant
extends PatchManager {
    private static final String owner_HookEnchant = "com/charles445/rltweaker/hook/HookEnchant";

    public PatchEnchant() {
        super("Enchant");
        this.add(new Patch(this, "net.minecraft.enchantment.EnchantmentHelper", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                MethodNode m_getEnchantmentDatas = this.findMethod(clazzNode, "func_185291_a", "getEnchantmentDatas");
                if (m_getEnchantmentDatas == null) {
                    throw new RuntimeException("Couldn't find func_185291_a or getEnchantmentDatas");
                }
                AbstractInsnNode aret = ASMHelper.findLastInstructionWithOpcode(m_getEnchantmentDatas, 176);
                if (aret == null) {
                    throw new RuntimeException("Couldn't find ARETURN in getEnchantmentDatas");
                }
                m_getEnchantmentDatas.instructions.insertBefore(aret, (AbstractInsnNode)new MethodInsnNode(184, PatchEnchant.owner_HookEnchant, "restrictEnchantmentDatas", "(Ljava/util/List;)Ljava/util/List;", false));
            }
        });
        this.add(new Patch(this, "net.minecraft.entity.passive.EntityVillager$ListEnchantedBookForEmeralds", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                MethodNode m_addMerchantRecipe = this.findMethod(clazzNode, "func_190888_a", "addMerchantRecipe");
                if (m_addMerchantRecipe == null) {
                    throw new RuntimeException("Couldn't find func_190888_a or addMerchantRecipe");
                }
                MethodInsnNode getRandomObjectNode = TransformUtil.findNextCallWithOpcodeAndName(this.first(m_addMerchantRecipe), 182, "func_186801_a", "getRandomObject");
                if (getRandomObjectNode == null) {
                    throw new RuntimeException("Couldn't find getRandomObject in addMerchantRecipe");
                }
                getRandomObjectNode.setOpcode(184);
                getRandomObjectNode.owner = PatchEnchant.owner_HookEnchant;
                getRandomObjectNode.name = "getRandomRestricted";
                getRandomObjectNode.desc = "(Ljava/lang/Object;Ljava/util/Random;)Lnet/minecraft/enchantment/Enchantment;";
            }
        });
        this.add(new Patch(this, "net.minecraft.world.storage.loot.functions.EnchantRandomly", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                MethodNode m_apply = this.findMethod(clazzNode, "func_186553_a", "apply");
                MethodInsnNode anchor = TransformUtil.findNextCallWithOpcodeAndName(this.first(m_apply), 182, "func_92089_a", "canApply");
                if (anchor == null) {
                    throw new RuntimeException("Couldn't find func_92089_a or canApply");
                }
                MethodInsnNode addNode = TransformUtil.findNextCallWithOpcodeAndName((AbstractInsnNode)anchor, 185, "add");
                if (addNode == null) {
                    throw new RuntimeException("Couldn't find add in apply");
                }
                if (!addNode.owner.equals("java/util/List")) {
                    throw new RuntimeException("Unexpected add found in apply: " + addNode.owner);
                }
                addNode.setOpcode(184);
                addNode.owner = PatchEnchant.owner_HookEnchant;
                addNode.name = "addEnchantmentRestricted";
                addNode.desc = "(Ljava/util/List;Lnet/minecraft/enchantment/Enchantment;)Z";
                addNode.itf = false;
            }
        });
    }
}

