/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.patch;

import com.charles445.rltweaker.asm.patch.Patch;
import com.charles445.rltweaker.asm.patch.PatchManager;
import com.charles445.rltweaker.asm.util.TransformUtil;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatchBroadcastSounds
extends PatchManager {
    public PatchBroadcastSounds() {
        super("Broadcast Sounds");
        this.add(new Patch(this, "net.minecraft.world.ServerWorldEventHandler", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                MethodNode m_broadcastSound = this.findMethod(clazzNode, "func_180440_a", "broadcastSound");
                if (m_broadcastSound == null) {
                    throw new RuntimeException("Couldn't find func_180440_a or broadcastSound");
                }
                MethodInsnNode anchor = TransformUtil.findNextCallWithOpcodeAndName(this.first(m_broadcastSound), 182, "func_148540_a", "sendPacketToAllPlayers");
                if (anchor == null) {
                    throw new RuntimeException("Couldn't find func_148540_a or sendPacketToAllPlayers call in broadcastSound");
                }
                MethodInsnNode call = anchor;
                call.setOpcode(184);
                call.owner = "com/charles445/rltweaker/hook/HookMinecraft";
                call.name = "playLimitedBroadcastSound";
                call.desc = "(Lnet/minecraft/server/management/PlayerList;Lnet/minecraft/network/play/server/SPacketEffect;Lnet/minecraft/util/math/BlockPos;)V";
                this.insertBefore(m_broadcastSound, (AbstractInsnNode)anchor, (AbstractInsnNode)new VarInsnNode(25, 2));
            }
        });
    }
}

