/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import rustic.common.Config;
import rustic.common.items.ModItems;

public class TileEntityApiary
extends TileEntity
implements ITickable {
    private ItemStackHandler beeItemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityApiary.this.func_70296_d();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_77973_b().equals((Object)ModItems.BEE)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private ItemStackHandler honeyCombItemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityApiary.this.func_70296_d();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_77973_b().equals((Object)ModItems.HONEYCOMB)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private int reproductionTime = 1200;
    private int reproductionTimer = 0;
    private int productionTime = 600;
    private int productionTimer = 0;
    private Random random = new Random();

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public String getName() {
        return "container.rustic.apiary";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            ItemStackHandler tempHandler = new ItemStackHandler(2);
            tempHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
            this.beeItemStackHandler.setStackInSlot(0, tempHandler.getStackInSlot(0));
            this.honeyCombItemStackHandler.setStackInSlot(0, tempHandler.getStackInSlot(1));
        }
        if (compound.func_74764_b("bees")) {
            this.beeItemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("bees"));
        }
        if (compound.func_74764_b("honeyComb")) {
            this.honeyCombItemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("honeyComb"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("bees", (NBTBase)this.beeItemStackHandler.serializeNBT());
        compound.func_74782_a("honeyComb", (NBTBase)this.honeyCombItemStackHandler.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.honeyCombItemStackHandler;
            }
            return (T)this.beeItemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        int i;
        this.func_145843_s();
        if (this.beeItemStackHandler != null && !world.field_72995_K) {
            for (i = 0; i < this.beeItemStackHandler.getSlots(); ++i) {
                if (this.beeItemStackHandler.getStackInSlot(i) == null) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.beeItemStackHandler.getStackInSlot(i));
            }
        }
        if (this.honeyCombItemStackHandler != null && !world.field_72995_K) {
            for (i = 0; i < this.honeyCombItemStackHandler.getSlots(); ++i) {
                if (this.honeyCombItemStackHandler.getStackInSlot(i) == null) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.honeyCombItemStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        int numBees = 0;
        if (this.beeItemStackHandler.getStackInSlot(0).func_77973_b().equals((Object)ModItems.BEE)) {
            numBees = this.beeItemStackHandler.getStackInSlot(0).func_190916_E();
        }
        int numHoneycomb = 0;
        if (this.honeyCombItemStackHandler.getStackInSlot(0).func_77973_b().equals((Object)ModItems.HONEYCOMB)) {
            numHoneycomb = this.honeyCombItemStackHandler.getStackInSlot(0).func_190916_E();
        }
        if (numBees > 0 && !this.func_145831_w().field_72995_K) {
            this.reproductionTime = (int)(Config.BEE_REPRODUCTION_MULTIPLIER * (1600.0f / ((float)numBees / 20.0f + 1.0f)));
            this.productionTime = (int)(Config.BEE_HONEYCOMB_MULTIPLIER * (800.0f / ((float)numBees / 20.0f + 1.0f)));
            ++this.reproductionTimer;
            ++this.productionTimer;
            if (this.reproductionTimer >= this.reproductionTime) {
                this.reproductionTimer = 0;
                if (numBees < 64) {
                    this.beeItemStackHandler.getStackInSlot(0).func_190917_f(1);
                }
            }
            if (this.productionTimer >= this.productionTime) {
                this.productionTimer = 0;
                if (numHoneycomb == 0) {
                    this.honeyCombItemStackHandler.setStackInSlot(0, new ItemStack((Item)ModItems.HONEYCOMB, 1));
                } else if (numHoneycomb < 64) {
                    this.honeyCombItemStackHandler.getStackInSlot(0).func_190917_f(1);
                }
            }
            if (Config.BEE_GROWTH_MULTIPLIER != 0.0f && this.random.nextInt((int)Math.ceil(2048.0f / ((float)numBees * Config.BEE_GROWTH_MULTIPLIER))) == 0) {
                int randX = this.random.nextInt(9) - 4;
                int randZ = this.random.nextInt(9) - 4;
                int x = this.func_174877_v().func_177958_n();
                int y = this.func_174877_v().func_177956_o();
                int z = this.func_174877_v().func_177952_p();
                for (int i = 0; i < 3; ++i) {
                    BlockPos pos = new BlockPos(x + randX, y + 1 - i, z + randZ);
                    Block block = this.func_145831_w().func_180495_p(pos).func_177230_c();
                    if (!(block instanceof IGrowable) && !(block instanceof IPlantable)) continue;
                    block.func_180650_b(this.field_145850_b, pos, this.field_145850_b.func_180495_p(pos), this.field_145850_b.field_73012_v);
                    this.field_145850_b.func_175654_a(pos, block, 0, 1);
                    break;
                }
            }
            this.func_70296_d();
        }
    }
}

