/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common;

import com.fantasticsource.setbonus.client.ClientBonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.common.bonusrequirements.ABonusRequirement;
import com.fantasticsource.setbonus.server.ServerBonus;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;

public abstract class Bonus {
    public static int MODE_DISCOVERABLE = 0;
    public static int MODE_GLOBALLY_KNOWN = 1;
    public static int MODE_GLOBALLY_HIDDEN = 2;
    public String parsedString;
    public String id;
    public String name;
    public int discoveryMode;
    public ArrayList<ABonusRequirement> bonusRequirements = new ArrayList();
    public ArrayList<ABonusElement> bonusElements = new ArrayList();

    protected Bonus() {
    }

    public static Bonus getInstance(String parsableBonus, Side side) {
        Bonus bonus = side == Side.SERVER ? new ServerBonus() : new ClientBonus();
        String[] tokens = parsableBonus.split(",");
        if (tokens.length < 3) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughBonusArgs", (Object[])new Object[]{parsableBonus}));
            return null;
        }
        bonus.id = tokens[0].trim();
        if (bonus.id.equals("")) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.noBonusID", (Object[])new Object[]{parsableBonus}));
            return null;
        }
        bonus.name = tokens[1].trim();
        try {
            bonus.discoveryMode = Integer.parseInt(tokens[2].trim());
        }
        catch (NumberFormatException e) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.bonusDiscoveryMode", (Object[])new Object[]{parsableBonus}));
            return null;
        }
        if (bonus.discoveryMode < 0 || bonus.discoveryMode > 2) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.bonusDiscoveryMode", (Object[])new Object[]{parsableBonus}));
            return null;
        }
        for (String requirementString : Arrays.copyOfRange(tokens, 3, tokens.length)) {
            ABonusRequirement requirement = ABonusRequirement.parse(requirementString, side);
            if (requirement == null) {
                System.err.println(I18n.func_74837_a((String)"setbonus.error.unknownBonusReq", (Object[])new Object[]{parsableBonus}));
                return null;
            }
            bonus.bonusRequirements.add(requirement);
        }
        bonus.parsedString = parsableBonus;
        return bonus;
    }
}

