/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.recipes;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.ingredients.output.OutputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.ItemUtils;

public class RecipeHandler {
    public final String name;
    protected final Logger logger;
    protected final Queue<Recipe> recipes = new ArrayDeque<Recipe>();
    protected final LoadingCache<Collection<InputIngredient<?>>, Recipe> cachedRecipes = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(100L).build(this::getRecipe);

    public RecipeHandler(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The recipe handler name cannot be blank");
        }
        this.name = name;
        this.logger = LogManager.getLogger((String)("team_reborn|Praescriptum|" + name));
    }

    public Recipe createRecipe() {
        return new Recipe(this);
    }

    public boolean addRecipe(Recipe recipe, boolean replace) {
        Objects.requireNonNull(recipe.getInputIngredients(), "The input is null");
        if (recipe.getInputIngredients().size() <= 0) {
            throw new IllegalArgumentException("No inputs");
        }
        if (recipe.getItemOutputs().length <= 0 && recipe.getFluidOutputs().length <= 0) {
            throw new IllegalArgumentException("No outputs");
        }
        ArrayDeque queueOfInputs = new ArrayDeque();
        for (InputIngredient<?> inputIngredient : recipe.getInputIngredients()) {
            if (inputIngredient.isEmpty()) {
                this.logger.warn(String.format("%s: The %s %s is invalid. Skipping...", this.name, inputIngredient.getClass().getSimpleName(), inputIngredient.toFormattedString()));
                return false;
            }
            queueOfInputs.add(inputIngredient);
        }
        for (ItemStack itemStack : recipe.getItemOutputs()) {
            if (!ItemUtils.isEmpty(itemStack)) continue;
            this.logger.warn(String.format("%s: The ItemStack %s is invalid. Skipping...", this.name, ItemUtils.toFormattedString(itemStack)));
            return false;
        }
        for (ItemStack itemStack : recipe.getFluidOutputs()) {
            if (itemStack.getFluid() != null && itemStack.amount > 0) continue;
            this.logger.warn(String.format("%s: The FluidStack %s is invalid. Skipping...", this.name, FluidUtils.toFormattedString((FluidStack)itemStack)));
            return false;
        }
        for (InputIngredient inputIngredient : queueOfInputs) {
            if (!(inputIngredient instanceof OreDictionaryInputIngredient) || !OreDictionary.getOres((String)((String)((OreDictionaryInputIngredient)inputIngredient).ingredient)).isEmpty()) continue;
            this.logger.warn(String.format("%s: Skipping a recipe with input %s due to the non existence of items that are registered to a provided ore type", this.name, inputIngredient.ingredient));
            return false;
        }
        Recipe temp = recipe.shouldUseNBT() ? this.getRecipeStrict(queueOfInputs) : this.getRecipe(queueOfInputs);
        if (temp != null) {
            if (replace) {
                do {
                    if (this.removeRecipe(queueOfInputs)) continue;
                    this.logger.error(String.format("%s: Something went wrong while removing the recipe with inputs %s", this.name, queueOfInputs));
                } while (this.getRecipe(queueOfInputs) != null);
            } else {
                this.logger.error(String.format("%s: Skipping recipe with input %s due to the existence of an equal input", this.name, queueOfInputs));
                return false;
            }
        }
        Recipe recipe2 = this.createRecipe().withInput(queueOfInputs).withOutput(recipe.getItemOutputs(), recipe.getFluidOutputs()).withMetadata(recipe.getMetadata());
        this.recipes.add(recipe2);
        return true;
    }

    public Recipe getRecipe(Collection<InputIngredient<?>> ingredients) {
        for (Recipe recipe : this.recipes) {
            if (ingredients.size() != recipe.getInputIngredients().size()) continue;
            ArrayDeque adjusted = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient<?> entry : ingredients) {
                adjusted.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!adjusted.isEmpty()) continue;
            return recipe;
        }
        return null;
    }

    public Recipe getRecipeStrict(Collection<InputIngredient<?>> ingredients) {
        for (Recipe recipe : this.recipes) {
            if (ingredients.size() != recipe.getInputIngredients().size()) continue;
            ArrayDeque adjusted = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient<?> entry : ingredients) {
                adjusted.removeIf(temp -> temp.matchesStrict(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!adjusted.isEmpty()) continue;
            return recipe;
        }
        return null;
    }

    public Recipe getRecipeByOutput(Collection<OutputIngredient<?>> ingredients) {
        for (Recipe recipe : this.recipes) {
            if (ingredients.size() != recipe.getItemOutputs().length) continue;
            LinkedList<ItemStack> adjusted = new LinkedList<ItemStack>(Arrays.asList(recipe.getItemOutputs()));
            for (OutputIngredient<?> entry : ingredients) {
                adjusted.removeIf(temp -> entry.matches(temp) && entry.getCount() >= temp.func_190916_E());
            }
            if (!adjusted.isEmpty()) continue;
            return recipe;
        }
        return null;
    }

    public Recipe findRecipe(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return null;
        }
        return this.cachedRecipes.get(Collections.singletonList(ItemStackInputIngredient.copyOf(itemStack)));
    }

    public Recipe findRecipe(Collection<ItemStack> itemStacks) {
        ArrayDeque<ItemStackInputIngredient> ingredients = new ArrayDeque<ItemStackInputIngredient>();
        for (ItemStack stack : itemStacks) {
            if (ItemUtils.isEmpty(stack)) continue;
            ingredients.add(ItemStackInputIngredient.copyOf(stack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return this.cachedRecipes.get(ingredients);
    }

    public Recipe findRecipe2(FluidStack fluidStack) {
        if (fluidStack.amount <= 0) {
            return null;
        }
        return this.cachedRecipes.get(Collections.singletonList(FluidStackInputIngredient.copyOf(fluidStack)));
    }

    public Recipe findRecipe2(Collection<FluidStack> fluidStacks) {
        ArrayDeque<FluidStackInputIngredient> ingredients = new ArrayDeque<FluidStackInputIngredient>();
        for (FluidStack stack : fluidStacks) {
            if (stack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.copyOf(stack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return this.cachedRecipes.get(ingredients);
    }

    public Recipe findRecipe3(Collection<ItemStack> itemStacks, Collection<FluidStack> fluidStacks) {
        ArrayDeque<InputIngredient> ingredients = new ArrayDeque<InputIngredient>();
        for (ItemStack itemStack : itemStacks) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            ingredients.add(ItemStackInputIngredient.copyOf(itemStack));
        }
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.copyOf(fluidStack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return this.cachedRecipes.get(ingredients);
    }

    public Recipe findAndApply(ItemStack itemStack, boolean simulate) {
        if (ItemUtils.isEmpty(itemStack)) {
            return null;
        }
        List<ItemStackInputIngredient> ingredients = Collections.singletonList(ItemStackInputIngredient.of(itemStack));
        Recipe recipe = this.cachedRecipes.get(ingredients);
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return recipe;
        }
        return null;
    }

    public Recipe findAndApply(Collection<ItemStack> itemStacks, boolean simulate) {
        ArrayDeque<ItemStackInputIngredient> ingredients = new ArrayDeque<ItemStackInputIngredient>();
        for (ItemStack stack : itemStacks) {
            if (ItemUtils.isEmpty(stack)) continue;
            ingredients.add(ItemStackInputIngredient.of(stack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        Recipe recipe = this.cachedRecipes.get(ingredients);
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return recipe;
        }
        return null;
    }

    public Recipe findAndApply2(FluidStack fluidStack, boolean simulate) {
        if (fluidStack.amount <= 0) {
            return null;
        }
        List<FluidStackInputIngredient> ingredients = Collections.singletonList(FluidStackInputIngredient.of(fluidStack));
        Recipe recipe = this.cachedRecipes.get(ingredients);
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return recipe;
        }
        return null;
    }

    public Recipe findAndApply2(Collection<FluidStack> fluidStacks, boolean simulate) {
        ArrayDeque<FluidStackInputIngredient> ingredients = new ArrayDeque<FluidStackInputIngredient>();
        for (FluidStack stack : fluidStacks) {
            if (stack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.of(stack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        Recipe recipe = this.cachedRecipes.get(ingredients);
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return recipe;
        }
        return null;
    }

    public Recipe findAndApply3(Collection<ItemStack> itemStacks, Collection<FluidStack> fluidStacks, boolean simulate) {
        ArrayDeque<InputIngredient> ingredients = new ArrayDeque<InputIngredient>();
        for (ItemStack itemStack : itemStacks) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            ingredients.add(ItemStackInputIngredient.of(itemStack));
        }
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.of(fluidStack));
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        Recipe recipe = this.cachedRecipes.get(ingredients);
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return null;
            }
            ArrayDeque arrayDeque = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient entry : ingredients) {
                arrayDeque.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!arrayDeque.isEmpty()) {
                return null;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient entry : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return recipe;
        }
        return null;
    }

    public boolean apply(Recipe recipe, ItemStack itemStack, boolean simulate) {
        if (ItemUtils.isEmpty(itemStack)) {
            return false;
        }
        List<ItemStackInputIngredient> ingredients = Collections.singletonList(ItemStackInputIngredient.of(itemStack));
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Recipe recipe, Collection<ItemStack> itemStacks, boolean simulate) {
        ArrayDeque<ItemStackInputIngredient> ingredients = new ArrayDeque<ItemStackInputIngredient>();
        for (ItemStack itemStack : itemStacks) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            ingredients.add(ItemStackInputIngredient.of(itemStack));
        }
        if (ingredients.isEmpty()) {
            return false;
        }
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque arrayDeque = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    arrayDeque.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply2(Recipe recipe, FluidStack fluidStack, boolean simulate) {
        if (fluidStack.amount <= 0) {
            return false;
        }
        List<FluidStackInputIngredient> ingredients = Collections.singletonList(FluidStackInputIngredient.of(fluidStack));
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque queueB = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    queueB.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply2(Recipe recipe, Collection<FluidStack> fluidStacks, boolean simulate) {
        ArrayDeque<FluidStackInputIngredient> ingredients = new ArrayDeque<FluidStackInputIngredient>();
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.of(fluidStack));
        }
        if (ingredients.isEmpty()) {
            return false;
        }
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient inputIngredient : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque arrayDeque = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient inputIngredient : ingredients) {
                    arrayDeque.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply3(Recipe recipe, Collection<ItemStack> itemStacks, Collection<FluidStack> fluidStacks, boolean simulate) {
        ArrayDeque<InputIngredient> ingredients = new ArrayDeque<InputIngredient>();
        for (ItemStack itemStack : itemStacks) {
            if (ItemUtils.isEmpty(itemStack)) continue;
            ingredients.add(ItemStackInputIngredient.of(itemStack));
        }
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack.amount > 0) continue;
            ingredients.add(FluidStackInputIngredient.of(fluidStack));
        }
        if (ingredients.isEmpty()) {
            return false;
        }
        if (recipe != null) {
            if (ingredients.size() != recipe.getInputIngredients().size()) {
                return false;
            }
            ArrayDeque queueA = new ArrayDeque(recipe.getInputIngredients());
            for (InputIngredient entry : ingredients) {
                queueA.removeIf(temp -> temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount());
            }
            if (!queueA.isEmpty()) {
                return false;
            }
            if (!simulate) {
                ArrayDeque arrayDeque = new ArrayDeque(recipe.getInputIngredients());
                for (InputIngredient entry : ingredients) {
                    arrayDeque.removeIf(temp -> {
                        if (temp.matches(entry.ingredient) && entry.getCount() >= temp.getCount()) {
                            entry.shrink(temp.getCount());
                            return true;
                        }
                        return false;
                    });
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeRecipe(Recipe recipe) {
        if (recipe == null) {
            return false;
        }
        this.cachedRecipes.invalidate(recipe);
        return this.recipes.remove(recipe);
    }

    public boolean removeRecipe(Collection<InputIngredient<?>> ingredients) {
        Recipe recipe = this.getRecipe(ingredients);
        if (recipe == null) {
            return false;
        }
        this.cachedRecipes.invalidate(ingredients);
        return this.recipes.remove(recipe);
    }

    public Collection<Recipe> getRecipes() {
        return this.recipes;
    }
}

