/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.mixin.rlartifacts;

import artifacts.common.entity.EntityMimic;
import eaglemixins.handlers.ForgeConfigHandler;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"artifacts.common.entity.EntityMimic$MimicEventHandler"})
public class MimicEventHandlerMixin {
    @Inject(method={"onRightClick"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void onRightClick(PlayerInteractEvent.RightClickBlock event, CallbackInfo ci) {
        if (event.getUseBlock() == Event.Result.DENY || event.getWorld().field_72995_K || event.getEntityPlayer() == null || ForgeConfigHandler.server.undergroundMimicChance <= 0.0) {
            return;
        }
        BlockPos pos = event.getPos();
        if (pos.func_177956_o() > 25) {
            return;
        }
        World world = event.getWorld();
        TileEntity tile = world.func_175625_s(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        EntityPlayer player = event.getEntityPlayer();
        if (tile instanceof TileEntityChest && block instanceof BlockChest && !player.func_175149_v()) {
            if (!Arrays.asList(ForgeConfigHandler.server.undergroundMimicDimensions).contains(event.getWorld().field_73011_w.getDimension())) {
                return;
            }
            if (world.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN)) {
                return;
            }
            if (((ILootContainer)tile).func_184276_b() != null) {
                ((TileEntityChest)tile).func_184281_d(player);
                if (world.field_73012_v.nextDouble() <= ForgeConfigHandler.server.undergroundMimicChance) {
                    event.setCanceled(true);
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    EntityMimic mimic = new EntityMimic(world);
                    mimic.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    mimic.func_110163_bv();
                    mimic.setAwakeWithTarget(player);
                    world.func_72838_d((Entity)mimic);
                }
            }
        }
        ci.cancel();
    }

    @Inject(method={"onBlockBreak"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void onBlockBreak(BlockEvent.BreakEvent event, CallbackInfo ci) {
        if (event.getWorld().field_72995_K || event.getPlayer() == null || ForgeConfigHandler.server.undergroundMimicChance <= 0.0) {
            return;
        }
        BlockPos pos = event.getPos();
        if (pos.func_177956_o() > 25) {
            return;
        }
        World world = event.getWorld();
        TileEntity tile = world.func_175625_s(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        EntityPlayer player = event.getPlayer();
        if (tile instanceof TileEntityChest && block instanceof BlockChest && !player.func_175149_v()) {
            if (!Arrays.asList(ForgeConfigHandler.server.undergroundMimicDimensions).contains(event.getWorld().field_73011_w.getDimension())) {
                return;
            }
            if (((ILootContainer)tile).func_184276_b() != null) {
                ((TileEntityChest)tile).func_184281_d(player);
                if (world.field_73012_v.nextDouble() <= ForgeConfigHandler.server.undergroundMimicChance) {
                    event.setCanceled(true);
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    EntityMimic mimic = new EntityMimic(world);
                    mimic.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    mimic.func_110163_bv();
                    mimic.setAwakeWithTarget(player);
                    world.func_72838_d((Entity)mimic);
                }
            }
        }
        ci.cancel();
    }
}

