/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.event.FirstAidLivingDamageEvent;
import ichttt.mods.firstaid.common.network.MessageUpdatePart;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class HealthValidationHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onFirstAidLivingDamageLow(FirstAidLivingDamageEvent event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        for (AbstractDamageablePart part : event.getAfterDamage()) {
            if (!Float.isNaN(part.currentHealth)) continue;
            part.currentHealth = 0.0f;
            part.heal(1.0f, null, false);
            if (!(event.getEntityPlayer() instanceof EntityPlayerMP)) continue;
            FirstAid.NETWORKING.sendTo((IMessage)new MessageUpdatePart(part), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingHurt(LivingHurtEvent event) {
        HealthValidationHandler.validateHealth((LivingEvent)event);
        if (Float.isNaN(event.getAmount())) {
            event.setAmount(1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDamage(LivingDamageEvent event) {
        HealthValidationHandler.validateHealth((LivingEvent)event);
        if (!Float.isFinite(event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingHeal(LivingHealEvent event) {
        HealthValidationHandler.validateHealth((LivingEvent)event);
        if (!Float.isFinite(event.getAmount())) {
            event.setCanceled(true);
        }
    }

    private static void validateHealth(LivingEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!Float.isFinite(entity.func_110143_aJ())) {
            entity.func_70606_j(1.0f);
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).func_71118_n();
            }
        }
        if (!Float.isFinite(entity.func_110139_bj())) {
            entity.func_110149_m(0.0f);
        }
    }
}

