/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.EagleMixins;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

@Config(modid="eaglemixins")
public class ForgeConfigHandler {
    @Config.Comment(value={"Server-Side Options"})
    @Config.Name(value="Server Options")
    public static final ServerConfig server = new ServerConfig();
    @Config.Comment(value={"Client-Side Options"})
    @Config.Name(value="Client Options")
    public static final ClientConfig client = new ClientConfig();
    private static List<Potion> sussyberianEffects = null;
    private static List<Potion> mentalberianEffects = null;
    private static Potion berianConstantEffect = null;

    public static List<Potion> getSussyberianEffects() {
        if (sussyberianEffects == null) {
            sussyberianEffects = new ArrayList<Potion>();
            for (String name : ForgeConfigHandler.server.sussyberianEffects) {
                if (name.trim().isEmpty()) continue;
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(name.trim()));
                if (potion == null) {
                    EagleMixins.LOGGER.log(Level.WARN, "Unable to find potion effect: " + name);
                    continue;
                }
                sussyberianEffects.add(potion);
            }
        }
        return sussyberianEffects;
    }

    public static List<Potion> getMentalberianEffects() {
        if (mentalberianEffects == null) {
            mentalberianEffects = new ArrayList<Potion>();
            for (String name : ForgeConfigHandler.server.mentalberianEffects) {
                if (name.trim().isEmpty()) continue;
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(name.trim()));
                if (potion == null) {
                    EagleMixins.LOGGER.log(Level.WARN, "Unable to find potion effect: " + name);
                    continue;
                }
                mentalberianEffects.add(potion);
            }
        }
        return mentalberianEffects;
    }

    public static Potion getBerianConstantEffect() {
        if (berianConstantEffect == null) {
            String name = ForgeConfigHandler.server.berianConstantEffect.trim();
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(name));
            if (potion == null) {
                EagleMixins.LOGGER.log(Level.WARN, "Unable to find potion effect: " + name);
                berianConstantEffect = MobEffects.field_76431_k;
            } else {
                berianConstantEffect = potion;
            }
        }
        return berianConstantEffect;
    }

    @Mod.EventBusSubscriber(modid="eaglemixins")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("eaglemixins")) {
                ConfigManager.sync((String)"eaglemixins", (Config.Type)Config.Type.INSTANCE);
                mentalberianEffects = null;
                sussyberianEffects = null;
                berianConstantEffect = null;
            }
        }
    }

    public static class ClientConfig {
        @Config.Comment(value={"Example client side config option"})
        @Config.Name(value="Example Client Option")
        public boolean exampleClientOption = true;
    }

    public static class ServerConfig {
        @Config.Comment(value={"Chance of a librarian being converted to a Sussyberian on generation"})
        @Config.Name(value="Sussyberian Chance")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double sussyberianChance = 0.05;
        @Config.Comment(value={"Chance of a librarian being converted to a Mentalberian on generation"})
        @Config.Name(value="Mentalberian Chance")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double mentalberianChance = 0.05;
        @Config.Comment(value={"Chance of an underground un-looted chest becoming a mimic"})
        @Config.Name(value="Underground Mimic Chance")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double undergroundMimicChance = 0.05;
        @Config.Comment(value={"List of dimension IDs in which underground chests will have a chance to become mimics"})
        @Config.Name(value="Underground Mimic Dimensions")
        @Config.RequiresMcRestart
        public Integer[] undergroundMimicDimensions = new Integer[]{0};
        @Config.Comment(value={"List of potion effects that sussyberians will give"})
        @Config.Name(value="Sussyberian Random Effect List")
        public String[] sussyberianEffects = new String[]{"potioncore:lightning", "potioncore:explode", "potioncore:explode", "potioncore:explode", "potioncore:explode", "potioncore:explode", "potioncore:explode", "potioncore:launch", "potioncore:launch", "potioncore:launch", "potioncore:launch", "potioncore:launch", "potioncore:launch"};
        @Config.Comment(value={"List of potion effects that mentalberians will randomly give"})
        @Config.Name(value="Mentalberian Random Effect List")
        public String[] mentalberianEffects = new String[]{"minecraft:nausea", "minecraft:mining_fatigue", "minecraft:blindness", "minecraft:unluck", "lycanitesmobs:paralysis", "lycanitesmobs:insomnia", "lycanitesmobs:fear", "lycanitesmobs:aphagia", "potioncore:klutz", "potioncore:spin", "potioncore:disorganization", "rustic:tipsy", "elenaidodge:sluggish", "srparasites:fear"};
        @Config.Comment(value={"Effect that clicking on berians will always give"})
        @Config.Name(value="Berian Constant Effect")
        public String berianConstantEffect = "mod_lavacow:soiled";
        @Config.Comment(value={"Prevents Observers from ticking a redstone pulse on world gen"})
        @Config.Name(value="Patch Observer Ticking")
        public boolean patchObserversTickingOnWorldGen = false;
    }
}

