/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.handlers.ForgeConfigHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class BerianHandler {
    private static final ResourceLocation LIBRARIAN = new ResourceLocation("minecraft:librarian");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityVillager)) {
            return;
        }
        if (ForgeConfigHandler.server.sussyberianChance > 0.0 || ForgeConfigHandler.server.mentalberianChance > 0.0) {
            BerianHandler.updateBerian((EntityVillager)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingSpawn(LivingSpawnEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityVillager)) {
            return;
        }
        if (ForgeConfigHandler.server.sussyberianChance > 0.0 || ForgeConfigHandler.server.mentalberianChance > 0.0) {
            BerianHandler.updateBerian((EntityVillager)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getTarget() instanceof EntityVillager)) {
            return;
        }
        EntityVillager villager = (EntityVillager)event.getTarget();
        if (villager.getEntityData().func_74767_n("Sussyberian")) {
            Potion potion;
            List<Potion> potions = ForgeConfigHandler.getSussyberianEffects();
            if (!potions.isEmpty()) {
                potion = potions.get(event.getWorld().field_73012_v.nextInt(potions.size()));
                if (potion.func_76403_b()) {
                    potion.func_180793_a((Entity)event.getEntityPlayer(), (Entity)villager, null, 2, 1.0);
                } else {
                    event.getEntityPlayer().func_70690_d(new PotionEffect(potion, 200, 2));
                }
            }
            if ((potion = ForgeConfigHandler.getBerianConstantEffect()).func_76403_b()) {
                potion.func_180793_a((Entity)event.getEntityPlayer(), (Entity)villager, null, 1, 1.0);
            } else {
                event.getEntityPlayer().func_70690_d(new PotionEffect(potion, 200, 1));
            }
        } else if (villager.getEntityData().func_74767_n("Mentalberian")) {
            Potion potion;
            List<Potion> potions = ForgeConfigHandler.getMentalberianEffects();
            if (!potions.isEmpty()) {
                potion = potions.get(event.getWorld().field_73012_v.nextInt(potions.size()));
                if (potion.func_76403_b()) {
                    potion.func_180793_a((Entity)event.getEntityPlayer(), (Entity)villager, null, 1, 1.0);
                } else {
                    event.getEntityPlayer().func_70690_d(new PotionEffect(potion, 200, 1));
                }
            }
            if ((potion = ForgeConfigHandler.getBerianConstantEffect()).func_76403_b()) {
                potion.func_180793_a((Entity)event.getEntityPlayer(), (Entity)villager, null, 1, 1.0);
            } else {
                event.getEntityPlayer().func_70690_d(new PotionEffect(potion, 200, 1));
            }
        }
    }

    private static void updateBerian(EntityVillager villager) {
        VillagerRegistry.VillagerProfession profession = villager.getProfessionForge();
        if (LIBRARIAN.equals((Object)profession.getRegistryName()) && villager.getEntityData().func_74779_i("SussyBerianNaming").isEmpty()) {
            villager.getEntityData().func_74778_a("SussyBerianNaming", "true");
            if ((double)villager.func_70681_au().nextFloat() < ForgeConfigHandler.server.sussyberianChance) {
                villager.func_96094_a("Sussyberian");
                villager.getEntityData().func_74757_a("Sussyberian", true);
            } else if ((double)villager.func_70681_au().nextFloat() < ForgeConfigHandler.server.mentalberianChance) {
                villager.func_96094_a("Mentalberian");
                villager.getEntityData().func_74757_a("Mentalberian", true);
            }
        }
    }
}

