/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BarrierBlockHandler {
    private static final ResourceLocation BEDROCK = new ResourceLocation("dimstack:bedrock");
    private static final ResourceLocation PENDANT = new ResourceLocation("variedcommodities:pendant");
    private static final ResourceLocation ARTIFACT = new ResourceLocation("variedcommodities:artifact");

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (block.getRegistryName() == null || !block.getRegistryName().equals((Object)BEDROCK)) {
            return;
        }
        int meta = block.func_176201_c(state);
        if (meta == 6) {
            if (BarrierBlockHandler.isIndestructible(event.getPlayer(), PENDANT)) {
                event.setCanceled(true);
            }
        } else if (meta == 7 && BarrierBlockHandler.isIndestructible(event.getPlayer(), ARTIFACT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (block.getRegistryName() == null || !block.getRegistryName().equals((Object)BEDROCK)) {
            return;
        }
        int meta = block.func_176201_c(state);
        if (meta == 6) {
            if (BarrierBlockHandler.isIndestructible(event.getEntityPlayer(), PENDANT)) {
                event.setCanceled(true);
            }
        } else if (meta == 7 && BarrierBlockHandler.isIndestructible(event.getEntityPlayer(), ARTIFACT)) {
            event.setCanceled(true);
        }
    }

    private static boolean isIndestructible(EntityPlayer player, ResourceLocation requiredItem) {
        if (player == null) {
            return true;
        }
        if (BarrierBlockHandler.itemMatches(player.func_184614_ca(), requiredItem)) {
            return false;
        }
        return !BarrierBlockHandler.itemMatches(player.func_184592_cb(), requiredItem);
    }

    private static boolean itemMatches(ItemStack stack, ResourceLocation match) {
        return !stack.func_190926_b() && stack.func_77973_b().getRegistryName() != null && stack.func_77973_b().getRegistryName().equals((Object)match);
    }
}

