/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.ui;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.jan.moddirector.core.util.WebClient;
import net.jan.moddirector.core.util.WebGetResponse;

public class ImageLoader {
    private static final String FILE_PROTOCOL = "file://";
    private static final List<String> WEB_PROTOCOLS = Arrays.asList("https://", "http://");

    public static JLabel createLabelForImage(String path, int width, int height) {
        if (path.startsWith(FILE_PROTOCOL)) {
            return ImageLoader.readFromFile(path.substring(7), width, height);
        }
        for (String protocol : WEB_PROTOCOLS) {
            if (!path.startsWith(protocol)) continue;
            return ImageLoader.readFromWeb(path, width, height);
        }
        return ImageLoader.readFromFile(path, width, height);
    }

    private static JLabel readFromFile(String path, int width, int height) {
        File imageFile = new File(path);
        if (!imageFile.exists()) {
            return ImageLoader.errorLabel("File %s not found", path);
        }
        if (!imageFile.isFile()) {
            return ImageLoader.errorLabel("%s it not a file", path);
        }
        try {
            Image image = ImageLoader.getScaled(ImageIO.read(imageFile), width, height);
            return new JLabel(new ImageIcon(image));
        }
        catch (IOException e) {
            return ImageLoader.errorLabel("Failed to read file %s due to IOException: %s", path, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JLabel readFromWeb(String path, int width, int height) {
        try (WebGetResponse response = WebClient.get(new URL(path));){
            Image image = ImageLoader.getScaled(ImageIO.read(response.getInputStream()), width, height);
            JLabel jLabel = new JLabel(new ImageIcon(image));
            return jLabel;
        }
        catch (MalformedURLException e) {
            return ImageLoader.errorLabel("%s is not a valid url: %s", path, e.getMessage());
        }
        catch (IOException e) {
            return ImageLoader.errorLabel("Failed to read data from %s due to IOException: %s", path, e.getMessage());
        }
    }

    private static Image getScaled(BufferedImage image, int width, int height) {
        if (width <= 0 && height <= 0) {
            return image;
        }
        if (width <= 0) {
            width = image.getWidth();
        }
        if (height <= 0) {
            height = image.getHeight();
        }
        return image.getScaledInstance(width, height, 4);
    }

    private static JLabel errorLabel(String fmt, Object ... args) {
        JLabel label = new JLabel(String.format(fmt, args));
        label.setForeground(Color.RED);
        return label;
    }
}

