/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.jan.moddirector.core.ModDirector;
import net.jan.moddirector.core.configuration.ModDirectorRemoteMod;
import net.jan.moddirector.core.configuration.modpack.ModpackConfiguration;
import net.jan.moddirector.core.configuration.type.CurseRemoteMod;
import net.jan.moddirector.core.configuration.type.ModifyMod;
import net.jan.moddirector.core.configuration.type.RemoteConfig;
import net.jan.moddirector.core.configuration.type.UrlRemoteMod;
import net.jan.moddirector.core.logging.ModDirectorSeverityLevel;
import net.jan.moddirector.core.manage.ModDirectorError;
import net.jan.moddirector.core.util.IOOperation;
import net.jan.moddirector.core.util.WebClient;
import net.jan.moddirector.core.util.WebGetResponse;
import org.apache.commons.io.FileUtils;

public class ConfigurationController {
    public static final ObjectMapper OBJECT_MAPPER = ConfigurationController.createObjectMapper();
    private static final String LOG_DOMAIN = "ModDirector/ConfigurationController";
    private final ModDirector director;
    private final Path configurationDirectory;
    private final List<ModDirectorRemoteMod> configurations;
    private ModpackConfiguration modpackConfiguration;

    private static ObjectMapper createObjectMapper() {
        ObjectMapper instance = new ObjectMapper();
        instance.setDefaultLeniency(false);
        instance.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        return instance;
    }

    public ConfigurationController(ModDirector director, Path configurationDirectory) {
        this.director = director;
        this.configurationDirectory = configurationDirectory;
        this.configurations = new ArrayList<ModDirectorRemoteMod>();
    }

    public void load() {
        Path modpackConfigPath = this.configurationDirectory.resolve("modpack.json");
        if (Files.exists(modpackConfigPath, new LinkOption[0]) && !this.loadModpackConfiguration(modpackConfigPath)) {
            return;
        }
        try (Stream<Path> paths = Files.walk(this.configurationDirectory, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).filter(p -> !p.getFileName().toString().equals("modpack.json")).sorted().forEach(this::addConfig);
        }
        catch (IOException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, LOG_DOMAIN, "CORE", e, "Failed to iterate configuration directory!", new Object[0]);
            this.director.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "Failed to iterate configuration directory", e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadModpackConfiguration(Path configurationPath) {
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
            this.modpackConfiguration = OBJECT_MAPPER.readValue(stream, ModpackConfiguration.class);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, LOG_DOMAIN, "CORE", e, "Failed to read modpack configuration!", new Object[0]);
            this.director.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "Failed to read modpack configuration!"));
            return false;
        }
    }

    private void addConfig(Path configurationPath) {
        String configString = configurationPath.toString();
        this.director.getLogger().log(ModDirectorSeverityLevel.INFO, LOG_DOMAIN, "CORE", "Loading config %s", configString);
        if (configString.endsWith(".remote.json")) {
            this.handleRemoteConfig(configurationPath);
        } else if (configString.endsWith(".bundle.json")) {
            this.handleBundleConfig(configurationPath);
        } else if (configString.endsWith(".modify.json")) {
            this.handleModifyConfig(configurationPath);
        } else {
            this.handleSingleConfig(configurationPath);
        }
    }

    private void handleRemoteConfig(Path configurationPath) {
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
            RemoteConfig remoteConfig = OBJECT_MAPPER.readValue(stream, RemoteConfig.class);
            try (WebGetResponse response = WebClient.get(remoteConfig.getUrl());){
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOOperation.copy(response.getInputStream(), outputStream);
                String fileName = remoteConfig.getUrl().toString().substring(remoteConfig.getUrl().toString().lastIndexOf(47) + 1);
                Path installationRoot = this.director.getPlatform().installationRoot().toAbsolutePath().normalize();
                Path remoteConfigPath = installationRoot.resolve(this.configurationDirectory).resolve(fileName);
                Files.write(remoteConfigPath, outputStream.toByteArray(), new OpenOption[0]);
                this.addConfig(remoteConfigPath);
                Files.delete(remoteConfigPath);
            }
            catch (UnknownHostException e) {
                this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, LOG_DOMAIN, "CORE", e, "Failed to resolve URL %s, skipping remote config...", remoteConfig.getUrl());
            }
        }
        catch (IOException e) {
            this.handleConfigException(e);
        }
    }

    private void handleBundleConfig(Path configurationPath) {
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            JsonObject jsonObject = new JsonParser().parse(reader).getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("curse");
            if (jsonArray != null) {
                for (JsonElement jsonElement : jsonArray) {
                    this.configurations.add(OBJECT_MAPPER.readValue(jsonElement.toString(), CurseRemoteMod.class));
                }
            }
            if ((jsonArray = jsonObject.getAsJsonArray("url")) != null) {
                for (JsonElement jsonElement : jsonArray) {
                    this.configurations.add(OBJECT_MAPPER.readValue(jsonElement.toString(), UrlRemoteMod.class));
                }
            }
            if ((jsonArray = jsonObject.getAsJsonArray("modify")) != null) {
                for (JsonElement jsonElement : jsonArray) {
                    ModifyMod modifyMod = OBJECT_MAPPER.readValue(jsonElement.toString(), ModifyMod.class);
                    this.handleModifyConfig(modifyMod);
                }
            }
        }
        catch (IOException e) {
            this.handleConfigException(e);
        }
    }

    private void handleSingleConfig(Path configurationPath) {
        Class<? extends ModDirectorRemoteMod> targetType = this.getTypeForFile(configurationPath);
        if (targetType != null) {
            try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
                this.configurations.add(OBJECT_MAPPER.readValue(stream, targetType));
            }
            catch (IOException e) {
                this.handleConfigException(e);
            }
        }
    }

    private void handleModifyConfig(Path configurationPath) {
        try (InputStream stream = Files.newInputStream(configurationPath, new OpenOption[0]);){
            ModifyMod modifyMod = OBJECT_MAPPER.readValue(stream, ModifyMod.class);
            this.handleModifyConfig(modifyMod);
        }
        catch (IOException e) {
            this.handleConfigException(e);
        }
    }

    private void handleModifyConfig(ModifyMod modifyMod) {
        try {
            Path installationRoot = this.director.getPlatform().installationRoot().toAbsolutePath().normalize();
            Path modifyModFolderPath = installationRoot.resolve(modifyMod.getFolder());
            if (modifyMod.getFileName() == null) {
                if (Files.isDirectory(modifyModFolderPath, new LinkOption[0]) && modifyMod.shouldDelete()) {
                    this.director.getLogger().log(ModDirectorSeverityLevel.INFO, LOG_DOMAIN, "CORE", "Deleting folder %s", modifyModFolderPath);
                    FileUtils.deleteDirectory(modifyModFolderPath.toFile());
                }
            } else {
                Path modifyModFilePath = modifyModFolderPath.resolve(modifyMod.getFileName());
                if (Files.isRegularFile(modifyModFilePath, new LinkOption[0])) {
                    if (modifyMod.shouldDisable()) {
                        this.director.getLogger().log(ModDirectorSeverityLevel.INFO, LOG_DOMAIN, "CORE", "Disabling file %s", modifyModFilePath);
                        Files.move(modifyModFilePath, modifyModFilePath.resolveSibling(modifyMod.getFileName() + ".disabled-by-mod-director"), new CopyOption[0]);
                    } else if (modifyMod.shouldDelete()) {
                        this.director.getLogger().log(ModDirectorSeverityLevel.INFO, LOG_DOMAIN, "CORE", "Deleting file %s", modifyModFilePath);
                        Files.delete(modifyModFilePath);
                    } else {
                        Path modifyModNewFilePath = null;
                        if (modifyMod.getNewFolder() != null) {
                            this.director.getLogger().log(ModDirectorSeverityLevel.INFO, LOG_DOMAIN, "CORE", "Moving file %s", modifyModFilePath);
                            modifyModFolderPath = installationRoot.resolve(modifyMod.getNewFolder());
                            Files.createDirectories(modifyModFolderPath, new FileAttribute[0]);
                            modifyModNewFilePath = modifyModFolderPath.resolve(modifyMod.getFileName());
                        }
                        if (modifyMod.getNewFileName() != null) {
                            this.director.getLogger().log(ModDirectorSeverityLevel.INFO, LOG_DOMAIN, "CORE", "Renaming file %s", modifyModFilePath);
                            Path path = modifyModNewFilePath = modifyModNewFilePath != null ? modifyModNewFilePath.resolveSibling(modifyMod.getNewFileName()) : modifyModFilePath.resolveSibling(modifyMod.getNewFileName());
                        }
                        if (modifyModNewFilePath != null) {
                            if (Files.exists(modifyModNewFilePath, new LinkOption[0])) {
                                Path disabledFilePath = modifyModNewFilePath.resolveSibling(modifyModNewFilePath.getFileName() + ".disabled-by-mod-director");
                                if (Files.exists(disabledFilePath, new LinkOption[0])) {
                                    Files.delete(disabledFilePath);
                                }
                                Files.move(modifyModNewFilePath, disabledFilePath, new CopyOption[0]);
                            }
                            Files.move(modifyModFilePath, modifyModNewFilePath, new CopyOption[0]);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            this.handleConfigException(e);
        }
    }

    private void handleConfigException(IOException e) {
        this.director.getLogger().logThrowable(ModDirectorSeverityLevel.ERROR, LOG_DOMAIN, "CORE", e, "Failed to " + (e instanceof JsonParseException ? "parse" : "open") + " a configuration for reading!", new Object[0]);
        this.director.addError(new ModDirectorError(ModDirectorSeverityLevel.ERROR, "Failed to " + (e instanceof JsonParseException ? "parse" : "open") + " a configuration for reading", e));
    }

    private Class<? extends ModDirectorRemoteMod> getTypeForFile(Path file) {
        String name = file.toString();
        if (name.endsWith(".curse.json")) {
            return CurseRemoteMod.class;
        }
        if (name.endsWith(".url.json")) {
            return UrlRemoteMod.class;
        }
        this.director.getLogger().log(ModDirectorSeverityLevel.WARN, LOG_DOMAIN, "CORE", "Ignoring unknown json file %s", name);
        return null;
    }

    public ModpackConfiguration getModpackConfiguration() {
        return this.modpackConfiguration;
    }

    public List<ModDirectorRemoteMod> getConfigurations() {
        return this.configurations;
    }
}

