/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.playerbosses;

import com.lothrazar.playerbosses.AIFireballAttackGeneric;
import com.lothrazar.playerbosses.ConfigManager;
import com.lothrazar.playerbosses.RenderPlayerBoss;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EntityPlayerBoss
extends EntityGiantZombie
implements IRangedAttackMob {
    private static final DataParameter<Boolean> ATTACKINGFIRE = EntityDataManager.func_187226_a(EntityGiantZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    public static double armor;
    public static double health;
    public static double speed;
    public static double damage;
    public static boolean immuneFire;
    public static int expDropped;
    public static String bossName;
    public static String mainHand;
    public static String offHand;
    public static SoundEvent SOUND_HURT;
    public static SoundEvent SOUND_AMB;
    public static SoundEvent SOUND_DEATH;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private EnumAttackType attackType;
    private EntityAIAttackMelee melee;
    private AIFireballAttackGeneric fireball;
    private EntityAIAttackRangedBow bow;
    private EntityAIAvoidEntity runaway;

    public EntityPlayerBoss(World worldIn) {
        super(worldIn);
        this.field_70178_ae = immuneFire;
        this.field_70728_aV = expDropped;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKINGFIRE, (Object)false);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKINGFIRE, (Object)attacking);
    }

    protected boolean func_70692_ba() {
        return ConfigManager.canDespawn;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public String func_70005_c_() {
        return bossName;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public boolean func_184587_cr() {
        return this.attackType == EnumAttackType.RANGED;
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.getHealthPercent());
    }

    private float getHealthPercent() {
        return this.func_110143_aJ() / this.func_110138_aP();
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("playerbosses", "entity/player_boss");
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData res = super.func_180482_a(difficulty, livingdata);
        this.func_184641_n(false);
        return res;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(damage);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(armor);
    }

    public AIFireballAttackGeneric getAiFire() {
        if (this.fireball == null) {
            this.fireball = new AIFireballAttackGeneric(this);
        }
        return this.fireball;
    }

    public EntityAIAttackMelee getAiMelee() {
        if (this.melee == null) {
            this.melee = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
        }
        return this.melee;
    }

    public EntityAIAttackRangedBow getAiBow() {
        if (this.bow == null) {
            this.bow = new EntityAIAttackRangedBow((EntityMob)this, 1.0, 20, 15.0f);
        }
        return this.bow;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.attackType = EnumAttackType.RANGED;
        this.setCombatTask();
    }

    protected SoundEvent func_184639_G() {
        return SOUND_AMB;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SOUND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SOUND_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187939_hm;
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
        root.func_74768_a("attackType", this.attackType.ordinal());
    }

    public void func_70037_a(NBTTagCompound root) {
        super.func_70037_a(root);
        int at = root.func_74762_e("attackType");
        this.attackType = EnumAttackType.values()[at];
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.attackType = (double)this.getHealthPercent() < ConfigManager.thirdPhaseHealth && ConfigManager.thirdPhaseHealth > 0.0 ? EnumAttackType.FIRE : ((double)this.getHealthPercent() < ConfigManager.secondPhaseHealth && ConfigManager.secondPhaseHealth > 0.0 ? EnumAttackType.MELEE : EnumAttackType.RANGED);
        this.setCombatTask();
    }

    public void setCombatTask() {
        switch (this.attackType) {
            case RANGED: {
                this.setRangedWeapons();
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiBow());
                break;
            }
            case MELEE: {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.getAiBow());
                this.setMeleeWeapons();
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiMelee());
                break;
            }
            case FIRE: {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.getAiMelee());
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                if (ConfigManager.thirdPhaseRunaway && this.runaway == null) {
                    System.out.println("ADD RUNAWAY ");
                    this.runaway = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 4.0f, 0.6, 0.8);
                    this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.runaway);
                }
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiFire());
                break;
            }
        }
    }

    private void setRangedWeapons() {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151032_g));
    }

    private void setMeleeWeapons() {
        try {
            if (!mainHand.isEmpty()) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Item.func_111206_d((String)mainHand)));
            }
            if (!offHand.isEmpty()) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Item.func_111206_d((String)offHand)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float velocity = 1.6f;
        int inaccuracy = 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4;
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, velocity, (float)inaccuracy);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    private EntityArrow getArrow(float distanceFactor) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, distanceFactor);
        if (ConfigManager.arrowPotions) {
            entitytippedarrow.func_184558_a(new PotionEffect(MobEffects.field_76436_u, 60, 1));
            entitytippedarrow.func_184558_a(new PotionEffect(MobEffects.field_189112_A, 60, 1));
            entitytippedarrow.func_184558_a(new PotionEffect(MobEffects.field_76419_f, 60, 1));
        }
        return entitytippedarrow;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public int func_184612_cw() {
        if (this.field_70170_p.field_73012_v.nextDouble() < ConfigManager.arrowChance) {
            return 20;
        }
        return 0;
    }

    static {
        mainHand = "";
        offHand = "";
    }

    public static class Factory
    implements IRenderFactory<EntityPlayerBoss> {
        public Render<? super EntityPlayerBoss> createRenderFor(RenderManager manager) {
            return new RenderPlayerBoss(manager);
        }
    }

    private static enum EnumAttackType {
        MELEE,
        RANGED,
        FIRE;

    }
}

