/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.snow.ModConfig;
import snownee.snow.ModSnowBlock;

public class SnowGenerator
implements IWorldGenerator {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void blockVanilla(PopulateChunkEvent.Populate event) {
        if (!ModConfig.placeSnowInBlock || !ModConfig.replaceSnowWorldGen || event.getType() != PopulateChunkEvent.Populate.EventType.ICE) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }

    public static void trySnowAt(World world, BlockPos pos, boolean checkLight) {
        Biome biome = world.func_180494_b(pos);
        float f = biome.func_180626_a(pos);
        if (f >= 0.15f) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150431_aC) {
            return;
        }
        if (state.func_177230_c() != Blocks.field_150350_a && !ModSnowBlock.canContainState(state)) {
            return;
        }
        if (pos.func_177956_o() >= 0 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10) {
            ModSnowBlock.placeLayersOn(world, pos, 1, false, false, 2);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!ModConfig.placeSnowInBlock || !ModConfig.replaceSnowWorldGen) {
            return;
        }
        boolean pre = BlockFalling.field_149832_M;
        BlockFalling.field_149832_M = true;
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                IBlockState state;
                BlockPos blockpos1 = world.func_175725_q(new BlockPos(chunkX * 16 + 8 + k2, 0, chunkZ * 16 + 8 + j3));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (world.func_175675_v(blockpos2)) {
                    world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (ModSnowBlock.canContainState(state = world.func_180495_p(blockpos2))) {
                    blockpos1 = blockpos2;
                }
                SnowGenerator.trySnowAt(world, blockpos1, true);
            }
        }
        BlockFalling.field_149832_M = pre;
    }
}

