/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.client.gui;

import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.api.entity.passive.IArmoredWolf;
import dev.satyrn.wolfarmor.client.renderer.WolfRenderHelper;
import dev.satyrn.wolfarmor.common.inventory.ContainerWolfInventory;
import dev.satyrn.wolfarmor.common.network.packets.WolfDropChestMessage;
import dev.satyrn.wolfarmor.config.WolfArmorConfig;
import dev.satyrn.wolfarmor.util.WolfFoodStatsLevel;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;

@SideOnly(value=Side.CLIENT)
public class GuiWolfInventory
extends GuiContainer {
    private final IInventory wolfInventory;
    private final IInventory playerInventory;
    private final EntityWolf wolf;
    private final IArmoredWolf armoredWolf;
    private final WolfArmorConfig config = WolfArmorMod.getConfig();
    private float lastMouseX;
    private float lastMouseY;
    private static final int Y_SIZE_INITIAL = 169;
    private static final Rectangle EMPTY_SLOT = new Rectangle(176, 72, 18, 18);
    private static final Rectangle BUTTON_AREA = new Rectangle(7, 35, 18, 18);
    private static final Rectangle BUTTON_TEXTURE = new Rectangle(194, 72, 18, 18);
    private static final Rectangle EMPTY_CHEST_BG = new Rectangle(176, 0, 18, 18);
    private static final Rectangle STATS_BG_TEXTURE = new Rectangle(0, 169, 176, 10);
    private static final Rectangle UI_BOTTOM_TEXTURE = new Rectangle(0, 165, 176, 4);
    private static final Rectangle WOLF_RENDER_AREA = new Rectangle(31, 28, 54, 54);
    private static final Rectangle INVENTORY_TEXTURE = new Rectangle(0, 0, 176, 169);
    private static final ResourceLocation TEXTURE_GUI_WOLF_INVENTORY = new ResourceLocation("wolfarmor", "textures/gui/wolf.png");

    public GuiWolfInventory(@Nonnull IInventory playerInventory, @Nonnull IInventory wolfInventory, @Nonnull EntityWolf wolf, @Nonnull EntityPlayer player) {
        super((Container)new ContainerWolfInventory(playerInventory, wolfInventory, wolf, player));
        this.armoredWolf = (IArmoredWolf)wolf;
        this.wolfInventory = wolfInventory;
        this.playerInventory = playerInventory;
        this.wolf = wolf;
        this.field_146291_p = false;
        this.field_147000_g = 169;
        if (this.config.getStatsInGui()) {
            this.field_147000_g += 4;
            if (this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED) {
                this.field_147000_g += 10;
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isChestButtonHovered(mouseX, mouseY)) {
            WolfArmorMod.getNetworkChannel().sendToServer(new WolfDropChestMessage(this.wolf.func_145782_y()));
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String wolfName = this.wolf.func_70005_c_();
        this.field_146289_q.func_78276_b(this.wolfInventory.func_145818_k_() ? this.wolfInventory.func_70005_c_() : I18n.func_135052_a((String)this.wolfInventory.func_70005_c_(), (Object[])new Object[]{wolfName}), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145818_k_() ? this.playerInventory.func_70005_c_() : I18n.func_135052_a((String)this.playerInventory.func_70005_c_(), (Object[])new Object[0]), 8, 73, 0x404040);
        this.drawWolfHealthAndArmor();
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        if (this.armoredWolf.getHasChest() && this.isChestButtonHovered(mouseX, mouseY)) {
            ArrayList<String> displayText = new ArrayList<String>();
            displayText.add(I18n.func_135052_a((String)"gui.wolfarmor.inventory.remove_chest", (Object[])new Object[0]));
            this.drawHoveringText(displayText, mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Point origin = this.getOrigin();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_GUI_WOLF_INVENTORY);
        this.func_73729_b(origin.getX(), origin.getY(), INVENTORY_TEXTURE.getX(), INVENTORY_TEXTURE.getY(), INVENTORY_TEXTURE.getWidth(), INVENTORY_TEXTURE.getHeight());
        if (this.armoredWolf.getHasArmor()) {
            this.func_73729_b(origin.getX() + 7, origin.getY() + 17, EMPTY_SLOT.getX(), EMPTY_SLOT.getY(), EMPTY_SLOT.getWidth(), EMPTY_SLOT.getHeight());
        }
        int columns = WolfArmorMod.getConfig().getChestSize().getColumns();
        int rows = WolfArmorMod.getConfig().getChestSize().getRows();
        Point chestOrigin = new Point((5 - columns) * 9 + 79, (3 - rows) * 9 + 17);
        if (this.armoredWolf.getHasChest()) {
            for (int xOffset = 0; xOffset < columns; ++xOffset) {
                for (int yOffset = 0; yOffset < rows; ++yOffset) {
                    this.func_73729_b(origin.getX() + chestOrigin.getX() + EMPTY_SLOT.getWidth() * xOffset, origin.getY() + chestOrigin.getY() + EMPTY_SLOT.getHeight() * yOffset, EMPTY_SLOT.getX(), EMPTY_SLOT.getY(), EMPTY_SLOT.getWidth(), EMPTY_SLOT.getHeight());
                }
            }
        } else {
            for (int xSlot = 0; xSlot < columns; ++xSlot) {
                for (int ySlot = 0; ySlot < rows; ++ySlot) {
                    int textureXOffset = (columns > 1 ? 1 : 0) + (xSlot > 0 ? (xSlot == columns - 1 ? 2 : 1) : 0);
                    int textureYOffset = (rows > 1 ? 1 : 0) + (ySlot > 0 ? (ySlot == rows - 1 ? 2 : 1) : 0);
                    this.func_73729_b(origin.getX() + chestOrigin.getX() + EMPTY_CHEST_BG.getWidth() * xSlot, origin.getY() + chestOrigin.getY() + EMPTY_CHEST_BG.getHeight() * ySlot, textureXOffset * EMPTY_CHEST_BG.getWidth() + EMPTY_CHEST_BG.getX(), textureYOffset * EMPTY_CHEST_BG.getHeight() + EMPTY_CHEST_BG.getY(), EMPTY_CHEST_BG.getWidth(), EMPTY_CHEST_BG.getHeight());
                }
            }
        }
        if (this.config.getStatsInGui()) {
            int yOffset = this.getOrigin().getY() + 159;
            this.func_73729_b(origin.getX(), yOffset, STATS_BG_TEXTURE.getX(), STATS_BG_TEXTURE.getY(), STATS_BG_TEXTURE.getWidth(), STATS_BG_TEXTURE.getHeight());
            yOffset += STATS_BG_TEXTURE.getHeight();
            if (this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED && this.armoredWolf.getHasArmor()) {
                this.func_73729_b(origin.getX(), yOffset, STATS_BG_TEXTURE.getX(), STATS_BG_TEXTURE.getY(), STATS_BG_TEXTURE.getWidth(), STATS_BG_TEXTURE.getHeight());
                yOffset += STATS_BG_TEXTURE.getHeight();
            }
            this.func_73729_b(origin.getX(), yOffset, UI_BOTTOM_TEXTURE.getX(), UI_BOTTOM_TEXTURE.getY(), UI_BOTTOM_TEXTURE.getWidth(), UI_BOTTOM_TEXTURE.getHeight());
        }
        float entityPosX = this.field_147003_i + 52;
        float entityPosY = this.field_147009_r + 62;
        float entityMouseX = entityPosX - this.lastMouseX;
        float entityMouseY = entityPosY - 16.0f - this.lastMouseY;
        GuiInventory.func_147046_a((int)MathHelper.func_76140_b((double)entityPosX), (int)MathHelper.func_76140_b((double)entityPosY), (int)30, (float)entityMouseX, (float)entityMouseY, (EntityLivingBase)this.wolf);
        GlStateManager.func_179121_F();
        if (this.armoredWolf.getHasChest()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_GUI_WOLF_INVENTORY);
            this.func_73729_b(origin.getX() + BUTTON_AREA.getX(), origin.getY() + BUTTON_AREA.getY(), BUTTON_TEXTURE.getX() + (this.isChestButtonHovered(mouseX, mouseY) ? BUTTON_TEXTURE.getWidth() : 0), BUTTON_TEXTURE.getY(), BUTTON_TEXTURE.getWidth(), BUTTON_TEXTURE.getHeight());
            GlStateManager.func_179121_F();
        }
    }

    private void drawWolfHealthAndArmor() {
        Point renderPos;
        if (!this.config.getStatsInGui()) {
            return;
        }
        Point origin = this.getOrigin();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int yPosition = 160;
        if (this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED && this.armoredWolf.getHasArmor()) {
            renderPos = WolfRenderHelper.renderArmor(this.wolf, new Point(5, yPosition), false);
            yPosition = renderPos.getY();
        }
        renderPos = WolfRenderHelper.renderHealth(this.wolf, new Point(5, yPosition), false);
        if (this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED) {
            WolfRenderHelper.renderHunger(this.wolf, new Point(this.field_146999_f - 95, yPosition), true);
        } else if (this.armoredWolf.getHasArmor()) {
            WolfRenderHelper.renderArmor(this.wolf, new Point(this.field_146999_f - 95, yPosition), true);
        }
        GlStateManager.func_179121_F();
    }

    private Point getOrigin() {
        return new Point((this.field_146294_l - this.field_146999_f) / 2, (this.field_146295_m - this.field_147000_g) / 2);
    }

    private Point getLocalFromScreen(int x, int y) {
        Point origin = this.getOrigin();
        int mouseLocX = x - origin.getX();
        int mouseLocY = y - origin.getY();
        return new Point(mouseLocX, mouseLocY);
    }

    private boolean isChestButtonHovered(int mouseX, int mouseY) {
        Point mouseLoc = this.getLocalFromScreen(mouseX, mouseY);
        return mouseLoc.getX() >= BUTTON_AREA.getX() && mouseLoc.getY() >= BUTTON_AREA.getY() && mouseLoc.getX() < BUTTON_AREA.getX() + BUTTON_AREA.getWidth() && mouseLoc.getY() < BUTTON_AREA.getY() + BUTTON_AREA.getHeight();
    }
}

