/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.api.config.settings;

import dev.satyrn.wolfarmor.api.config.IConfigurationSetting;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.config.Property;

public abstract class Setting<T>
implements IConfigurationSetting<T> {
    private final T defaultValue;
    private T value;
    private T syncedValue;
    private boolean synchronizes;
    private boolean isSynchronized;
    private String category = "";
    private String name = "";
    private String comment = "";
    private Property.Type propertyType = Property.Type.STRING;
    private ReloadAction reloadAction = ReloadAction.NONE;
    private String configWidgetClassName = "";

    public Setting(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Setting<T> setName(@Nonnull String value) {
        this.name = value;
        return this;
    }

    @Override
    @Nonnull
    public String getCategory() {
        return this.category;
    }

    @Override
    @Nonnull
    public Setting<T> setCategory(@Nonnull String value) {
        this.category = value;
        return this;
    }

    @Override
    @Nonnull
    public String getComment() {
        return this.comment;
    }

    @Override
    @Nonnull
    public Setting<T> setComment(@Nonnull String value) {
        this.comment = value;
        return this;
    }

    @Nonnull
    protected Property.Type getPropertyType() {
        return this.propertyType;
    }

    protected void setPropertyType(@Nonnull Property.Type value) {
        this.propertyType = value;
    }

    @Nullable
    protected T getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public Setting<T> setValue(T value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean getSynchronizes() {
        return this.synchronizes;
    }

    @Override
    @Nonnull
    public Setting<T> setSynchronizes(boolean value) {
        this.synchronizes = value;
        return this;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T getSyncedValue() {
        return this.synchronizes ? (T)this.syncedValue : null;
    }

    public boolean getIsCurrentlySynchronized() {
        return this.synchronizes && this.isSynchronized;
    }

    @Override
    @Nonnull
    public String getFullName() {
        return String.format("%s.%s", this.category, this.name);
    }

    @Override
    @Nonnull
    public T getCurrentValue() {
        if (this.synchronizes && this.isSynchronized) {
            return this.syncedValue == null ? this.defaultValue : this.syncedValue;
        }
        return this.value == null ? this.defaultValue : this.value;
    }

    public void readSynchronized(NBTBase tag) {
        this.isSynchronized = true;
        this.syncedValue = this.readTag(tag);
    }

    public NBTBase writeSynchronized() {
        return this.writeTag(this.value);
    }

    public Setting<T> setReloadAction(ReloadAction reloadAction) {
        this.reloadAction = reloadAction;
        return this;
    }

    public ReloadAction getReloadAction() {
        return this.reloadAction;
    }

    public Setting<T> setRequiresWorldReload() {
        return this.setReloadAction(ReloadAction.WORLD);
    }

    public Setting<T> setRequiresMinecraftRestart() {
        return this.setReloadAction(ReloadAction.MINECRAFT);
    }

    public boolean getRequiresWorldReload() {
        return this.reloadAction == ReloadAction.WORLD;
    }

    public boolean getRequiresMinecraftRestart() {
        return this.reloadAction == ReloadAction.MINECRAFT;
    }

    public Setting<T> setConfigWidgetClassName(String configWidgetClassName) {
        this.configWidgetClassName = configWidgetClassName;
        return this;
    }

    public String getConfigWidgetClassName() {
        return this.configWidgetClassName;
    }

    public abstract T readTag(NBTBase var1);

    public abstract NBTBase writeTag(T var1);

    public void onDisconnect() {
        this.isSynchronized = false;
        this.syncedValue = null;
    }

    public static enum ReloadAction {
        NONE,
        WORLD,
        MINECRAFT;

    }
}

