/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.handler;

import bettercombat.mod.client.animation.util.AnimationEnum;
import bettercombat.mod.client.animation.util.BetterCombatHand;
import bettercombat.mod.client.animation.util.CustomWeapon;
import bettercombat.mod.util.ConfigurationHandler;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="bettercombatmod")
public class SoundHandler {
    private static final Random rand = new Random();
    public static final SoundEvent SWORD_SLASH = SoundHandler.registerSound("player.swordslash");
    public static final SoundEvent CRITICAL_STRIKE = SoundHandler.registerSound("player.criticalstrike");
    public static final SoundEvent SWING_2H = SoundHandler.registerSound("player.swing_2h");
    public static final SoundEvent SWING_2H_LEFT = SoundHandler.registerSound("player.swing_2h_left");
    public static final SoundEvent SWING_2H_RIGHT = SoundHandler.registerSound("player.swing_2h_right");
    public static final SoundEvent SWING_METAL_AXE = SoundHandler.registerSound("player.swing_metal_axe");
    public static final SoundEvent SWING_METAL_AXE_LEFT = SoundHandler.registerSound("player.swing_metal_axe_left");
    public static final SoundEvent SWING_METAL_AXE_RIGHT = SoundHandler.registerSound("player.swing_metal_axe_right");
    public static final SoundEvent SWING_METAL_BLADE = SoundHandler.registerSound("player.swing_metal_blade");
    public static final SoundEvent SWING_METAL_BLADE_LEFT = SoundHandler.registerSound("player.swing_metal_blade_left");
    public static final SoundEvent SWING_METAL_BLADE_RIGHT = SoundHandler.registerSound("player.swing_metal_blade_right");
    public static final SoundEvent SWING_METAL_BLUNT = SoundHandler.registerSound("player.swing_metal_blunt");
    public static final SoundEvent SWING_METAL_BLUNT_LEFT = SoundHandler.registerSound("player.swing_metal_blunt_left");
    public static final SoundEvent SWING_METAL_BLUNT_RIGHT = SoundHandler.registerSound("player.swing_metal_blunt_right");
    public static final SoundEvent SWING_SLOW = SoundHandler.registerSound("player.swing_slow");
    public static final SoundEvent SWING_SLOW_LEFT = SoundHandler.registerSound("player.swing_slow_left");
    public static final SoundEvent SWING_SLOW_RIGHT = SoundHandler.registerSound("player.swing_slow_right");
    public static final SoundEvent SWING_NORMAL = SoundHandler.registerSound("player.swing_normal");
    public static final SoundEvent SWING_NORMAL_LEFT = SoundHandler.registerSound("player.swing_normal_left");
    public static final SoundEvent SWING_NORMAL_RIGHT = SoundHandler.registerSound("player.swing_normal_right");
    public static final SoundEvent SWING_QUICK = SoundHandler.registerSound("player.swing_quick");
    public static final SoundEvent SWING_QUICK_LEFT = SoundHandler.registerSound("player.swing_quick_left");
    public static final SoundEvent SWING_QUICK_RIGHT = SoundHandler.registerSound("player.swing_quick_right");
    public static final SoundEvent EQUIP_BLADE = SoundHandler.registerSound("player.equip_blade");
    public static final SoundEvent EQUIP_BLADE_LEFT = SoundHandler.registerSound("player.equip_blade_left");
    public static final SoundEvent EQUIP_BLADE_RIGHT = SoundHandler.registerSound("player.equip_blade_right");
    public static final SoundEvent EQUIP_AXE = SoundHandler.registerSound("player.equip_axe");
    public static final SoundEvent EQUIP_AXE_LEFT = SoundHandler.registerSound("player.equip_axe_left");
    public static final SoundEvent EQUIP_AXE_RIGHT = SoundHandler.registerSound("player.equip_axe_right");
    public static final SoundEvent EQUIP_OTHER = SoundHandler.registerSound("player.equip_other");
    public static final SoundEvent EQUIP_OTHER_LEFT = SoundHandler.registerSound("player.equip_other_left");
    public static final SoundEvent EQUIP_OTHER_RIGHT = SoundHandler.registerSound("player.equip_other_right");
    public static final SoundEvent SHEATHE_BLADE = SoundHandler.registerSound("player.sheathe_blade");
    public static final SoundEvent SHEATHE_BLADE_LEFT = SoundHandler.registerSound("player.sheathe_blade_left");
    public static final SoundEvent SHEATHE_BLADE_RIGHT = SoundHandler.registerSound("player.sheathe_blade_right");
    public static final SoundEvent SHEATHE_AXE = SoundHandler.registerSound("player.sheathe_axe");
    public static final SoundEvent SHEATHE_AXE_LEFT = SoundHandler.registerSound("player.sheathe_axe_left");
    public static final SoundEvent SHEATHE_AXE_RIGHT = SoundHandler.registerSound("player.sheathe_axe_right");
    public static final SoundEvent SHEATHE_OTHER = SoundHandler.registerSound("player.sheathe_other");
    public static final SoundEvent SHEATHE_OTHER_LEFT = SoundHandler.registerSound("player.sheathe_other_left");
    public static final SoundEvent SHEATHE_OTHER_RIGHT = SoundHandler.registerSound("player.sheathe_other_right");

    private static SoundEvent registerSound(String name) {
        ResourceLocation soundID = new ResourceLocation("bettercombatmod", name);
        return (SoundEvent)new SoundEvent(soundID).setRegistryName(soundID);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)SWORD_SLASH);
        event.getRegistry().register((IForgeRegistryEntry)CRITICAL_STRIKE);
        event.getRegistry().register((IForgeRegistryEntry)SWING_2H);
        event.getRegistry().register((IForgeRegistryEntry)SWING_2H_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_2H_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_AXE);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_AXE_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_AXE_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_BLADE);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_BLADE_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_BLADE_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_BLUNT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_BLUNT_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_METAL_BLUNT_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_SLOW);
        event.getRegistry().register((IForgeRegistryEntry)SWING_SLOW_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_SLOW_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_NORMAL);
        event.getRegistry().register((IForgeRegistryEntry)SWING_NORMAL_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_NORMAL_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_QUICK);
        event.getRegistry().register((IForgeRegistryEntry)SWING_QUICK_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SWING_QUICK_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_BLADE);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_BLADE_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_BLADE_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_AXE);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_AXE_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_AXE_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_OTHER);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_OTHER_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)EQUIP_OTHER_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_BLADE);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_BLADE_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_BLADE_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_AXE);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_AXE_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_AXE_RIGHT);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_OTHER);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_OTHER_LEFT);
        event.getRegistry().register((IForgeRegistryEntry)SHEATHE_OTHER_RIGHT);
    }

    public static void playSwingSound(EntityPlayer player, BetterCombatHand betterCombatHand, ItemStack itemStack, int cooldown, boolean offhand) {
        if (!ConfigurationHandler.client.customWeaponSwingSounds) {
            return;
        }
        float volume = SoundHandler.getRandomSwingVolume();
        float pitch = SoundHandler.getSwingPitch(cooldown);
        if (!betterCombatHand.hasCustomWeapon()) {
            if (ConfigurationHandler.client.customPunchSwingSounds) {
                SoundHandler.playSwingPunch(player, volume, pitch, offhand);
            }
            return;
        }
        if (betterCombatHand.getAttackAnimationEnum() == AnimationEnum.STAB) {
            SoundHandler.playSwingNonMetal(player, volume, pitch, offhand);
            return;
        }
        if (betterCombatHand.getWeaponProperty() == CustomWeapon.WeaponProperty.TWOHAND) {
            SoundHandler.playSwing2H(player, volume, pitch, offhand);
            return;
        }
        if (SoundHandler.isMetallic(itemStack)) {
            switch (betterCombatHand.getSoundType()) {
                case BLADE: {
                    SoundHandler.playSwingMetalBlade(player, volume, pitch, offhand);
                    return;
                }
                case AXE: {
                    SoundHandler.playSwingMetalAxe(player, volume, pitch, offhand);
                    return;
                }
                case BLUNT: {
                    SoundHandler.playSwingMetalBlunt(player, volume, pitch, offhand);
                    return;
                }
            }
            SoundHandler.playSwingNonMetal(player, volume, pitch, offhand);
            return;
        }
        SoundHandler.playSwingNonMetal(player, volume, pitch, offhand);
    }

    public static void playEquipSound(EntityPlayer player, BetterCombatHand betterCombatHand, ItemStack itemStack, int cooldown, boolean offhand) {
        if (!ConfigurationHandler.client.customWeaponEquipSounds) {
            return;
        }
        if (!betterCombatHand.hasCustomWeapon() && !(itemStack.func_77973_b() instanceof ItemShield)) {
            return;
        }
        float volume = SoundHandler.getRandomEquipAndSheatheVolume();
        float pitch = SoundHandler.getSwingPitch(cooldown);
        if (!SoundHandler.isMetallic(itemStack)) {
            SoundHandler.playEquipOtherSound(player, volume, pitch, offhand);
            return;
        }
        switch (betterCombatHand.getSoundType()) {
            case BLADE: {
                SoundHandler.playEquipBladeSound(player, volume, pitch, offhand);
                return;
            }
            case AXE: {
                SoundHandler.playEquipAxeSound(player, volume, pitch, offhand);
                return;
            }
        }
        SoundHandler.playEquipOtherSound(player, volume, pitch, offhand);
    }

    public static void playSheatheSound(EntityPlayer player, BetterCombatHand betterCombatHand, ItemStack itemStack, int cooldown, boolean offhand) {
        if (!ConfigurationHandler.client.customWeaponSheatheSounds) {
            return;
        }
        if (!betterCombatHand.hasCustomWeapon()) {
            return;
        }
        float volume = SoundHandler.getRandomEquipAndSheatheVolume();
        float pitch = SoundHandler.getEquipAndSheathePitch(cooldown);
        if (!SoundHandler.isMetallic(itemStack)) {
            SoundHandler.playSheatheOtherSound(player, volume, pitch, offhand);
            return;
        }
        switch (betterCombatHand.getSoundType()) {
            case BLADE: {
                SoundHandler.playSheatheBladeSound(player, volume, pitch, offhand);
                return;
            }
            case AXE: {
                SoundHandler.playSheatheAxeSound(player, volume, pitch, offhand);
                return;
            }
        }
        SoundHandler.playSheatheOtherSound(player, volume, pitch, offhand);
    }

    public static void playSwingMetalBlade(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, SWING_METAL_BLADE, SWING_METAL_BLADE_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SWING_METAL_BLADE, SWING_METAL_BLADE_RIGHT, volume, pitch);
        }
    }

    public static void playSwingMetalAxe(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, SWING_METAL_AXE, SWING_METAL_AXE_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SWING_METAL_AXE, SWING_METAL_AXE_RIGHT, volume, pitch);
        }
    }

    public static void playSwingMetalBlunt(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, SWING_METAL_BLUNT, SWING_METAL_BLUNT_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SWING_METAL_BLUNT, SWING_METAL_BLUNT_RIGHT, volume, pitch);
        }
    }

    public static void playSwing2H(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, SWING_2H, SWING_2H_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SWING_2H, SWING_2H_RIGHT, volume, pitch);
        }
    }

    public static void playSwingPunch(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, SWING_NORMAL, SWING_NORMAL_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SWING_NORMAL, SWING_NORMAL_RIGHT, volume, pitch);
        }
    }

    public static void playSwingNonMetal(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (pitch <= 0.9f) {
            pitch += 0.1f;
            if (offhand) {
                SoundHandler.playSound(player, SWING_SLOW, SWING_SLOW_LEFT, volume, pitch);
            } else {
                SoundHandler.playSound(player, SWING_SLOW, SWING_SLOW_RIGHT, volume, pitch);
            }
        } else if (pitch >= 1.1f) {
            pitch -= 0.1f;
            if (offhand) {
                SoundHandler.playSound(player, SWING_QUICK, SWING_QUICK_LEFT, volume * 0.6f, pitch);
            } else {
                SoundHandler.playSound(player, SWING_QUICK, SWING_QUICK_RIGHT, volume * 0.6f, pitch);
            }
        } else if (offhand) {
            SoundHandler.playSound(player, SWING_NORMAL, SWING_NORMAL_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SWING_NORMAL, SWING_NORMAL_RIGHT, volume, pitch);
        }
    }

    private static void playEquipAxeSound(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, EQUIP_AXE, EQUIP_AXE_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, EQUIP_AXE, EQUIP_AXE_RIGHT, volume, pitch);
        }
    }

    private static void playEquipBladeSound(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, EQUIP_BLADE, EQUIP_BLADE_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, EQUIP_BLADE, EQUIP_BLADE_RIGHT, volume, pitch);
        }
    }

    private static void playEquipOtherSound(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, EQUIP_OTHER, EQUIP_OTHER_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, EQUIP_OTHER, EQUIP_OTHER_RIGHT, volume, pitch);
        }
    }

    private static void playSheatheBladeSound(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, SHEATHE_BLADE, SHEATHE_BLADE_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SHEATHE_BLADE, SHEATHE_BLADE_RIGHT, volume, pitch);
        }
    }

    private static void playSheatheAxeSound(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, SHEATHE_AXE, SHEATHE_AXE_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SHEATHE_AXE, SHEATHE_AXE_RIGHT, volume, pitch);
        }
    }

    private static void playSheatheOtherSound(EntityPlayer player, float volume, float pitch, boolean offhand) {
        if (offhand) {
            SoundHandler.playSound(player, SHEATHE_OTHER, SHEATHE_OTHER_LEFT, volume, pitch);
        } else {
            SoundHandler.playSound(player, SHEATHE_OTHER, SHEATHE_OTHER_RIGHT, volume, pitch);
        }
    }

    public static void playSound(EntityPlayer player, SoundEvent mono, SoundEvent stereo, float volume, float pitch) {
        try {
            if (player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, stereo == null || ConfigurationHandler.client.customWeaponSoundsMono ? mono : stereo, player.func_184176_by(), volume, pitch);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static float getSwingPitch(float f) {
        return 0.75f + 12.5f / f * 0.25f;
    }

    public static float getEquipAndSheathePitch(float f) {
        return 0.8f + 12.5f / f * 0.2f;
    }

    public static float getRandomSwingVolume() {
        return ConfigurationHandler.client.weaponSwingVolumeMult * (0.7f + rand.nextFloat() * 0.1f);
    }

    public static float getRandomEquipAndSheatheVolume() {
        return ConfigurationHandler.client.weaponEquipSheatheVolumeMult * (0.7f + rand.nextFloat() * 0.1f);
    }

    private static boolean isMetallic(ItemStack stack) {
        String name = String.valueOf(stack.func_77973_b().getRegistryName());
        for (String s : ConfigurationHandler.client.nonMetallicSoundWordList) {
            if (!name.contains(s)) continue;
            return false;
        }
        return true;
    }
}

