/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client.animation.util;

import bettercombat.mod.client.animation.util.BetterCombatHand;
import bettercombat.mod.util.ConfigurationHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.MathHelper;

public class CameraTransformHandler {
    private float prevProgress = 0.0f;
    private float prevPartial = 0.0f;
    private float totalDeltaPitch = 0.0f;
    private float totalDeltaYaw = 0.0f;

    public void animateCamera(BetterCombatHand hand, boolean rightHand, float swingProgress, float partialTick) {
        int i = rightHand ? 1 : -1;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.prevProgress > swingProgress) {
            player.field_70125_A -= this.totalDeltaPitch;
            player.field_70177_z -= this.totalDeltaYaw;
            this.totalDeltaPitch = 0.0f;
            this.totalDeltaYaw = 0.0f;
        }
        this.prevProgress = swingProgress;
        if (this.prevPartial <= partialTick) {
            this.prevPartial = partialTick;
            return;
        }
        this.prevPartial = partialTick;
        if (swingProgress == 0.0f || swingProgress == 1.0f) {
            return;
        }
        float rotationMult = MathHelper.func_76126_a((float)((float)Math.PI + swingProgress * 2.0f * (float)Math.PI));
        float f = (float)hand.attackCooldown / 12.0f;
        float deltaPitch = -1.0f * rotationMult * ConfigurationHandler.client.cameraPitchSwing * hand.getActiveAttackAnimation().getCameraPitchMult() * f;
        float deltaYaw = (float)i * rotationMult * ConfigurationHandler.client.cameraYawSwing * hand.getActiveAttackAnimation().getCameraYawMult() * f;
        this.totalDeltaPitch += deltaPitch;
        this.totalDeltaYaw += deltaYaw;
        player.field_70125_A += deltaPitch;
        player.field_70177_z += deltaYaw;
    }
}

