/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client.animation;

import bettercombat.mod.client.animation.util.BetterCombatHand;
import bettercombat.mod.client.animation.util.IAnimation;
import bettercombat.mod.client.handler.AnimationHandler;
import bettercombat.mod.client.handler.EventHandlersClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class AnimationDig
implements IAnimation {
    @Override
    public void animationMainhand(boolean rightHanded, float swingProgress, float partialTick) {
        this.animateSwing(rightHanded, swingProgress, partialTick, EventHandlersClient.betterCombatMainhand);
    }

    @Override
    public void animationOffhand(boolean rightHanded, float swingProgress, float partialTick) {
        this.animateSwing(!rightHanded, swingProgress, partialTick, EventHandlersClient.betterCombatOffhand);
    }

    @Override
    public void setActive(BetterCombatHand hand) {
        hand.setSwingTimestampSound(0.4f);
        hand.randomizeVariances();
    }

    private void animateSwing(boolean rightHanded, float swingProgress, float partialTick, BetterCombatHand hand) {
        int i = rightHanded ? 1 : -1;
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 0.5f - (AnimationHandler.lastTooCloseAmount + (AnimationHandler.tooCloseAmount - AnimationHandler.lastTooCloseAmount) * partialTick);
        rotateUp = -AnimationHandler.min(swingProgress * 240.0f, 60.0f);
        rotateCounterClockwise = AnimationHandler.min(swingProgress * 200.0f, 80.0f) - swingProgress * 20.0f;
        rotateLeft = AnimationHandler.min(swingProgress * 100.0f, 40.0f) - swingProgress * 20.0f;
        if (swingProgress > 0.2f) {
            if (swingProgress > 0.4f) {
                if (swingProgress > 0.8f) {
                    float energy = swingProgress - 0.8f;
                    moveRight = moveClose = -closeCap + energy * 2.5f;
                    moveUp = -moveClose;
                    energy *= energy;
                    rotateUp += AnimationHandler.minMult(energy, 25.0f, 70.0f);
                    rotateCounterClockwise -= AnimationHandler.minMult(energy, 25.0f, 30.0f);
                    rotateLeft -= AnimationHandler.minMult(energy, 25.0f, 10.0f);
                } else {
                    moveRight = moveClose = -closeCap * (swingProgress * 0.25f + 0.9f);
                    moveUp = -moveClose;
                }
            } else {
                moveRight = moveClose = (0.2f - swingProgress) * closeCap * 5.0f;
                moveUp = -moveClose - 0.25f * closeCap;
            }
        } else {
            moveClose = MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI * 5.0f)) * 0.2f;
            moveUp = -swingProgress * closeCap * 2.5f;
        }
        GlStateManager.func_179109_b((float)(0.8f * (float)i * moveRight * hand.moveRightVariance), (float)(1.125f * moveUp * hand.moveUpVariance), (float)(0.2f * moveClose * hand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(1.6f * rotateUp * hand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(0.4f * (float)i * rotateCounterClockwise * hand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(1.2f * (float)i * rotateLeft * hand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }
}

