/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.capability;

import bettercombat.mod.compat.ModLoadedUtil;
import bettercombat.mod.compat.SpartanWeaponryHandler;
import bettercombat.mod.handler.EventHandlers;
import bettercombat.mod.mixin.IEntityLivingBaseMixin;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapabilityOffhandHurtResistance
implements ICapabilityProvider {
    private int hurtResistantTimeOffhand = 0;
    private float lastDamageOffhand = 0.0f;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability != null && capability == EventHandlers.OFFHAND_HURTRESISTANCE;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability != null && capability == EventHandlers.OFFHAND_HURTRESISTANCE ? this : null);
    }

    public void tick() {
        if (this.hurtResistantTimeOffhand > 0) {
            --this.hurtResistantTimeOffhand;
        } else {
            this.lastDamageOffhand = 0.0f;
        }
    }

    public boolean attackEntityFromOffhand(Entity target, DamageSource dmgSrc, float amount) {
        if (target.field_70170_p.field_72995_K || !(target instanceof EntityLivingBase) && !(target instanceof MultiPartEntityPart)) {
            return false;
        }
        EntityLivingBase targetMain = target instanceof MultiPartEntityPart ? (EntityLivingBase)((MultiPartEntityPart)target).field_70259_a : (EntityLivingBase)target;
        if (targetMain == null || targetMain.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (!(dmgSrc.func_76346_g() instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase attacker = (EntityLivingBase)dmgSrc.func_76346_g();
        ItemStack bufferStack = attacker.func_184614_ca();
        attacker.func_184611_a(EnumHand.MAIN_HAND, attacker.func_184592_cb());
        attacker.func_184611_a(EnumHand.OFF_HAND, bufferStack);
        int mainHurtResistance = targetMain.field_70172_ad;
        float mainLastDamage = ((IEntityLivingBaseMixin)targetMain).getLastDamage();
        targetMain.field_70172_ad = this.hurtResistantTimeOffhand;
        ((IEntityLivingBaseMixin)targetMain).setLastDamage(this.lastDamageOffhand);
        boolean successfulAttack = target.func_70097_a(dmgSrc, amount);
        if (successfulAttack && ModLoadedUtil.isSpartanWeaponryLoaded()) {
            SpartanWeaponryHandler.handleSpartanQuickStrike(attacker.func_184614_ca(), target);
        }
        this.hurtResistantTimeOffhand = targetMain.field_70172_ad;
        this.lastDamageOffhand = ((IEntityLivingBaseMixin)targetMain).getLastDamage();
        targetMain.field_70172_ad = mainHurtResistance;
        ((IEntityLivingBaseMixin)targetMain).setLastDamage(mainLastDamage);
        bufferStack = attacker.func_184592_cb();
        attacker.func_184611_a(EnumHand.OFF_HAND, attacker.func_184614_ca());
        attacker.func_184611_a(EnumHand.MAIN_HAND, bufferStack);
        return successfulAttack;
    }

    public int getHurtResistantTimeOffhand() {
        return this.hurtResistantTimeOffhand;
    }

    public void setHurtResistantTimeOffhand(int hurtResistantTimeOffhand) {
        this.hurtResistantTimeOffhand = hurtResistantTimeOffhand;
    }

    public float getLastDamageOffhand() {
        return this.lastDamageOffhand;
    }

    public void setLastDamageOffhand(float lastDamageOffhand) {
        this.lastDamageOffhand = lastDamageOffhand;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(CapabilityOffhandHurtResistance.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
    }

    public static class Factory
    implements Callable<CapabilityOffhandHurtResistance> {
        @Override
        public CapabilityOffhandHurtResistance call() {
            return null;
        }
    }

    public static class Storage
    implements Capability.IStorage<CapabilityOffhandHurtResistance> {
        public NBTBase writeNBT(Capability<CapabilityOffhandHurtResistance> capability, CapabilityOffhandHurtResistance instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<CapabilityOffhandHurtResistance> capability, CapabilityOffhandHurtResistance instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

