/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.blocks;

import com.chaosthedude.realistictorches.blocks.BlockRealisticTorch;
import com.chaosthedude.realistictorches.blocks.RealisticTorchesBlocks;
import com.chaosthedude.realistictorches.config.ConfigHandler;
import com.chaosthedude.realistictorches.items.RealisticTorchesItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTorchSmoldering
extends BlockRealisticTorch {
    public static final String NAME = "torch_smoldering";

    public BlockTorchSmoldering() {
        this.func_149663_c("realistictorches.torch_smoldering");
        this.func_149715_a(0.65f);
        this.func_149675_a(true);
        this.func_149647_a(null);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float side, float hitX, float hitY) {
        if (player.func_184586_b(hand).func_77973_b() == RealisticTorchesItems.glowstonePaste) {
            world.func_175656_a(pos, this.getState(world, pos, (BlockTorch)Blocks.field_150478_aa));
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_190918_g(1);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, side, hitX, hitY);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.canBurnout()) {
            if (world.func_175727_C(pos)) {
                this.extinguish(world, pos, true);
            } else {
                world.func_175684_a(pos, (Block)this, ConfigHandler.torchBurnout / 10);
            }
        }
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        this.updateTorch(world, pos);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.extinguish(world, pos, false);
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        if (!ConfigHandler.noRelightEnabled) {
            return Item.func_150898_a((Block)RealisticTorchesBlocks.torchUnlit);
        }
        return null;
    }

    @Override
    public void extinguish(World world, BlockPos pos, boolean extinguishFully) {
        this.playExtinguishSound(world, pos);
        if (!ConfigHandler.noRelightEnabled) {
            world.func_180501_a(pos, this.getState(world, pos, RealisticTorchesBlocks.torchUnlit), 2);
        } else {
            world.func_175698_g(pos);
        }
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.7;
        double z = (double)pos.func_177952_p() + 0.5;
        double mod1 = 0.22;
        double mod2 = 0.27;
        int r = rand.nextInt(4);
        if (facing.func_176740_k().func_176722_c()) {
            EnumFacing opposite = facing.func_176734_d();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.27 * (double)opposite.func_82601_c(), y + 0.22, z + 0.27 * (double)opposite.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            if (r == 2) {
                world.func_175688_a(EnumParticleTypes.FLAME, x + 0.27 * (double)opposite.func_82601_c(), y + 0.22, z + 0.27 * (double)opposite.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (r == 2) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

