/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.items;

import com.alcatrazescapee.alcatrazcore.item.tool.ItemToolCore;
import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.client.particle.ParticleManager;
import com.alcatrazescapee.notreepunching.common.blocks.ModBlocks;
import com.alcatrazescapee.notreepunching.common.tile.TileFirePit;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class ItemFireStarter
extends ItemToolCore {
    public ItemFireStarter() {
        super(Item.ToolMaterial.WOOD, 0.5f, -2.5f);
        this.func_77656_e(10);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player != null) {
            RayTraceResult result = this.func_77621_a(worldIn, player, false);
            if (result == null) {
                return stack;
            }
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = result.func_178782_a();
                if (!worldIn.field_72995_K) {
                    stack.func_77972_a(1, entityLiving);
                    List entities = worldIn.func_72872_a(EntityItem.class, new AxisAlignedBB(pos.func_177984_a(), pos.func_177982_a(1, 2, 1)));
                    int sticks = 3;
                    int logs = 1;
                    int thatch = 1;
                    for (EntityItem drop : entities) {
                        ItemStack dropStack = drop.func_92059_d();
                        if (CoreHelpers.doesStackMatchOre((ItemStack)dropStack, (String)"kindling")) {
                            thatch -= dropStack.func_190916_E();
                            continue;
                        }
                        if (CoreHelpers.doesStackMatchOre((ItemStack)dropStack, (String)"logWood")) {
                            logs -= dropStack.func_190916_E();
                            continue;
                        }
                        if (!CoreHelpers.doesStackMatchOre((ItemStack)dropStack, (String)"stickWood")) continue;
                        sticks -= dropStack.func_190916_E();
                    }
                    if (sticks <= 0 && logs <= 0 && thatch <= 0) {
                        worldIn.func_175656_a(pos.func_177984_a(), ModBlocks.FIRE_PIT.func_176223_P());
                        TileFirePit te = (TileFirePit)CoreHelpers.getTE((IBlockAccess)worldIn, (BlockPos)pos.func_177984_a(), TileFirePit.class);
                        if (te != null) {
                            te.light(true);
                        }
                        entities.forEach(Entity::func_70106_y);
                    } else if ((double)field_77697_d.nextFloat() < ModConfig.BALANCE.fireStarterFireStartChance) {
                        worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
        return stack;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 30;
    }

    @SideOnly(value=Side.CLIENT)
    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        EntityPlayer player1;
        World world;
        RayTraceResult result;
        if ((double)field_77697_d.nextFloat() < 0.3 && (result = this.func_77621_a(world = player.func_130014_f_(), player1 = (EntityPlayer)player, false)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            Vec3d v = result.field_72307_f;
            ParticleManager.generateFireStarterSmoke(world, v);
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE;
    }
}

