/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.entities.projectiles;

import com.google.common.base.Optional;
import com.mujmajnkraft.bettersurvival.BetterSurvival;
import com.mujmajnkraft.bettersurvival.capabilities.spearsinentity.ISpearsIn;
import com.mujmajnkraft.bettersurvival.capabilities.spearsinentity.SpearsInProvider;
import com.mujmajnkraft.bettersurvival.integration.InFCompat;
import com.mujmajnkraft.bettersurvival.items.ItemSpear;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFlyingSpear
extends EntityArrow {
    private static DataParameter<ItemStack> SPEAR = EntityDataManager.func_187226_a(EntityFlyingSpear.class, (DataSerializer)DataSerializers.field_187196_f);
    private static DataParameter<Optional<UUID>> SHOOTER = EntityDataManager.func_187226_a(EntityFlyingSpear.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityFlyingSpear(World worldIn) {
        super(worldIn);
    }

    public EntityFlyingSpear(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        if (shooter instanceof EntityPlayer) {
            this.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
    }

    public void setSpear(ItemStack spear) {
        this.field_70180_af.func_187227_b(SPEAR, (Object)spear);
    }

    public ItemStack getSpear() {
        return (ItemStack)this.field_70180_af.func_187225_a(SPEAR);
    }

    public void setShooter(Entity entity) {
        this.field_70250_c = entity;
        UUID id = entity == null ? null : entity.func_110124_au();
        this.field_70180_af.func_187227_b(SHOOTER, (Object)Optional.fromNullable((Object)id));
    }

    @Nullable
    public Entity getShooter() {
        UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(SHOOTER)).orNull();
        this.field_70250_c = id == null ? null : this.field_70170_p.func_152378_a(id);
        return this.field_70250_c;
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            boolean flag = true;
            if (entity instanceof EntityPlayer) {
                boolean bl = flag = !((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            }
            if (entity instanceof EntityLivingBase && !entity.func_190530_aW() && flag && !(entity instanceof EntityEnderman) && this.getSpear().func_77973_b() instanceof ItemSpear) {
                float matModifier = 0.0f;
                if (BetterSurvival.isIafLoaded) {
                    matModifier = InFCompat.getMaterialModifier(this.getSpear(), (EntityLivingBase)entity, null, false);
                }
                this.func_70239_b(this.func_70242_d() + (double)matModifier);
            }
        }
        super.func_184549_a(raytraceResultIn);
    }

    @Nullable
    protected Entity func_184551_a(Vec3d start, Vec3d end) {
        Entity entity = super.func_184551_a(start, end);
        if (entity == this.getShooter() && this.field_70173_aa <= 10) {
            return null;
        }
        if (entity instanceof EntityLivingBase && BetterSurvival.isIafLoaded && InFCompat.isStoned((EntityLivingBase)entity)) {
            return null;
        }
        return entity;
    }

    protected void func_184548_a(EntityLivingBase living) {
        if (!living.field_70170_p.field_72995_K && this.getSpear().func_77973_b() instanceof ItemSpear) {
            if (BetterSurvival.isIafLoaded) {
                InFCompat.getMaterialModifier(this.getSpear(), living, null, true);
            }
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED && ((ItemSpear)this.getSpear().func_77973_b()).breakChance() < this.field_70146_Z.nextFloat()) {
                ISpearsIn spearsin = (ISpearsIn)living.getCapability(SpearsInProvider.SPEARSIN_CAP, null);
                if (spearsin != null && living.func_70089_S()) {
                    spearsin.addSpear(this.getSpear());
                } else {
                    this.func_70099_a(this.getSpear(), 0.1f);
                }
            }
        }
    }

    protected ItemStack func_184550_j() {
        if (this.getSpear() != null) {
            return this.getSpear();
        }
        return ItemStack.field_190927_a;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SPEAR, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(SHOOTER, (Object)Optional.absent());
        super.func_70088_a();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("Spear", (NBTBase)this.getSpear().serializeNBT());
        if (this.getShooter() != null) {
            compound.func_74778_a("shooter", this.getShooter().func_110124_au().toString());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound tag = (NBTTagCompound)compound.func_74781_a("Spear");
        this.setSpear(new ItemStack(tag));
        if (compound.func_74764_b("shooter")) {
            this.setShooter((Entity)this.field_70170_p.func_152378_a(UUID.fromString(compound.func_74779_i("shooter"))));
        }
    }
}

