/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.config;

import com.mujmajnkraft.bettersurvival.BetterSurvival;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

@Config(modid="mujmajnkraftsbettersurvival")
public class ForgeConfigHandler {
    @Config.Comment(value={"Weapon Config (server)"})
    @Config.Name(value="Weapons")
    public static final WeaponConfig weapons = new WeaponConfig();
    @Config.Comment(value={"Potion Config (server)"})
    @Config.Name(value="Potions")
    public static final PotionConfig potions = new PotionConfig();
    @Config.Comment(value={"Enchantment Config (server)"})
    @Config.Name(value="Enchantments")
    public static final EnchantmentConfig enchantments = new EnchantmentConfig();
    @Config.Comment(value={"Material Config (server)"})
    @Config.Name(value="Materials")
    public static final MaterialConfig materials = new MaterialConfig();
    @Config.Comment(value={"Client Config"})
    @Config.Name(value="Client")
    public static final ClientConfig client = new ClientConfig();

    @Mod.EventBusSubscriber(modid="mujmajnkraftsbettersurvival")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("mujmajnkraftsbettersurvival")) {
                potions.refreshCache();
                ConfigManager.sync((String)"mujmajnkraftsbettersurvival", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ClientConfig {
        @Config.Comment(value={"Prevent custom shields from messing up your FoV. This will cause problems with other mods that change FoV."})
        @Config.Name(value="Custom Shield FoV")
        public boolean fovShields = true;
        @Config.Comment(value={"Prevent FoV changes completely."})
        @Config.Name(value="Static FoV")
        public boolean staticFOV = false;
    }

    public static class WeaponConfig {
        final String damageModifierDesc = "Set damage factor for the weapon (compared to a sword of the same material).";
        final String speedModifierDesc = "Set attack delay factor for the weapon (compared to a sword)";
        @Config.Comment(value={"Extra attack reach given to spears."})
        @Config.Name(value="Spear Reach Bonus")
        @Config.RequiresMcRestart
        public float spearReachBonus = 2.0f;
        @Config.Comment(value={"Base chance that a  full-strength hammer attack stuns the target."})
        @Config.Name(value="Stun Base Chance")
        public float stunBaseChance = 0.1f;
        @Config.Comment(value={"Increased stun chance per level of the Bash enchantment"})
        @Config.Name(value="Bash Stun Modifier")
        public float bashModifier = 0.05f;
        @Config.Comment(value={"Base chance that a  full-strength battle axe attack causes the target to drop their weapon."})
        @Config.Name(value="Disarm Base Chance")
        public float disarmBaseChance = 0.1f;
        @Config.Comment(value={"Disarm chance increase per level of the Disarming enchantment"})
        @Config.Name(value="Disarming chance Modifier")
        public float disarmModifier = 0.05f;
        @Config.Comment(value={"Set damage factor for the weapon (compared to a sword of the same material)."})
        @Config.Name(value="Battle Axe Damage Factor")
        @Config.RequiresMcRestart
        public float battleAxeDmgMod = 1.6f;
        @Config.Comment(value={"Set damage factor for the weapon (compared to a sword of the same material)."})
        @Config.Name(value="Nunchaku Damage Factor")
        @Config.RequiresMcRestart
        public float nunchakuDmgMod = 0.5f;
        @Config.Comment(value={"Set damage factor for the weapon (compared to a sword of the same material)."})
        @Config.Name(value="Hammer Damage Factor")
        @Config.RequiresMcRestart
        public float hammerDmgMod = 1.2f;
        @Config.Comment(value={"Set damage factor for the weapon (compared to a sword of the same material)."})
        @Config.Name(value="Dagger Damage Factor")
        @Config.RequiresMcRestart
        public float daggerDmgMod = 0.7f;
        @Config.Comment(value={"Set damage factor for the weapon (compared to a sword of the same material)."})
        @Config.Name(value="Spear Damage Factor")
        @Config.RequiresMcRestart
        public float spearDmgMod = 0.75f;
        @Config.Comment(value={"Set damage factor for the weapon (compared to a sword of the same material)."})
        @Config.Name(value="Crossbow Damage Factor")
        public float crossbowDmgMod = 2.0f;
        @Config.Comment(value={"Set attack delay factor for the weapon (compared to a sword)"})
        @Config.Name(value="Battle Axe Attack Delay Factor")
        @Config.RequiresMcRestart
        public float battleAxeSpd = 1.25f;
        @Config.Comment(value={"Set attack delay factor for the weapon (compared to a sword)"})
        @Config.Name(value="Nunchaku Attack Delay Factor")
        @Config.RequiresMcRestart
        public float nunchakuSpd = 0.3f;
        @Config.Comment(value={"Set attack delay factor for the weapon (compared to a sword)"})
        @Config.Name(value="Hammer Attack Delay Factor")
        @Config.RequiresMcRestart
        public float hammerSpd = 1.35f;
        @Config.Comment(value={"Set attack delay factor for the weapon (compared to a sword)"})
        @Config.Name(value="Dagger Attack Delay Factor")
        @Config.RequiresMcRestart
        public float daggerSpd = 0.8f;
        @Config.Comment(value={"Set attack delay factor for the weapon (compared to a sword)"})
        @Config.Name(value="Spear Attack Delay Factor")
        @Config.RequiresMcRestart
        public float spearSpd = 1.0f;
        @Config.Comment(value={"The time it takes to load the crossbow (in ticks)"})
        @Config.Name(value="Crossbow Reloading Time")
        public int crossbowSpd = 40;
        @Config.Comment(value={"When set to false, disable Vanilla shield recipe, forcing player to use shields added by this mod."})
        @Config.Name(value="Allow Vanilla Shields")
        @Config.RequiresMcRestart
        public boolean allowVanillaShields = true;
    }

    public static class MaterialConfig {
        @Config.Comment(value={"Allows you to craft weapons from materials commonly present in mods."})
        @Config.Name(value="Modded Materials Support")
        @Config.RequiresMcRestart
        public boolean moddedMaterials = true;
        @Config.Comment(value={"Set stats of copper material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Copper Stats")
        @Config.RequiresMcRestart
        public Double[] copperStats = new Double[]{1.0, 160.0, 5.0, 1.0, 5.0};
        @Config.Comment(value={"Set stats of bronze material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Brone Stats")
        @Config.RequiresMcRestart
        public Double[] bronzeStats = new Double[]{2.0, 200.0, 6.0, 1.8, 14.0};
        @Config.Comment(value={"Set stats of invar material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Invar Stats")
        @Config.RequiresMcRestart
        public Double[] invarStats = new Double[]{2.0, 250.0, 6.5, 2.1, 10.0};
        @Config.Comment(value={"Set stats of silver material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Silver Stats")
        @Config.RequiresMcRestart
        public Double[] silverStats = new Double[]{0.0, 32.0, 12.0, 0.5, 22.0};
        @Config.Comment(value={"Set stats of electrum material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Electrum Stats")
        @Config.RequiresMcRestart
        public Double[] electrumStats = new Double[]{0.0, 32.0, 15.0, 0.6, 35.0};
        @Config.Comment(value={"Set stats of aluminium material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Aluminium Stats")
        @Config.RequiresMcRestart
        public Double[] aluminiumStats = new Double[]{2.0, 220.0, 12.0, 1.8, 14.0};
        @Config.Comment(value={"Set stats of steel material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Steel Stats")
        @Config.RequiresMcRestart
        public Double[] steelStats = new Double[]{2.0, 350.0, 6.5, 2.5, 14.0};
        @Config.Comment(value={"Set stats of signalum material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Signalum Stats")
        @Config.RequiresMcRestart
        public Double[] signalumStats = new Double[]{2.0, 500.0, 10.0, 2.0, 14.0};
        @Config.Comment(value={"Set stats of limium material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Lumium Stats")
        @Config.RequiresMcRestart
        public Double[] lumiumStats = new Double[]{2.0, 600.0, 12.0, 2.5, 14.0};
        @Config.Comment(value={"Set stats of enderium material (harvest level, durability, efficiency, damage, enchantability)"})
        @Config.Name(value="Enderium Stats")
        @Config.RequiresMcRestart
        public Double[] enderiumStats = new Double[]{3.0, 1000.0, 10.0, 4.0, 20.0};
    }

    public static class PotionConfig {
        @Config.Comment(value={"Follow range reduction for non-player entities caused by blindness (in %)"})
        @Config.Name(value="Blindness Strength")
        @Config.RangeDouble(min=0.0, max=100.0)
        public double blindnessStrength = 80.0;
        @Config.Comment(value={"List of IDs of mobs not to be affected with the follow range reduction."})
        @Config.Name(value="Blindness Blacklist")
        public String[] blindnessBlacklist = new String[]{""};
        @Config.Comment(value={"Number of hits a potion lasts for after a single dose."})
        @Config.Name(value="Potion Hits Amount")
        @Config.RangeInt(min=1, max=256)
        public int potionHits = 64;
        @Config.Comment(value={"Maximum number of hits a potion can last for after repeated doses."})
        @Config.Name(value="Maximum Potion Hits")
        @Config.RangeInt(min=1, max=512)
        public int maximumPotionHits = 64;
        @Config.Comment(value={"The value potion duration is divided by when the potion is applied onto a weapon."})
        @Config.Name(value="Potion Timer Divider")
        @Config.RangeInt(min=1, max=256)
        public int potionDivisor = 8;
        @Config.Comment(value={"List of item classes that can have potions applied onto them."})
        @Config.Name(value="Potion-Applying Weapon Whitelist")
        public String[] paWeaponWhitelist = new String[]{"net.minecraft.item.ItemSword", "com.mujmajnkraft.bettersurvival.items.ItemCustomWeapon"};
        @Config.Comment(value={"List of IDs of potions that cannot be applied onto a weapon."})
        @Config.Name(value="Potion-Applying Potion Blacklist")
        public String[] paPotionBlacklist = new String[]{""};
        private List<Class<?>> weaponWhitelist = null;

        public boolean isClassInstanceofWhitelistedWeapon(Class<?> clazz) {
            return potions.getWeaponWhitelistClasses().stream().anyMatch(w -> w.isAssignableFrom(clazz));
        }

        private List<Class<?>> getWeaponWhitelistClasses() {
            if (this.weaponWhitelist == null) {
                this.weaponWhitelist = new ArrayList();
                for (String name : this.paWeaponWhitelist) {
                    try {
                        this.weaponWhitelist.add(Class.forName(name));
                    }
                    catch (Exception ex) {
                        BetterSurvival.LOG.log(Level.WARN, "Failed to parse weapon whitelist entry: " + name);
                    }
                }
            }
            return this.weaponWhitelist;
        }

        public void refreshCache() {
            this.weaponWhitelist = null;
        }
    }

    public static class EnchantmentConfig {
        @Config.Name(value="Assassinate Max Level")
        @Config.RangeInt(min=0, max=10)
        public int assassinteLevel = 3;
        @Config.Name(value="Agility Max Level")
        @Config.RangeInt(min=0, max=10)
        public int agilityLevel = 2;
        @Config.Name(value="Arrow Recovery Max Level")
        @Config.RangeInt(min=0, max=10)
        public int arrowRecoveryLevel = 3;
        @Config.Name(value="Bash Max Level")
        @Config.RangeInt(min=0, max=10)
        public int bashLevel = 3;
        @Config.Name(value="Blast Max Level")
        @Config.RangeInt(min=0, max=10)
        public int blastLevel = 2;
        @Config.Name(value="Blocking Power Max Level")
        @Config.RangeInt(min=0, max=10)
        public int blockingPowerLevel = 3;
        @Config.Name(value="Combo Max Level")
        @Config.RangeInt(min=0, max=10)
        public int comboLevel = 3;
        @Config.Name(value="Diamonds Everywhere Max Level")
        @Config.RangeInt(min=0, max=10)
        public int diamondsEverywhereLevel = 3;
        @Config.Name(value="Disarm Max Level")
        @Config.RangeInt(min=0, max=10)
        public int disarmLevel = 1;
        @Config.Name(value="Education Max Level")
        @Config.RangeInt(min=0, max=10)
        public int educationLevel = 3;
        @Config.Name(value="Fling Max Level")
        @Config.RangeInt(min=0, max=10)
        public int flingLevel = 2;
        @Config.Name(value="Heavy Max Level")
        @Config.RangeInt(min=0, max=10)
        public int heavyLevel = 1;
        @Config.Name(value="High Jump Max Level")
        @Config.RangeInt(min=0, max=10)
        public int highJumpLevel = 2;
        @Config.Name(value="Multishot Max Level")
        @Config.RangeInt(min=0, max=10)
        public int multishotLevel = 3;
        @Config.Name(value="Penetration Max Level")
        @Config.RangeInt(min=0, max=10)
        public int penetrationLevel = 5;
        @Config.Name(value="Range Max Level")
        @Config.RangeInt(min=0, max=10)
        public int rangeLevel = 1;
        @Config.Name(value="Rapid Fire Max Level")
        @Config.RangeInt(min=0, max=10)
        public int rapidFireLevel = 5;
        @Config.Name(value="Reflection Max Level")
        @Config.RangeInt(min=0, max=10)
        public int reflectionLevel = 3;
        @Config.Name(value="Smelting Max Level")
        @Config.RangeInt(min=0, max=10)
        public int smeltingLevel = 1;
        @Config.Name(value="Spell Shield Max Level")
        @Config.RangeInt(min=0, max=10)
        public int spellShieldLevel = 3;
        @Config.Name(value="Tunneling Max Level")
        @Config.RangeInt(min=0, max=10)
        public int tunnelingLevel = 2;
        @Config.Name(value="Vampirism Max Level")
        @Config.RangeInt(min=0, max=10)
        public int vampirismLevel = 1;
        @Config.Name(value="Versatility Max Level")
        @Config.RangeInt(min=0, max=10)
        public int versatilityLevel = 1;
        @Config.Name(value="Vitality Max Level")
        @Config.RangeInt(min=0, max=10)
        public int vitalityLevel = 1;
        @Config.Name(value="Weightless Max Level")
        @Config.RangeInt(min=0, max=10)
        public int weightlessLevel = 1;
        @Config.Comment(value={"Whether or not is Assassinate enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Assassinate Treasure")
        public boolean assassinteTreasure = false;
        @Config.Comment(value={"Whether or not is Agility enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Agility Treasure")
        public boolean agilityTreasure = false;
        @Config.Comment(value={"Whether or not is Arrow Recovery enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Arrow Recovery Treasure")
        public boolean arrowRecoveryTreasure = false;
        @Config.Comment(value={"Whether or not is Bash enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Bash Treasure")
        public boolean bashTreasure = false;
        @Config.Comment(value={"Whether or not is Blast enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Blast Treasure")
        public boolean blastTreasure = false;
        @Config.Comment(value={"Whether or not is Blocking Power enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Blocking Power Treasure")
        public boolean blockingPowerTreasure = false;
        @Config.Comment(value={"Whether or not is Combo enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Combo Treasure")
        public boolean comboTreasure = false;
        @Config.Comment(value={"Whether or not is Diamonds Everywhere enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Diamonds Everywhere Treasure")
        public boolean diamondsEverywhereTreasure = false;
        @Config.Comment(value={"Whether or not is Disarm enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Disarm Treasure")
        public boolean disarmTreasure = false;
        @Config.Comment(value={"Whether or not is Education enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Education Treasure")
        public boolean educationTreasure = false;
        @Config.Comment(value={"Whether or not is this Fling a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Fling Treasure")
        public boolean flingTreasure = false;
        @Config.Comment(value={"Whether or not is Heavy enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Heavy Treasure")
        public boolean heavyTreasure = false;
        @Config.Comment(value={"Whether or not is High Jump enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is High Jump Treasure")
        public boolean highJumpTreasure = false;
        @Config.Comment(value={"Whether or not is Multishot enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Multishot Treasure")
        public boolean multishotTreasure = false;
        @Config.Comment(value={"Whether or not is Penetration enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Penetration Treasure")
        public boolean penetrationTreasure = false;
        @Config.Comment(value={"Whether or not is Range enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Range Treasure")
        public boolean rangeTreasure = false;
        @Config.Comment(value={"Whether or not is Rapid Fire enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Rapid Fire Treasure")
        public boolean rapidFireTreasure = false;
        @Config.Comment(value={"Whether or not is Reflection enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Reflection Treasure")
        public boolean reflectionTreasure = false;
        @Config.Comment(value={"Whether or not is Smelting enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Smelting Treasure")
        public boolean smeltingTreasure = false;
        @Config.Comment(value={"Whether or not is Spell Shield enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Spell Shield Treasure")
        public boolean spellShieldTreasure = false;
        @Config.Comment(value={"Whether or not is Tunneling enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Tunneling Treasure")
        public boolean tunnelingTreasure = false;
        @Config.Comment(value={"Whether or not is Vampirism enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Vampirism Treasure")
        public boolean vampirismTreasure = false;
        @Config.Comment(value={"Whether or not is this enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Versatility Treasure")
        public boolean versatilityTreasure = false;
        @Config.Comment(value={"Whether or not is Vitality enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Vitality Treasure")
        public boolean vitalityTreasure = false;
        @Config.Comment(value={"Whether or not is Weightless enchantment a treasure enchantment (exclusive to loot and trading)."})
        @Config.Name(value="is Weightless Treasure")
        public boolean weightlessTreasure = false;
        @Config.Comment(value={"Multiplier of arrow velocity for the Range enchantment."})
        @Config.Name(value="Range Multiplier")
        @Config.RangeDouble(min=1.0, max=10.0)
        public double rangeVelocity = 1.5;
        @Config.Comment(value={"Prevent Tunneling enchantment from attempting to mine TileEntities."})
        @Config.Name(value="Tunneling Ignores TileEntities")
        public boolean preventTunnelingTileEntities = true;
    }
}

