/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.qualitytools;

import com.google.common.collect.Multimap;
import com.tmtravlr.qualitytools.config.ConfigLoader;
import com.tmtravlr.qualitytools.config.CustomMaterial;
import com.tmtravlr.qualitytools.config.QualityType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class QualityToolsHelper {
    public static final String TAG_NAME_QUALITY = "Quality";
    public static final String TAG_NAME_NAME = "Name";
    public static final String TAG_NAME_COLOR = "Color";
    public static final String TAG_NAME_TYPE = "Type";
    public static final String TAG_NAME_SLOTS = "Slots";
    public static final String TAG_NAME_ATTRIBUTE_NAME = "AttributeName";
    public static final String TAG_NAME_ATTRIBUTE_MODIFIERS = "AttributeModifiers";

    public static NBTTagCompound getQualityTag(ItemStack stack) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_150297_b(TAG_NAME_QUALITY, 10)) {
            return stack.func_179543_a(TAG_NAME_QUALITY);
        }
        return new NBTTagCompound();
    }

    public static boolean hasQualityTag(ItemStack stack) {
        return stack != null && stack.func_77942_o() && stack.func_77978_p().func_150297_b(TAG_NAME_QUALITY, 10);
    }

    public static boolean generateQualityTag(ItemStack stack, boolean skipNormal) {
        if (stack != null && !stack.func_190926_b() && (stack.func_77973_b().getItemStackLimit(stack) == 1 || ConfigLoader.allowStackableItems)) {
            for (QualityType qualityType : ConfigLoader.qualityTypes.values()) {
                if (qualityType == null || !qualityType.itemMatches(stack)) continue;
                qualityType.generateQualityTag(stack, skipNormal);
                return true;
            }
        }
        return false;
    }

    public static boolean canReforgeWith(ItemStack tool, ItemStack material) {
        if (tool == null || tool.func_190926_b() || material == null || material.func_77973_b() == null) {
            return false;
        }
        if (ConfigLoader.universalReforgeItem != null && ConfigLoader.universalReforgeItem.itemMatches(material)) {
            return true;
        }
        for (CustomMaterial toolType : ConfigLoader.customReforgeMaterials.keySet()) {
            if (toolType == null || !toolType.itemMatches(tool)) continue;
            for (CustomMaterial materialType : ConfigLoader.customReforgeMaterials.get((Object)toolType)) {
                if (materialType == null || !materialType.itemMatches(material)) continue;
                return true;
            }
        }
        return ConfigLoader.useRepairItem && tool.func_77973_b().func_82789_a(tool, material);
    }

    public static void applyAttributesForSlot(EntityLivingBase entity, ItemStack stack, String slot, Multimap<String, AttributeModifier> modifiersToRemove) {
        if (stack == null || stack.func_190926_b() || entity == null) {
            return;
        }
        NBTTagCompound tag = QualityToolsHelper.getQualityTag(stack);
        if (!tag.func_82582_d()) {
            boolean hasSlot = false;
            NBTTagList slots = tag.func_150295_c(TAG_NAME_SLOTS, 8);
            for (int i = 0; i < slots.func_74745_c(); ++i) {
                if (!slots.func_150307_f(i).equalsIgnoreCase(slot)) continue;
                hasSlot = true;
            }
            if (!hasSlot) {
                return;
            }
            NBTTagList attributeList = tag.func_150295_c(TAG_NAME_ATTRIBUTE_MODIFIERS, 10);
            for (int i = 0; i < attributeList.func_74745_c(); ++i) {
                AttributeModifier modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)attributeList.func_150305_b(i));
                String attributeName = attributeList.func_150305_b(i).func_74779_i(TAG_NAME_ATTRIBUTE_NAME);
                if (modifiersToRemove.get((Object)attributeName).contains(modifier)) {
                    modifiersToRemove.get((Object)attributeName).remove(modifier);
                    continue;
                }
                IAttributeInstance entityAttribute = entity.func_110140_aT().func_111152_a(attributeName);
                if (entityAttribute == null || entityAttribute.func_180374_a(modifier)) continue;
                entityAttribute.func_111121_a(modifier);
            }
        }
    }

    public static boolean hasClassType(String itemClass, Class currentClass) {
        if (currentClass.getSimpleName().equals(itemClass)) {
            return true;
        }
        if (currentClass.getSuperclass() != null && QualityToolsHelper.hasClassType(itemClass, currentClass.getSuperclass())) {
            return true;
        }
        if (currentClass.getInterfaces() != null && currentClass.getInterfaces().length > 0) {
            for (Class<?> currentInterface : currentClass.getInterfaces()) {
                if (!QualityToolsHelper.hasClassType(itemClass, currentInterface)) continue;
                return true;
            }
        }
        return false;
    }
}

