/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.network.message;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.network.Message;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public class MessageDataSync
extends Message {
    public NBTTagCompound tags;
    public String playerName;
    public int experienceLevel;

    public MessageDataSync() {
    }

    public MessageDataSync(SHPlayerDataHandler.PlayerData data, EntityPlayer player) {
        this.tags = new NBTTagCompound();
        data.writeToNBT(this.tags);
        this.playerName = player.func_70005_c_();
        this.experienceLevel = player.field_71068_ca;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IMessage handleMessage(MessageContext context) {
        ClientTicks.scheduleAction(() -> {
            EntityPlayer player = MessageDataSync.getPlayerByName(this.playerName);
            if (player != null) {
                SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
                if (data != null) {
                    data.readFromNBT(this.tags);
                    if (Config.Player.Health.allowModify) {
                        ModifierHandler.setMaxHealth((EntityLivingBase)player, data.getMaxHealth(), 0);
                        if (data.getHealth() > 0.0f) {
                            player.func_70606_j(data.getHealth());
                        }
                    }
                }
                player.field_71068_ca = this.experienceLevel;
            }
        });
        return null;
    }

    @Nullable
    private static EntityPlayer getPlayerByName(String name) {
        World world;
        EntityPlayer localPlayer = ScalingHealth.proxy.getClientPlayer();
        if (localPlayer != null && (world = localPlayer.field_70170_p) != null) {
            return world.func_72924_a(name);
        }
        return null;
    }
}

